/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.io.WrapperInputStream;
import com.tangosol.io.WrapperOutputStream;
import com.tangosol.net.Member;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.net.security.AbstractEncryptionFilter;
import com.tangosol.net.security.BlockCipherInputStream;
import com.tangosol.net.security.BlockCipherOutputStream;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.crypto.Cipher;

@Deprecated
public class AsymmetricEncryptionFilter
extends AbstractEncryptionFilter {
    protected Key m_keyPrivate;
    protected Certificate m_certificateLocal;
    protected KeyStore m_keystore;
    protected Map m_mapMemberCertificate = Collections.synchronizedMap(new WeakHashMap());
    protected int m_cbBlockEnc;
    protected int m_cbBlockDec;
    public static final String DEFAULT_TRANSFORMATION = "RSA/ECB/PKCS1PADDING";

    @Override
    public InputStream getInputStream(InputStream stream) {
        return new IdentityInputStream(stream);
    }

    @Override
    public OutputStream getOutputStream(OutputStream stream) {
        return new IdentityOutputStream(stream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setConfig(XmlElement xml) {
        int cbBlockEnc;
        int cbBlockDec;
        Key key;
        String sAlias = xml.getSafeElement("keyAlias").getString();
        String sKeyPassword = xml.getSafeElement("keyPassword").getString();
        String sStoreType = xml.getSafeElement("storeType").getString("JKS");
        String sStorePath = xml.getSafeElement("store").getString(".keystore");
        String sStorePassword = xml.getSafeElement("storePassword").getString(sKeyPassword);
        String sTransform = xml.getSafeElement("transformation").getString(DEFAULT_TRANSFORMATION);
        String sBlockSizeEnc = xml.getSafeElement("blockSizeEncryption").getString();
        String sBlockSizeDec = xml.getSafeElement("blockSizeDecryption").getString();
        if (sAlias.length() == 0) {
            throw new IllegalArgumentException("keyAlias required");
        }
        if (sKeyPassword.length() == 0) {
            throw new IllegalArgumentException("keyPassword required");
        }
        char[] acKeyPassword = new char[sKeyPassword.length()];
        sKeyPassword.getChars(0, acKeyPassword.length, acKeyPassword, 0);
        char[] acStorePassword = new char[sStorePassword.length()];
        sStorePassword.getChars(0, acStorePassword.length, acStorePassword, 0);
        try {
            KeyStore keyStore = AsymmetricEncryptionFilter.getKeyStore(sStoreType, sStorePath, acStorePassword);
            key = keyStore.getKey(sAlias, acKeyPassword);
            if (key == null) {
                throw new IllegalArgumentException("private key not found");
            }
            this.setPrivateKey(key);
            Certificate cert = keyStore.getCertificate(sAlias);
            if (cert == null) {
                throw new IllegalArgumentException("certificate not found");
            }
            this.setCertificateLocal(cert);
            this.setKeyStore(keyStore);
            this.setCipherTransformation(sTransform);
        }
        catch (Exception e) {
            throw AsymmetricEncryptionFilter.ensureRuntimeException(e, "Error reading " + sAlias + " from keystore: " + sStorePath);
        }
        Cipher cipher = this.getCipher(2, key);
        if (sBlockSizeDec.length() == 0) {
            cbBlockDec = cipher.getBlockSize();
            if (cbBlockDec == 0) {
                if (!(key instanceof RSAKey)) throw new IllegalArgumentException("unable to determine cipher block size for decryption; please specify blockSizeDecryption");
                cbBlockDec = (((RSAKey)((Object)key)).getModulus().bitLength() + 7) / 8;
            }
        } else {
            cbBlockDec = Integer.parseInt(sBlockSizeDec);
        }
        this.setDecryptionBlockSize(cbBlockDec);
        if (sBlockSizeEnc.length() == 0) {
            cipher = this.getCipher(1, key);
            cbBlockEnc = cipher.getBlockSize();
            if (cbBlockEnc == 0) {
                if (!(key instanceof RSAKey) || !sTransform.toUpperCase().endsWith("PKCS1PADDING")) throw new IllegalArgumentException("unable to determine cipher block size for encryption; please specify blockSizeEncryption");
                cbBlockEnc = cbBlockDec - 11;
            }
        } else {
            cbBlockEnc = Integer.parseInt(sBlockSizeEnc);
        }
        this.setEncryptionBlockSize(cbBlockEnc);
    }

    protected Certificate getCertificate(Member member) {
        return (Certificate)this.m_mapMemberCertificate.get(member);
    }

    protected void setCertificate(Member member, Certificate cert) {
        this.m_mapMemberCertificate.put(member, cert);
    }

    protected void validate(Certificate cert) {
        block5: {
            try {
                if (this.getKeyStore().getCertificateAlias(cert) == null) {
                    Base.err("unknown peer certificate: " + cert);
                    throw new SecurityException();
                }
                if (!(cert instanceof X509Certificate)) break block5;
                try {
                    ((X509Certificate)cert).checkValidity();
                }
                catch (Exception e) {
                    Base.err("Certificate expired: " + e.getMessage());
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                Base.err(e.getMessage());
                throw new SecurityException();
            }
        }
    }

    public byte[] encryptPrivate(byte[] abData, Member member) {
        Certificate cert = this.getCertificate(member);
        if (cert == null) {
            throw new SecurityException("No certificate for member " + member);
        }
        try {
            return this.makeCipher(1, cert.getPublicKey()).doFinal(abData);
        }
        catch (Exception e) {
            throw AsymmetricEncryptionFilter.ensureRuntimeException(e);
        }
    }

    public byte[] decryptPrivate(byte[] abEnc) {
        try {
            return this.makeCipher(2, this.getPrivateKey()).doFinal(abEnc);
        }
        catch (Exception e) {
            throw AsymmetricEncryptionFilter.ensureRuntimeException(e);
        }
    }

    protected void setPrivateKey(Key key) {
        this.m_keyPrivate = key;
    }

    protected Key getPrivateKey() {
        return this.m_keyPrivate;
    }

    protected void setCertificateLocal(Certificate cert) {
        this.m_certificateLocal = cert;
    }

    protected Certificate getCertificateLocal() {
        return this.m_certificateLocal;
    }

    protected void setKeyStore(KeyStore keystore) {
        this.m_keystore = keystore;
    }

    protected KeyStore getKeyStore() {
        return this.m_keystore;
    }

    protected void setDecryptionBlockSize(int cb) {
        this.m_cbBlockDec = cb;
    }

    protected int getDecryptionBlockSize() {
        return this.m_cbBlockDec;
    }

    protected void setEncryptionBlockSize(int cb) {
        this.m_cbBlockEnc = cb;
    }

    protected int getEncryptionBlockSize() {
        return this.m_cbBlockEnc;
    }

    public class IdentityOutputStream
    extends WrapperOutputStream
    implements ProtocolAwareStream {
        protected OutputStream m_streamInner;

        public IdentityOutputStream(OutputStream stream) {
            this.m_streamInner = stream;
        }

        @Override
        public void setProtocolContext(ProtocolAwareStream.ProtocolContext context) {
            try {
                this.writeIdentity();
                Cipher cipher = AsymmetricEncryptionFilter.this.getCipher(1, AsymmetricEncryptionFilter.this.getPrivateKey());
                this.setOutputStream(new BlockCipherOutputStream(this.m_streamInner, cipher, AsymmetricEncryptionFilter.this.getEncryptionBlockSize()));
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        protected void writeIdentity() {
            try {
                OutputStream streamInner = this.m_streamInner;
                if (!(streamInner instanceof DataOutputStream)) {
                    this.m_streamInner = streamInner = new DataOutputStream(streamInner);
                }
                Certificate cert = AsymmetricEncryptionFilter.this.getCertificateLocal();
                ExternalizableHelper.writeUTF((DataOutputStream)streamInner, cert.getType());
                ExternalizableHelper.writeByteArray((DataOutputStream)streamInner, cert.getEncoded());
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }
    }

    public class IdentityInputStream
    extends WrapperInputStream
    implements ProtocolAwareStream {
        protected InputStream m_streamInner;
        protected ProtocolAwareStream.ProtocolContext m_context;
        protected Certificate m_certificate;

        public IdentityInputStream(InputStream stream) {
            this.m_streamInner = stream;
        }

        @Override
        public void setProtocolContext(ProtocolAwareStream.ProtocolContext context) {
            this.m_context = context;
            try {
                Certificate cert = this.m_certificate = this.readIdentity();
                AsymmetricEncryptionFilter.this.validate(cert);
                PublicKey keyPublic = cert.getPublicKey();
                Cipher cipher = AsymmetricEncryptionFilter.this.getCipher(2, keyPublic);
                cipher.init(2, keyPublic);
                this.setInputStream(new BlockCipherInputStream(this.m_streamInner, cipher, AsymmetricEncryptionFilter.this.getDecryptionBlockSize()));
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e);
            }
        }

        protected Certificate readIdentity() {
            try {
                InputStream streamInner = this.m_streamInner;
                if (!(streamInner instanceof DataInputStream)) {
                    this.m_streamInner = streamInner = new DataInputStream(streamInner);
                }
                String sType = ExternalizableHelper.readUTF((DataInputStream)streamInner);
                byte[] abCert = ExternalizableHelper.readByteArray((DataInputStream)streamInner);
                return CertificateFactory.getInstance(sType).generateCertificate(new ByteArrayInputStream(abCert));
            }
            catch (Exception e) {
                throw AbstractEncryptionFilter.ensureSecurityException(e, "error reading identity from stream");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                AsymmetricEncryptionFilter.this.setCertificate(this.m_context.getFromMember(), this.m_certificate);
            }
            finally {
                super.close();
            }
        }
    }
}

