/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.internal.net.socketbus.SharedBuffer;
import com.oracle.common.internal.net.socketbus.SocketMessageBus;
import com.oracle.common.io.SingleBufferSequence;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.Event;

public class SingleBufferMessageEvent
extends SingleBufferSequence
implements Event {
    protected final SocketMessageBus.MessageConnection m_src;
    protected final SharedBuffer m_bufferShared;

    public SingleBufferMessageEvent(SocketMessageBus.MessageConnection src, SharedBuffer buffer) {
        super(null, buffer.get().slice());
        this.m_src = src;
        this.m_bufferShared = buffer;
    }

    @Override
    public Event.Type getType() {
        return Event.Type.MESSAGE;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.m_src.getPeer();
    }

    @Override
    public Object getContent() {
        return this;
    }

    @Override
    public void dispose() {
        this.m_src.onMessageDispose(this);
        this.m_bufferShared.dispose();
        this.m_buffer = null;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " event for " + this.getEndPoint() + " containing " + this.getLength() + " bytes";
    }
}

