/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.common.base.Collector;
import com.oracle.common.base.Disposable;
import com.oracle.common.io.BufferManagers;
import com.oracle.common.io.BufferSequence;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.MessageBus;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler$Connection;
import com.tangosol.coherence.component.net.MessageHandler$EventCollector;
import com.tangosol.coherence.component.net.MessageHandler$OutgoingQueue;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.BufferManagerAdapter;
import com.tangosol.io.MultiBufferReadBuffer;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.nio.ByteBufferReadBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.Continuation;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class MessageHandler
extends Net {
    public static final int STATE_CLOSED = 4;
    public static final int STATE_CLOSING = 3;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_OPEN = 2;
    public static final int STATE_OPENING = 1;
    private transient Map __m_ConnectionMap;
    private Queue __m_DatagramQueue;
    private Collector __m_EventCollector;
    private boolean __m_GlobalBacklog;
    private Queue __m_IncomingQueue;
    private boolean __m_LocalBacklog;
    private MessageBus __m_MessageBus;
    private Queue __m_OutgoingQueue;
    private AtomicBoolean __m_PendingDatagramFlush;
    private Grid __m_Service;
    private volatile int __m_State;
    private static ListMap __mapChildren;

    static {
        MessageHandler.__initStatic();
    }

    public MessageHandler() {
        this(null, null, true);
    }

    public MessageHandler(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setConnectionMap(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new MessageHandler$EventCollector("EventCollector", this, true), "EventCollector");
        this._addChild(new MessageHandler$OutgoingQueue("OutgoingQueue", this, true), "OutgoingQueue");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_PendingDatagramFlush = new AtomicBoolean();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Connection", MessageHandler$Connection.get_CLASS());
    }

    public void close() {
        this.setState(STATE_CLOSING);
        this.getMessageBus().close();
    }

    public MessageHandler$Connection connect(Member member, EndPoint peer, Continuation continuation) {
        Component._assert(!(member != null) ? false : peer != null);
        MessageHandler$Connection connect = this.ensureConnection(peer);
        connect.setPeer(peer);
        try {
            connect.connect(member, continuation);
        }
        catch (IllegalArgumentException e) {
            Component._trace(String.valueOf("Unable to connect to ") + peer + " using " + this.getMessageBus().getLocalEndPoint() + " (" + e.getMessage() + "), falling back on default cluster transport", 2);
            this.getConnectionMap().remove(peer);
            connect = null;
        }
        return connect;
    }

    public void connectAll() {
        long cWaitMillis;
        Grid service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        Member memberThis = service.getThisMember();
        ArrayList<MessageHandler$Connection> listConnect = new ArrayList<MessageHandler$Connection>(setMembers.size());
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            MessageHandler$Connection connect;
            int nMember;
            EndPoint peer;
            Member member = (Member)iter.next();
            if (!(member != memberThis) || !((peer = setMembers.getServiceEndPoint(nMember = member.getId())) == null) || !((peer = service.resolveEndPoint(setMembers.getServiceEndPointName(nMember), member)) != null) || !((connect = this.connect(member, peer, null)) != null)) continue;
            setMembers.setServiceEndPoint(nMember, peer);
            listConnect.add(connect);
        }
        long ldtStart = System.currentTimeMillis();
        long cWait = cWaitMillis = service.getRequestTimeout();
        Iterator iter2 = listConnect.iterator();
        while (iter2.hasNext()) {
            ((MessageHandler$Connection)iter2.next()).waitForState(MessageHandler$Connection.STATE_CONNECTED, cWait);
            if (!(cWaitMillis > (long)0)) continue;
            cWait = service.checkRequestTimeout(ldtStart, cWaitMillis);
        }
    }

    protected ReadBuffer createReadBuffer(BufferSequence bufseq) {
        int cBuffers = bufseq.getBufferCount();
        if (cBuffers == 1) {
            return new ByteBufferReadBuffer(bufseq.getBuffer(0));
        }
        ReadBuffer[] abuf = new ReadBuffer[cBuffers];
        int i = 0;
        while (i < cBuffers) {
            abuf[i] = new ByteBufferReadBuffer(bufseq.getBuffer(i));
            ++i;
        }
        return new MultiBufferReadBuffer(abuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainOverflow(Message msg) {
        MemberSet setTo = msg.getToMemberSet();
        Grid service = this.getService();
        ServiceMemberSet setMember = service.getServiceMemberSet();
        long cMillis = service.calculateDeferrableMillis(msg);
        long ldtTimeout = cMillis == 0L ? Long.MAX_VALUE : Base.getSafeTimeMillis() + cMillis;
        try {
            if (this.isGlobalBacklog()) {
                MessageHandler messageHandler = this;
                synchronized (messageHandler) {
                    while (!(cMillis >= 0L) ? false : this.isGlobalBacklog()) {
                        this.wait(cMillis);
                        cMillis = Base.computeSafeWaitTime(ldtTimeout);
                    }
                }
            }
            if (this.isLocalBacklog()) {
                EndPoint pointLocal;
                EndPoint endPoint = pointLocal = this.getMessageBus().getLocalEndPoint();
                synchronized (endPoint) {
                    while (!(cMillis >= 0L) ? false : this.isLocalBacklog()) {
                        pointLocal.wait(cMillis);
                        cMillis = Base.computeSafeWaitTime(ldtTimeout);
                    }
                }
            }
            switch (setTo.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    int nMemberTo = setTo.getFirstId();
                    if (!(nMemberTo != 0) ? false : setMember.isServiceBacklogged(nMemberTo)) {
                        EndPoint peer;
                        EndPoint endPoint = peer = setMember.getServiceEndPoint(nMemberTo);
                        synchronized (endPoint) {
                            while (!(cMillis >= 0L) ? false : setMember.isServiceBacklogged(nMemberTo)) {
                                peer.wait(cMillis);
                                cMillis = Base.computeSafeWaitTime(ldtTimeout);
                            }
                        }
                    }
                    break;
                }
                default: {
                    int[] aId = setTo.toIdArray();
                    int i = 0;
                    int c = aId.length;
                    while (i < c) {
                        int nMemberTo = aId[i];
                        if (setMember.isServiceBacklogged(nMemberTo)) {
                            EndPoint peer;
                            EndPoint endPoint = peer = setMember.getServiceEndPoint(nMemberTo);
                            synchronized (endPoint) {
                                while (!(cMillis >= 0L) ? false : setMember.isServiceBacklogged(nMemberTo)) {
                                    peer.wait(cMillis);
                                    cMillis = Base.computeSafeWaitTime(ldtTimeout);
                                }
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized MessageHandler$Connection ensureConnection(EndPoint peer) {
        Map mapConnect = this.getConnectionMap();
        MessageHandler$Connection connect = (MessageHandler$Connection)mapConnect.get(peer);
        if (connect == null) {
            Map map = mapConnect;
            synchronized (map) {
                connect = (MessageHandler$Connection)mapConnect.get(peer);
                if (connect == null) {
                    connect = this.instantiateConnection(peer);
                    mapConnect.put(peer, connect);
                }
            }
        }
        return connect;
    }

    public void flush() {
        this.getMessageBus().flush();
        if (this.getPendingDatagramFlush().compareAndSet(true, false)) {
            this.getDatagramQueue().flush();
        }
    }

    public Map getConnectionMap() {
        return this.__m_ConnectionMap;
    }

    public Queue getDatagramQueue() {
        return this.__m_DatagramQueue;
    }

    public Collector getEventCollector() {
        return this.__m_EventCollector;
    }

    public Queue getIncomingQueue() {
        return this.__m_IncomingQueue;
    }

    public MessageBus getMessageBus() {
        return this.__m_MessageBus;
    }

    public Queue getOutgoingQueue() {
        return this.__m_OutgoingQueue;
    }

    protected AtomicBoolean getPendingDatagramFlush() {
        return this.__m_PendingDatagramFlush;
    }

    public Grid getService() {
        return this.__m_Service;
    }

    public int getState() {
        return this.__m_State;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/MessageHandler".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new MessageHandler();
    }

    private final Component get_Module() {
        return this;
    }

    public void initialize(Grid service, MessageBus bus, Queue queueDatagramOut) {
        Component._assert(this.getService() == null, "Already initialized");
        Component._assert(this.getState() == STATE_INITIAL);
        this.setService(service);
        this.setMessageBus(bus);
        this.setDatagramQueue(queueDatagramOut);
        this.setIncomingQueue(service.getQueue());
        this.setState(STATE_OPENING);
        bus.setEventCollector(this.getEventCollector());
        bus.open();
        this.waitForState(STATE_OPEN, this.getService().getRequestTimeout());
    }

    protected MessageHandler$Connection instantiateConnection(EndPoint peer) {
        MessageHandler$Connection connect = (MessageHandler$Connection)this._newChild("Connection");
        connect.setPeer(peer);
        return connect;
    }

    public boolean isGlobalBacklog() {
        return this.__m_GlobalBacklog;
    }

    public boolean isLocalBacklog() {
        return this.__m_LocalBacklog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBacklog(EndPoint peer, boolean fExcessive) {
        EndPoint pointLocal = this.getMessageBus().getLocalEndPoint();
        if (peer == null) {
            if (fExcessive) {
                this.setGlobalBacklog(true);
            } else {
                MessageHandler messageHandler = this;
                synchronized (messageHandler) {
                    this.setGlobalBacklog(false);
                    this.notifyAll();
                }
            }
        } else if (peer.equals(pointLocal)) {
            if (fExcessive) {
                this.setLocalBacklog(true);
            } else {
                EndPoint endPoint = pointLocal;
                synchronized (endPoint) {
                    this.setLocalBacklog(false);
                    pointLocal.notifyAll();
                }
            }
        } else {
            ServiceMemberSet setMember = this.getService().getServiceMemberSet();
            MessageHandler$Connection connect = this.ensureConnection(peer);
            Member member = connect.getMember();
            if (member != null) {
                if (fExcessive) {
                    setMember.setServiceBacklogged(member.getId(), true);
                } else {
                    EndPoint endPoint = peer = connect.getPeer();
                    synchronized (endPoint) {
                        setMember.setServiceBacklogged(member.getId(), false);
                        peer.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(EndPoint pointLocal) {
        Object object = this;
        synchronized (object) {
            Component._assert(this.getState() == STATE_CLOSING);
            this.setGlobalBacklog(false);
            this.setState(STATE_CLOSED);
            this.notifyAll();
        }
        object = pointLocal;
        synchronized (object) {
            this.setLocalBacklog(false);
            pointLocal.notifyAll();
        }
    }

    public void onConnect(EndPoint peer) {
        this.ensureConnection(peer).onConnected();
    }

    public void onDisconnect(EndPoint peer, Throwable tReason) {
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (conn == null) {
            Component._trace(String.valueOf("Unknown peer: ") + peer, 1);
            return;
        }
        if (!(this.getState() != STATE_CLOSING) ? false : conn.getState() != MessageHandler$Connection.STATE_DISCONNECTING) {
            Component._trace(String.valueOf("Unexpected Disconnect event: ") + conn + (tReason == null ? " (local)" : String.valueOf(" (") + tReason.getMessage() + ")"), tReason == null ? 1 : 6);
        }
        conn.setState(MessageHandler$Connection.STATE_DISCONNECTED);
        conn.setDisconnectCause(tReason);
    }

    public void onException(Throwable e) {
        this.getService().onException(e);
    }

    public void onInit() {
        super.onInit();
        this.setOutgoingQueue((MessageHandler$OutgoingQueue)this._findChild("OutgoingQueue"));
        this.setEventCollector((MessageHandler$EventCollector)this._findChild("EventCollector"));
    }

    public void onMemberLeft(Member member, EndPoint peer) {
        MessageHandler$Connection conn;
        if (peer != null && (conn = (MessageHandler$Connection)this.getConnectionMap().get(peer)) != null) {
            conn.release();
        }
    }

    public void onMessage(EndPoint peer, BufferSequence bufseq, Disposable controller) throws IOException {
        MessageHandler$Connection connect = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (connect == null) {
            Component._trace(String.valueOf("Discarding a message from unknown peer: ") + peer, 4);
            controller.dispose();
            Component._assert(false);
            return;
        }
        int nState = connect.getState();
        if (nState > MessageHandler$Connection.STATE_CONNECTED) {
            controller.dispose();
            Component._assert(nState <= MessageHandler$Connection.STATE_DISCONNECTING);
            return;
        }
        ReadBuffer buffer = this.createReadBuffer(bufseq);
        ReadBuffer.BufferInput input = buffer.getBufferInput();
        int nMessageType = input.readInt();
        input.setOffset(0);
        Grid service = this.getService();
        Message msg = service.instantiateMessage(nMessageType);
        msg.setBufferController(controller);
        msg.setReadBuffer(buffer);
        msg.setDeserializationRequired(true);
        if (connect.isDeferring()) {
            connect.onDeferredMessage(msg);
        } else {
            msg.setFromMember(connect.getMember());
            if (service.deserializeMessage(msg)) {
                this.getIncomingQueue().add(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen() {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            Component._assert(this.getState() == STATE_OPENING);
            this.setState(STATE_OPEN);
            this.notifyAll();
        }
    }

    public void onReceipt(EndPoint peer, Object oReceipt) {
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().get(peer);
        if (conn == null) {
            Component._trace(String.valueOf("Unknown peer: ") + peer, 1);
            return;
        }
        conn.onReceipt(oReceipt);
    }

    public void onReleased(EndPoint peer) {
        this.onBacklog(peer, false);
        MessageHandler$Connection conn = (MessageHandler$Connection)this.getConnectionMap().remove(peer);
        if (conn == null) {
            Component._trace(String.valueOf("Unknown peer: ") + peer, 1);
            return;
        }
        conn.onReleased();
    }

    public void processReceipt(Object oReceipt) {
        Message msg = (Message)oReceipt;
        msg.releaseOutgoing();
        msg.checkNotifySent();
    }

    public boolean send(Message msg) {
        Grid service = this.getService();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        msg.validateAddressing(setMembers);
        MemberSet setMemberTo = msg.getToMemberSet();
        Component._assert(setMemberTo != null, "MessageBus cannot be used to broadcast");
        switch (setMemberTo.size()) {
            case 0: {
                return false;
            }
            case 1: {
                int nMemberTo = setMemberTo.getFirstId();
                if (nMemberTo == 0) {
                    return false;
                }
                EndPoint peer = setMembers.getServiceEndPoint(nMemberTo);
                if (peer == null) {
                    if (this.getDatagramQueue().add(msg)) {
                        this.getPendingDatagramFlush().set(true);
                        return true;
                    }
                    return false;
                }
                if (!((this.isGlobalBacklog() ? true : this.isLocalBacklog()) ? true : setMembers.isServiceBacklogged(nMemberTo)) ? false : service.isClusterThread(true) ^ true) {
                    this.drainOverflow(msg);
                }
                BufferSequence bufseq = this.serializeMessage(msg);
                try {
                    this.getMessageBus().send(peer, bufseq, msg);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    if (setMembers.contains(nMemberTo)) {
                        throw e;
                    }
                    this.processReceipt(msg);
                    return false;
                }
            }
        }
        if (service.isClusterThread(true) ^ true) {
            this.drainOverflow(msg);
        }
        return this.sendMulti(msg);
    }

    protected boolean sendMulti(Message msg) {
        DependentMemberSet setMemberTo = (DependentMemberSet)msg.getToMemberSet();
        Grid service = this.getService();
        MessageBus bus = this.getMessageBus();
        EndPoint pointLocal = bus.getLocalEndPoint();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        BufferSequence bufseq = null;
        int cDatagram = 0;
        boolean fSent = false;
        msg.setBufferUsageCounter(setMemberTo.size());
        Iterator iter = setMemberTo.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            if (!(member != null)) continue;
            EndPoint peer = setMembers.getServiceEndPoint(member.getId());
            if (peer == null) {
                ++cDatagram;
                continue;
            }
            iter.remove();
            if (bufseq == null) {
                bufseq = this.serializeMessage(msg);
            }
            try {
                bus.send(peer, bufseq, msg);
                fSent = true;
            }
            catch (IllegalArgumentException e) {
                if (setMembers.contains(member)) {
                    throw e;
                }
                this.processReceipt(msg);
            }
        }
        if (cDatagram > 0) {
            if (bufseq != null) {
                msg.setReadBuffer(this.createReadBuffer(bufseq));
            }
            if (this.getDatagramQueue().add(msg)) {
                fSent = true;
                this.getPendingDatagramFlush().set(true);
                --cDatagram;
            }
            int i = 0;
            while (i < cDatagram) {
                msg.releaseOutgoing();
                ++i;
            }
        }
        return fSent;
    }

    protected BufferSequence serializeMessage(Message msg) {
        BufferManagerAdapter adapter = new BufferManagerAdapter(BufferManagers.getNetworkDirectManager());
        try {
            msg.getService().serializeMessage(msg, new MultiBufferWriteBuffer(adapter).getBufferOutput());
        }
        catch (Throwable e) {
            adapter.toBufferSequence().dispose();
            throw Base.ensureRuntimeException(e);
        }
        BufferSequence bufseq = adapter.toBufferSequence();
        msg.setBufferController(bufseq);
        return bufseq;
    }

    protected void setConnectionMap(Map map) {
        this.__m_ConnectionMap = map;
    }

    protected void setDatagramQueue(Queue queue) {
        this.__m_DatagramQueue = queue;
    }

    protected void setEventCollector(Collector collector) {
        this.__m_EventCollector = collector;
    }

    public void setGlobalBacklog(boolean pGlobalBacklog) {
        this.__m_GlobalBacklog = pGlobalBacklog;
    }

    protected void setIncomingQueue(Queue queue) {
        this.__m_IncomingQueue = queue;
    }

    public void setLocalBacklog(boolean pGlobalBacklog) {
        this.__m_LocalBacklog = pGlobalBacklog;
    }

    protected void setMessageBus(MessageBus bus) {
        this.__m_MessageBus = bus;
    }

    protected void setOutgoingQueue(Queue queue) {
        this.__m_OutgoingQueue = queue;
    }

    private void setPendingDatagramFlush(AtomicBoolean atomic) {
        this.__m_PendingDatagramFlush = atomic;
    }

    protected void setService(Grid service) {
        this.__m_Service = service;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + " {Service=" + this.getService().getServiceName() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForState(int nState, long cWaitMillis) {
        Grid service = this.getService();
        long ldtStart = System.currentTimeMillis();
        long cWait = cWaitMillis;
        while (true) {
            MessageHandler messageHandler = this;
            synchronized (messageHandler) {
                if (this.getState() >= nState) return;
                boolean bl = false;
                if (bl) {
                    return;
                }
                Base.wait(this, cWait);
            }
            if (this.getState() >= nState) return;
            boolean bl = false;
            if (bl) {
                return;
            }
            if (!(cWaitMillis > (long)0)) continue;
            cWait = service.checkRequestTimeout(ldtStart, cWaitMillis);
        }
    }
}

