/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.LocalCache$BackingMapContext;
import com.tangosol.coherence.component.util.LocalCache$CacheHandler;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.Member;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.ServiceInfo;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.WrapperException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LocalCache
extends Util
implements CacheService,
ServiceInfo {
    private transient LocalCache$BackingMapContext __m_BackingMapContext;
    private transient BackingMapManager __m_BackingMapManager;
    private transient Map __m_CacheHandlerMap;
    private transient Cluster __m_Cluster;
    private ClassLoader __m_ContextClassLoader;
    private long __m_LockWaitMillis;
    private boolean __m_LockingEnforced;
    private transient boolean __m_Running;
    private transient Serializer __m_Serializer;
    private Listeners __m_ServiceListeners;
    private String __m_ServiceName;
    private String __m_ServiceType;
    private String __m_ServiceVersion;
    private Object __m_UserContext;
    private static ListMap __mapChildren;

    static {
        LocalCache.__initStatic();
    }

    public LocalCache() {
        this(null, null, true);
    }

    public LocalCache(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setCacheHandlerMap(new SafeHashMap());
            this.setLockingEnforced(false);
            this.setLockWaitMillis(0L);
            this.setServiceListeners(new Listeners());
            this.setServiceType("LocalCache");
            this.setServiceVersion("2.2");
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("BackingMapContext", LocalCache$BackingMapContext.get_CLASS());
        Class clazz2 = __mapChildren.put("CacheHandler", LocalCache$CacheHandler.get_CLASS());
    }

    public void addMemberListener(MemberListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addServiceListener(ServiceListener listener) {
        this.getServiceListeners().add(listener);
    }

    public void configure(XmlElement xml) {
        if (xml != null) {
            this.setLockingEnforced(xml.getSafeElement("lock-enforce").getBoolean());
            this.setLockWaitMillis(xml.getSafeElement("lock-wait").getLong());
        }
    }

    public void destroyCache(NamedCache map) {
        LocalCache$CacheHandler handler = (LocalCache$CacheHandler)map;
        this.getCacheHandlerMap().remove(handler.getCacheName());
        handler.invalidate();
    }

    public synchronized NamedCache ensureCache(String sName, ClassLoader loader) {
        LocalCache$CacheHandler handler;
        Map mapCache = this.getCacheHandlerMap();
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if ((handler = (LocalCache$CacheHandler)mapCache.get(sName)) == null) {
            BackingMapManager manager = this.getBackingMapManager();
            Map map = manager == null ? new SafeHashMap() : manager.instantiateBackingMap(sName);
            if (map == null) {
                throw new RuntimeException(String.valueOf("BackingMapManager returned \"null\" for map ") + sName);
            }
            handler = (LocalCache$CacheHandler)this._newChild("CacheHandler");
            handler._initFeed(map, this.isLockingEnforced(), this.getLockWaitMillis());
            handler.setCacheName(sName);
            mapCache.put(sName, handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalCache$BackingMapContext getBackingMapContext() {
        LocalCache$BackingMapContext context = this.__m_BackingMapContext;
        if (context == null) {
            LocalCache localCache = this;
            synchronized (localCache) {
                context = this.__m_BackingMapContext;
                if (context == null) {
                    context = (LocalCache$BackingMapContext)this._newChild("BackingMapContext");
                    this.setBackingMapContext(context);
                }
            }
        }
        return context;
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public Map getCacheHandlerMap() {
        return this.__m_CacheHandlerMap;
    }

    public Enumeration getCacheNames() {
        return new IteratorEnumerator(this.getCacheHandlerMap().keySet().iterator());
    }

    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    public ServiceInfo getInfo() {
        return this;
    }

    public long getLockWaitMillis() {
        return this.__m_LockWaitMillis;
    }

    public Member getOldestMember() {
        return null;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public Listeners getServiceListeners() {
        return this.__m_ServiceListeners;
    }

    public Member getServiceMember(int nId) {
        return null;
    }

    public Set getServiceMembers() {
        return NullImplementation.getSet();
    }

    public String getServiceName() {
        return this.__m_ServiceName;
    }

    public String getServiceType() {
        return this.__m_ServiceType;
    }

    public String getServiceVersion() {
        return this.__m_ServiceVersion;
    }

    public String getServiceVersion(Member member) {
        return this.getServiceVersion();
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/LocalCache".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new LocalCache();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isLockingEnforced() {
        return this.__m_LockingEnforced;
    }

    public boolean isRunning() {
        return this.__m_Running;
    }

    public void releaseCache(NamedCache map) {
        this.destroyCache(map);
    }

    public void removeMemberListener(MemberListener listener) {
    }

    public void removeServiceListener(ServiceListener listener) {
        this.getServiceListeners().remove(listener);
    }

    protected void setBackingMapContext(LocalCache$BackingMapContext ctx) {
        this.__m_BackingMapContext = ctx;
    }

    public void setBackingMapManager(BackingMapManager manager) {
        if (this.isRunning()) {
            throw new IllegalStateException("Service is already running");
        }
        this.__m_BackingMapManager = manager;
    }

    protected void setCacheHandlerMap(Map map) {
        this.__m_CacheHandlerMap = map;
    }

    public void setCluster(Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    public void setLockWaitMillis(long cWaitMillis) {
        this.__m_LockWaitMillis = cWaitMillis;
    }

    public void setLockingEnforced(boolean fEnforced) {
        this.__m_LockingEnforced = fEnforced;
    }

    protected void setRunning(boolean fRunning) {
        this.__m_Running = fRunning;
    }

    protected void setSerializer(Serializer serializer) {
        this.__m_Serializer = serializer;
    }

    protected void setServiceListeners(Listeners listeners) {
        this.__m_ServiceListeners = listeners;
    }

    public void setServiceName(String sName) {
        this.__m_ServiceName = sName;
    }

    protected void setServiceType(String sType) {
        this.__m_ServiceType = sType;
    }

    protected void setServiceVersion(String sVersion) {
        this.__m_ServiceVersion = sVersion;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public void shutdown() {
        this.stop();
    }

    public synchronized void start() {
        this.setRunning(true);
        BackingMapManager manager = this.getBackingMapManager();
        if (manager != null) {
            LocalCache$BackingMapContext ctx = this.getBackingMapContext();
            ctx.setManager(manager);
            manager.init(ctx);
        }
        this.setSerializer(ExternalizableHelper.ensureSerializer(this.getContextClassLoader()));
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            Map mapHandler = this.getCacheHandlerMap();
            Iterator iter = mapHandler.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                LocalCache$CacheHandler handler = (LocalCache$CacheHandler)entry.getValue();
                handler.invalidate();
                iter.remove();
            }
            ServiceEvent event = new ServiceEvent(this, ServiceEvent.SERVICE_STOPPED);
            event.dispatch(this.getServiceListeners());
            this.setRunning(false);
        }
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + '{' + this.getServiceName() + '}';
    }
}

