/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.udpPacket.OutgoingUdpPacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue$Iterator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketSpeaker$BundlingQueue$TargetQueue;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class PacketSpeaker$BundlingQueue
extends BundlingQueue {
    public static final Object MULTIPOINT_TARGET;
    private int __m_BalancePoint;
    private transient int __m_PendingAsyncFlushCount;
    private transient int __m_SynchronousAddCount;
    private transient int __m_SynchronousSendCount;
    private transient int __m_VolumeThreshold;
    private transient boolean __m_VolumeTunable;
    private static ListMap __mapChildren;

    static {
        try {
            MULTIPOINT_TARGET = new Object();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        PacketSpeaker$BundlingQueue.__initStatic();
    }

    public PacketSpeaker$BundlingQueue() {
        this(null, null, true);
    }

    public PacketSpeaker$BundlingQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(4);
            this.setBundlingEnabled(true);
            this.setTargetMap(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", PacketSpeaker$BundlingQueue$Iterator.get_CLASS());
        Class clazz2 = __mapChildren.put("TargetQueue", PacketSpeaker$BundlingQueue$TargetQueue.get_CLASS());
    }

    public boolean add(Object oElement) {
        int cSyncSends;
        OutgoingUdpPacket packet = (OutgoingUdpPacket)oElement;
        if ((!(this.getDeferralThresholdNanos() == 0L) ? false : this.getPendingAsyncFlushCount() == 0) && (!((cSyncSends = this.getSynchronousSendCount()) <= this.getVolumeThreshold()) ? false : this.isEmpty())) {
            block3: {
                try {
                    packet.send();
                    this.setSynchronousSendCount(cSyncSends + packet.getAddressCount());
                }
                catch (Exception e) {
                    if (!(packet.getUdpSocket().getState() != Socket.STATE_CLOSED)) break block3;
                    throw Base.ensureRuntimeException(e);
                }
            }
            return false;
        }
        this.setSynchronousAddCount(this.getSynchronousAddCount() + packet.getAddressCount());
        return super.add(oElement);
    }

    protected void flush(boolean fAuto) {
        int cSyncSends;
        block15: {
            boolean fUnderLimit;
            double dAggression;
            int cPending;
            block14: {
                boolean fSpeakerIdle;
                int cPackets = this.size();
                if (cPackets == 0) {
                    if (fAuto ^ true) {
                        this.setSynchronousSendCount(0);
                        this.setSynchronousAddCount(0);
                    }
                    return;
                }
                cPending = this.getPendingAsyncFlushCount();
                cSyncSends = this.getSynchronousSendCount();
                int cSyncAdds = this.getSynchronousAddCount();
                dAggression = this.getBundlingAggression();
                boolean bl = !(this.getFlushState() == ConcurrentQueue.FLUSH_PENDING) ? false : (fSpeakerIdle = cSyncAdds == cPackets);
                fUnderLimit = (!this.isVolumeTunable() ? false : dAggression != 0.0) ? (double)cSyncSends < (double)this.getVolumeThreshold() / (dAggression + 1.0) : cSyncSends < this.getVolumeThreshold();
                if (!(!(!fSpeakerIdle ? false : fUnderLimit) ? false : cPending == 0)) break block14;
                PacketSpeaker speaker = (PacketSpeaker)this.get_Module();
                PacketBufferPool pool = speaker.getPacketAllocator();
                long cNanos = this.getDeferralThresholdNanos();
                try {
                    if (cNanos != 0L) {
                        this.setDeferralThresholdNanos(0L);
                    }
                    Object oNext = this.removeNoWait();
                    while (oNext != null) {
                        Object var17_18;
                        OutgoingUdpPacket packet = (OutgoingUdpPacket)oNext;
                        try {
                            block13: {
                                try {
                                    packet.send();
                                    cSyncSends += packet.getAddressCount();
                                }
                                catch (Exception e) {
                                    if (!(packet.getUdpSocket().getState() != Socket.STATE_CLOSED)) break block13;
                                    throw Base.ensureRuntimeException(e);
                                }
                            }
                            var17_18 = null;
                            pool.release(packet.getWriteBuffer());
                        }
                        catch (Throwable throwable) {
                            var17_18 = null;
                            pool.release(packet.getWriteBuffer());
                            throw throwable;
                        }
                        oNext = this.removeNoWait();
                    }
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    if (cNanos != 0L) {
                        this.setDeferralThresholdNanos(cNanos);
                    }
                    throw throwable;
                }
                Object var15_14 = null;
                if (cNanos != 0L) {
                    this.setDeferralThresholdNanos(cNanos);
                }
                if (fAuto ^ true) {
                    cSyncSends = 0;
                }
                break block15;
            }
            super.flush(fAuto);
            cSyncSends = 0;
            this.setPendingAsyncFlushCount(fUnderLimit ? Math.max(0, cPending - 1) : Math.min(1024, cPending + (int)dAggression));
        }
        this.setSynchronousAddCount(0);
        this.setSynchronousSendCount(cSyncSends);
    }

    private int getBalancePoint() {
        return this.__m_BalancePoint;
    }

    public int getPendingAsyncFlushCount() {
        return this.__m_PendingAsyncFlushCount;
    }

    public int getSynchronousAddCount() {
        return this.__m_SynchronousAddCount;
    }

    public int getSynchronousSendCount() {
        return this.__m_SynchronousSendCount;
    }

    public Object getTarget(Object oElement) {
        OutgoingUdpPacket packet = (OutgoingUdpPacket)oElement;
        if (!(packet.getAddressCount() == 1) ? false : ((PacketSpeaker)this.get_Module()).getMemberSet().size() > this.getBalancePoint()) {
            return packet.getSocketAddresses()[0];
        }
        return MULTIPOINT_TARGET;
    }

    public int getVolumeThreshold() {
        return this.__m_VolumeThreshold;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketSpeaker$BundlingQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketSpeaker$BundlingQueue();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isVolumeTunable() {
        return this.__m_VolumeTunable;
    }

    public void onInit() {
        this.setBalancePoint(Integer.parseInt(System.getProperty("tangosol.coherence.speaker.balancepoint", "2")));
        this.setBundlingEnabled(Boolean.valueOf(System.getProperty("tangosol.coherence.speaker.bundling.enabled", "true")));
        this.setBatchSize(Integer.parseInt(System.getProperty("tangosol.coherence.speaker.batch", "8")));
        super.onInit();
    }

    private void setBalancePoint(int pBalancePoint) {
        this.__m_BalancePoint = pBalancePoint;
    }

    public void setPendingAsyncFlushCount(int cFlush) {
        this.__m_PendingAsyncFlushCount = cFlush;
    }

    protected void setSynchronousAddCount(int cPackets) {
        this.__m_SynchronousAddCount = cPackets;
    }

    protected void setSynchronousSendCount(int cPackets) {
        this.__m_SynchronousSendCount = cPackets;
    }

    public void setVolumeThreshold(int nThreshold) {
        this.__m_VolumeThreshold = nThreshold;
    }

    public void setVolumeTunable(boolean fTuneable) {
        this.__m_VolumeTunable = fTuneable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", threshold=").append(this.getVolumeThreshold());
        return sb.toString();
    }

    public void tuneVolumeThreshold(int cPacketsBacklog) {
        if (this.isVolumeTunable()) {
            int nVolume = this.getVolumeThreshold();
            if (cPacketsBacklog > 0) {
                if (nVolume > 0) {
                    nVolume -= Math.max(1, Math.min(cPacketsBacklog << 4, nVolume >>> 2));
                    this.setVolumeThreshold(nVolume);
                }
            } else if (this.getSynchronousSendCount() >= nVolume) {
                nVolume += Math.max(1, nVolume);
                this.setVolumeThreshold(nVolume);
            }
        }
    }
}

