/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.DiscoveryMessage;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceReply;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$NewMemberAnnounceWait;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Date;

public class ClusterService$NewMemberAnnounce
extends DiscoveryMessage {
    private int __m_AttemptCounter;
    private int __m_AttemptLimit;
    private transient long __m_ThisRecvTimestamp;
    private long __m_ThisSentTimestamp;

    public ClusterService$NewMemberAnnounce() {
        this(null, null, true);
    }

    public ClusterService$NewMemberAnnounce(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(7);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getAttemptCounter() {
        return this.__m_AttemptCounter;
    }

    public int getAttemptLimit() {
        return this.__m_AttemptLimit;
    }

    public String getDescription() {
        long lThisSentTimestamp = this.getThisSentTimestamp();
        long lThisRecvTimestamp = this.getThisRecvTimestamp();
        String sThisSentTimestamp = lThisSentTimestamp == 0L ? "none" : new Date(lThisSentTimestamp).toString();
        String sThisRecvTimestamp = lThisRecvTimestamp == 0L ? "none" : new Date(lThisRecvTimestamp).toString();
        return String.valueOf("AttemptCounter=") + this.getAttemptCounter() + "\nAttemptLimit=" + this.getAttemptLimit() + "\nThisSentTimestamp=" + sThisSentTimestamp + "\nThisRecvTimestamp=" + sThisRecvTimestamp;
    }

    public long getThisRecvTimestamp() {
        return this.__m_ThisRecvTimestamp;
    }

    public long getThisSentTimestamp() {
        return this.__m_ThisSentTimestamp;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$NewMemberAnnounce".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$NewMemberAnnounce();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        Member memberNew = this.getFromMember();
        switch (service.getState()) {
            case 0: {
                if (this.isReadError()) {
                    service.onMemberRejected(-ClusterService.REJECT_VERSION, memberNew);
                    throw new EventDeathException("Version mismatch");
                }
                Member memberTemp = service.getAnnounceMember();
                if (!(memberNew.equals(memberTemp) ^ true) || !(!(memberTemp.compareTo(memberNew) > 0) ? false : service.isWellKnown(memberNew))) break;
                service.resetBroadcastCounter("an older member announcing", this);
                break;
            }
            case 2: {
                boolean fJoinSuspended;
                if (this.isReadError()) {
                    throw new EventDeathException("Version mismatch");
                }
                MasterMemberSet setMember = service.getClusterMemberSet();
                Member memberThis = setMember.getThisMember();
                Member memberSenior = setMember.getOldestMember();
                boolean fRecordAnnouncing = fJoinSuspended = service.isMembershipSuspended();
                if (!(memberThis == memberSenior) ? false : fJoinSuspended ^ true) {
                    ClusterService$NewMemberAnnounceReply msg = (ClusterService$NewMemberAnnounceReply)service.instantiateMessage("NewMemberAnnounceReply");
                    msg.setToMember(memberNew);
                    msg.setPrevSentTimestamp(this.getThisSentTimestamp());
                    msg.setPrevRecvTimestamp(this.getThisRecvTimestamp());
                    service.send(msg);
                } else if (!(service.isWellKnown(memberNew) ^ true) ? false : service.isWellKnown(memberSenior) ^ true) {
                    ClusterService$NewMemberAnnounceWait msg = (ClusterService$NewMemberAnnounceWait)service.instantiateMessage("NewMemberAnnounceWait");
                    msg.setToMember(memberNew);
                    msg.setSeniorMember(memberSenior);
                    service.send(msg);
                } else if (this.getAttemptCounter() > this.getAttemptLimit() >>> 2) {
                    int cMembers = setMember.size();
                    if (cMembers < 8 ? true : Base.getRandom().nextInt(cMembers) < (int)Math.log(cMembers) + 1) {
                        ClusterService$NewMemberAnnounceWait msg = (ClusterService$NewMemberAnnounceWait)service.instantiateMessage("NewMemberAnnounceWait");
                        msg.setToMember(memberNew);
                        msg.setSeniorMember(memberSenior);
                        service.send(msg);
                    }
                    fRecordAnnouncing = true;
                }
                if (!fRecordAnnouncing) break;
                service.getQuorumControl().onMemberAnnounceWaiting(memberNew);
                break;
            }
        }
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        MessagePacket packet;
        super.read(input);
        this.setAttemptCounter(input.readInt());
        this.setAttemptLimit(input.readInt());
        this.setThisSentTimestamp(input.readLong());
        MessagePacket[] aPacket = this.getPacket();
        if ((!(aPacket != null) ? false : aPacket.length > 0) && (packet = aPacket[0]) != null) {
            this.setThisRecvTimestamp(((ClusterService)this.getService()).calcTimestamp(packet.getReceivedMillis()));
        }
        this.ensureEOS(input);
    }

    public void setAttemptCounter(int n) {
        this.__m_AttemptCounter = n;
    }

    public void setAttemptLimit(int c) {
        this.__m_AttemptLimit = c;
    }

    protected void setThisRecvTimestamp(long ldt) {
        this.__m_ThisRecvTimestamp = ldt;
    }

    public void setThisSentTimestamp(long cMillis) {
        this.__m_ThisSentTimestamp = cMillis;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        long lMillis = Base.getSafeTimeMillis();
        this.setThisSentTimestamp(lMillis);
        output.writeInt(this.getAttemptCounter());
        output.writeInt(this.getAttemptLimit());
        output.writeLong(this.getThisSentTimestamp());
    }
}

