/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dsltools.precedence;

import com.tangosol.coherence.dsltools.precedence.IdentifierOPToken;
import com.tangosol.coherence.dsltools.precedence.LiteralOPToken;
import com.tangosol.coherence.dsltools.precedence.OPToken;
import java.util.HashMap;
import java.util.HashSet;

public class TokenTable {
    HashMap m_table = new HashMap();
    HashSet m_disabled = new HashSet();
    boolean m_fIgnoreCase = false;
    String m_sIdentifierASTName = null;
    String m_sIiteralASTName = null;

    public TokenTable() {
    }

    public TokenTable(String sIdentifierASTName, String sLiteralASTName) {
        this.m_sIdentifierASTName = sIdentifierASTName;
        this.m_sIiteralASTName = sLiteralASTName;
    }

    public void setIgnoreCase(boolean fIgnore) {
        this.m_fIgnoreCase = fIgnore;
    }

    public boolean isIgnoringCase() {
        return this.m_fIgnoreCase;
    }

    public OPToken lookup(String sName) {
        String nm;
        String string = nm = this.m_fIgnoreCase ? sName.toLowerCase() : sName;
        if (this.m_disabled.contains(nm)) {
            return null;
        }
        Object o = this.m_table.get(nm);
        if (o == null) {
            return null;
        }
        return (OPToken)o;
    }

    public OPToken addToken(String sName, OPToken token) {
        this.m_table.put(sName, token);
        return token;
    }

    public OPToken addToken(String sName, OPToken token, String sASTName) {
        this.m_table.put(sName, token);
        token.setLedASTName(sASTName);
        return token;
    }

    public OPToken addToken(String sName, OPToken token, String sLedName, String sNudName) {
        this.m_table.put(sName, token);
        token.setLedASTName(sLedName);
        token.setNudASTName(sNudName);
        return token;
    }

    public OPToken addToken(OPToken token) {
        this.m_table.put(token.getId(), token);
        return token;
    }

    public OPToken addToken(OPToken token, String sASTName) {
        this.m_table.put(token.getId(), token);
        token.setLedASTName(sASTName);
        return token;
    }

    public void alias(String sName, String sInstalled) {
        Object o = this.m_table.get(sInstalled);
        if (o != null) {
            this.m_table.put(sName, o);
        }
    }

    public void disable(String sName) {
        this.m_disabled.add(sName);
    }

    public void enable(String sName) {
        this.m_disabled.remove(sName);
    }

    public OPToken newLiteral(String sValue, int nTypeCode) {
        return new LiteralOPToken(sValue, nTypeCode, this.m_sIiteralASTName);
    }

    public OPToken newIdentifier(String sValue) {
        return new IdentifierOPToken(sValue, this.m_sIdentifierASTName);
    }
}

