/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.extractor;

import com.tangosol.util.ValueExtractor;
import java.util.Map;
import java.util.Set;

public class DeltaExtractor
implements ValueExtractor {
    protected ValueExtractor m_veSource;
    protected Map m_mapPrior;
    protected Map m_mapKey;

    public DeltaExtractor(Map mapPrior, ValueExtractor veSource, Map mapKey) {
        this.m_veSource = veSource;
        this.m_mapPrior = mapPrior;
        this.m_mapKey = mapKey;
    }

    @Override
    public Object extract(Object oTarget) {
        Object oValue = this.m_veSource.extract(oTarget);
        Object oPrior = this.m_mapPrior.get(this.getKey(oTarget));
        if (oPrior == null) {
            return oValue;
        }
        if (oValue instanceof Number && oPrior instanceof Number) {
            Double dValue = ((Number)oValue).doubleValue();
            Double dPrior = ((Number)oPrior).doubleValue();
            return dValue < dPrior ? dValue : dValue - dPrior;
        }
        return null;
    }

    public Object getKey(Object oTarget) {
        Map mapKey = this.m_mapKey;
        if (mapKey == null || mapKey.size() == 0) {
            return oTarget;
        }
        Set setKey = mapKey.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : setKey) {
            String oKey = (String)entry.getKey();
            Object oValue = ((ValueExtractor)entry.getValue()).extract(oTarget);
            String sValue = oValue == null ? "n/a" : oValue.toString();
            sb.append(oKey).append('=').append(sValue).append(',');
        }
        return sb.toString();
    }
}

