/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.component.AbstractStorageCommit;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.util.Base;
import com.tangosol.util.Converter;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;

public class StorageAutoCommit
extends AbstractStorageCommit {
    @Override
    public Message invoke(Message msg) {
        VersionDependencyManager dependencyManager = null;
        Operation op = msg.getOperation();
        String sService = op.getServiceName();
        Results results = msg.getResults();
        Set entries = (Set)msg.getContext();
        long lVersion = -1L;
        ServiceContext serviceCtx = ServiceContext.getContext(sService);
        LocalMemberState lms = LocalMemberState.getMemberState(op.getServiceName());
        for (Object oEntry : entries) {
            Map.Entry entry = (Map.Entry)oEntry;
            TransactionId xid = op.getXid();
            String sTable = op.getTableName();
            SyntheticKey synKey = (SyntheticKey)entry.getValue();
            if (!results.wasRowModified(sTable, entry.getKey())) continue;
            if (lVersion == -1L) {
                dependencyManager = lms.ensureLocalPartitionState(synKey.getPartition()).getDependencyManager();
                lVersion = dependencyManager.addDependency(xid) + 1L;
            }
            XidSyntheticKey xidKey = new XidSyntheticKey(synKey, xid);
            this.commit(new TableInfoImpl(sTable, op.getServiceName()), xidKey, lVersion);
            this.updateVersionsTable(lVersion, serviceCtx, sTable, xidKey);
            results.getSessionData().setPartitionVersion(lVersion - 1L);
        }
        if (dependencyManager != null) {
            dependencyManager.commitVersionDependency(op.getXid(), lVersion);
        }
        return msg;
    }

    private void updateVersionsTable(long lVersion, ServiceContext ctx, String sTable, XidSyntheticKey xidKey) {
        CacheService service = (CacheService)ctx.getSchema().getService();
        BackingMapManager mapManager = service.getBackingMapManager();
        BackingMapManagerContext mapCtx = mapManager.getContext();
        Map mapVersions = mapCtx.getBackingMap(Schema.getPhysicalVersionsTableName(sTable));
        if (mapVersions == null) {
            Base.log("Unable to acquire versions backing map for cache: " + sTable + " with service: " + service.getInfo().getServiceName());
            Base.log("Known Caches:");
            Enumeration enumCaches = mapCtx.getCacheService().getCacheNames();
            while (enumCaches.hasMoreElements()) {
                Base.log("Cache Name: " + enumCaches.nextElement());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            mapVersions = mapCtx.getBackingMap(Schema.getPhysicalVersionsTableName(sTable));
        }
        Converter keyConverter = mapCtx.getKeyToInternalConverter();
        Converter valueConverter = mapCtx.getValueToInternalConverter();
        mapVersions.put(keyConverter.convert(xidKey), valueConverter.convert(Base.makeLong(lVersion)));
    }
}

