/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.journal;

import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.journal.AbstractJournalRM;
import com.tangosol.io.journal.FlashJournalRM;
import com.tangosol.io.journal.Journal;
import com.tangosol.io.nio.ByteBufferWriteBuffer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class RamJournalRM
extends AbstractJournalRM {
    protected static final int SHIFT_RAM_FLAG = 62;
    protected static final long MASK_RAM_FLAG = 0x4000000000000000L;
    protected static final int SHIFT_FILE_ID = 53;
    protected static final long MASK_FILE_ID = 4602678819172646912L;
    protected static final int SHIFT_OFFSET = 22;
    protected static final long MASK_OFFSET = 9007199250546688L;
    protected static final int SHIFT_LENGTH = 0;
    protected static final long MASK_LENGTH = 0x3FFFFFL;
    public static final long MIN_FILE_SIZE = 0x100000L;
    public static final long MAX_FILE_SIZE = Integer.MAX_VALUE;
    public static final long DFT_FILE_SIZE = 0x200000L;
    public static final long MIN_TOTAL_SIZE = 0x1000000L;
    public static final long MAX_TOTAL_SIZE = 0x1000000000L;
    public static final long DFT_TOTAL_SIZE = 0x40000000L;
    public static final int MAX_VALUE_SIZE = 0x3FFFFF;
    public static final int DFT_VALUE_SIZE = 16384;
    public static final long MAX_POOL_SIZE = 0x1000000000L;
    public static final long DFT_POOL_SIZE = 0x1000000L;
    public static final double DFT_COLLECT_PCT = 0.84;
    protected long m_cbMaxRam = 0x40000000L;
    protected boolean m_fUseNioRam = false;
    protected long m_cbMaxPool = 0x1000000L;
    protected BufferPool m_pool;
    protected FlashJournalRM m_jrnlrm;
    protected FlashConsumer m_flash;

    public RamJournalRM(Cluster cluster) {
        super(cluster);
    }

    @Override
    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        if (this.getState() == 4) {
            FlashConsumer flash = this.m_flash;
            if (flash != null) {
                this.m_flash = null;
                flash.dispose();
            }
            this.m_pool = null;
        }
    }

    @Override
    public int getBacklogCount() {
        return -1;
    }

    @Override
    public int getBacklogSize() {
        return -1;
    }

    @Override
    public int getMaxBacklogSize() {
        return -1;
    }

    @Override
    public int getPoolSize() {
        return -1;
    }

    @Override
    public long getMaxTotalRam() {
        return this.m_cbMaxRam;
    }

    @Override
    public boolean isNioRam() {
        return this.m_fUseNioRam;
    }

    @Override
    public long getMaxPoolSize() {
        return this.m_cbMaxPool;
    }

    @Override
    public int getBufferSize() {
        return -1;
    }

    @Override
    public void setMaxValueSize(int cb) {
        if (cb == 0) {
            cb = 0x3FFFFF;
        } else if (cb < 0 || cb > 0x3FFFFF) {
            throw new IllegalArgumentException("Illegal maximum value size of " + cb + "; maximum allowed size is " + 0x3FFFFF);
        }
        if ((long)cb > this.getMaxFileSize() / 2L) {
            throw new IllegalArgumentException("Illegal maximum value size of " + cb + "; maximum allowed size is 1/2 of the maximum file size of " + this.getMaxFileSize());
        }
        this.m_cbMaxValue = cb;
    }

    @Override
    public void setMaxFileSize(long cb) {
        this.checkInitializing();
        if (cb < 0x100000L || cb > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal maximum file size of " + cb + "; allowed range is " + 0x100000L + " to " + Integer.MAX_VALUE);
        }
        long cbTotal = this.m_cbMaxRam;
        if (cb > cbTotal / 2L) {
            throw new IllegalArgumentException("Illegal maximum file size of " + cb + "; maximum file size cannot exceed 1/2 of the maximum RAM size of " + cbTotal);
        }
        if ((long)this.m_cbMaxValue > cb / 2L) {
            this.m_cbMaxValue = (int)(cb / 2L);
        }
        this.m_cbMaxFile = cb;
    }

    public void setMaxTotalRam(long cb) {
        this.checkInitializing();
        if (cb < 0x1000000L || cb > 0x1000000000L) {
            throw new IllegalArgumentException("Illegal maximum RAM size of " + cb + "; allowed range is " + 0x1000000L + " to " + 0x1000000000L);
        }
        long cbFile = (cb + 511L) / 512L;
        long cbMaxFile = this.m_cbMaxFile;
        if (cbFile > cbMaxFile) {
            cbMaxFile = cbFile;
        } else if (cb / cbMaxFile < 8L) {
            cbMaxFile = Math.max(0x100000L, cbFile);
        }
        this.m_cbMaxFile = cbMaxFile;
        if ((long)this.m_cbMaxValue > cbMaxFile / 2L) {
            this.m_cbMaxValue = (int)(cbMaxFile / 2L);
        }
        this.m_cbMaxRam = cb;
    }

    public void setNioRam(boolean fUseNioRam) {
        this.checkInitializing();
        this.m_fUseNioRam = fUseNioRam;
    }

    public void setMaxPoolSize(long cb) {
        this.checkInitializing();
        if (cb < 0L || cb > 0x1000000000L) {
            throw new IllegalArgumentException("Illegal pool size of " + cb + "; maximum pool size is " + 0x1000000000L);
        }
        this.m_cbMaxPool = cb;
    }

    public FlashJournalRM getFlashJournalRM() {
        return this.m_jrnlrm;
    }

    public void setFlashJournalRM(FlashJournalRM jrnlrm) {
        this.checkInitializing();
        this.m_jrnlrm = jrnlrm;
    }

    @Override
    protected void applyConfig(String sName, XmlElement xmlConfig) {
        if (sName.equals("maximum-value-size")) {
            long cbMaxValue = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbMaxValue > 0L) {
                long cbMaxFile;
                if (cbMaxValue > 0x3FFFFFL) {
                    CacheFactory.log("Journal Resource Manager: Maximum value size is 1GB (overriding setting of " + cbMaxValue + ")", 2);
                    cbMaxValue = 0x3FFFFFL;
                }
                if (cbMaxValue > (cbMaxFile = this.m_cbMaxFile) / 2L) {
                    CacheFactory.log("Journal Resource Manager: Maximum value size (" + cbMaxValue + ") cannot be larger than 1/2 maximum file size (" + cbMaxFile + ")", 2);
                    cbMaxValue = cbMaxFile / 2L;
                }
                this.m_cbMaxValue = (int)cbMaxValue;
            }
        } else if (sName.equals("maximum-file-size")) {
            long cbMaxFile = Base.parseMemorySize(xmlConfig.getString("0"));
            if (cbMaxFile > 0L) {
                if (cbMaxFile < 0x100000L) {
                    CacheFactory.log("Journal Resource Manager: Minimum file size is 1048576", 2);
                    cbMaxFile = 0x100000L;
                } else if (cbMaxFile > Integer.MAX_VALUE) {
                    CacheFactory.log("Journal Resource Manager: Maximum file size is 2147483647", 2);
                    cbMaxFile = Integer.MAX_VALUE;
                }
                long cbMax = this.m_cbMaxRam;
                long cbFile = (cbMax + 511L) / 512L;
                if (cbFile > cbMaxFile) {
                    CacheFactory.log("Journal Resource Manager: Increasing file size from " + cbMaxFile + " to " + cbFile + " based on maximum RAM size of " + cbMax, 2);
                    cbMaxFile = cbFile;
                } else if (cbMax / cbMaxFile < 8L) {
                    long cbNewMaxFile = Math.max(0x100000L, cbFile);
                    CacheFactory.log("Journal Resource Manager: Decreasing file size from " + cbMaxFile + " to " + cbNewMaxFile + " based on maximum RAM size of " + cbMax, 2);
                    cbMaxFile = cbNewMaxFile;
                }
                this.m_cbMaxFile = cbMaxFile;
                this.applyConfig("maximum-value-size", new SimpleElement("maximum-value-size", new Long(this.m_cbMaxValue)));
            }
        } else if (sName.equals("maximum-size")) {
            String sSize = xmlConfig.getString("0");
            if (sSize.indexOf(37) >= 0) {
                float flHeapFraction;
                try {
                    flHeapFraction = this.getPercentageAsFraction(sSize);
                }
                catch (IllegalArgumentException e) {
                    CacheFactory.log("Journal Resource Manager: The percentage value for maximum-size needsto be in the range of 1-99. Using 25% instead of supplied: " + sSize, 2);
                    flHeapFraction = 0.25f;
                }
                this.m_cbMaxRam = (long)((float)Runtime.getRuntime().maxMemory() * flHeapFraction);
            } else {
                long cbMax = Base.parseMemorySize(sSize);
                if (cbMax > 0L) {
                    if (cbMax < 0x1000000L) {
                        CacheFactory.log("Journal Resource Manager: Minimum size is 16777216", 2);
                        cbMax = 0x1000000L;
                    }
                    if (cbMax > 0x1000000000L) {
                        CacheFactory.log("Journal Resource Manager: Maximum size is 68719476736", 2);
                        cbMax = 0x1000000000L;
                    }
                    this.m_cbMaxRam = cbMax;
                }
            }
            this.applyConfig("maximum-file-size", new SimpleElement("maximum-file-size", new Long(this.m_cbMaxFile)));
        } else if (sName.equals("off-heap")) {
            this.m_fUseNioRam = xmlConfig.getBoolean(this.m_fUseNioRam);
        } else if (sName.equals("maximum-pool-size")) {
            String sSize = xmlConfig.getString();
            if (sSize.length() > 0) {
                long cbPool = Base.parseMemorySize(sSize);
                if (cbPool > 0x1000000000L) {
                    CacheFactory.log("Journal Resource Manager: Maximum pool size (" + cbPool + ") cannot be larger than 64GB", 2);
                    cbPool = 0x1000000000L;
                }
                this.m_cbMaxPool = cbPool;
            }
        } else {
            super.applyConfig(sName, xmlConfig);
        }
    }

    protected float getPercentageAsFraction(String sSize) {
        int ofPct = sSize.indexOf(37);
        if (ofPct == -1) {
            throw new IllegalArgumentException("The parameter " + sSize + " does not contain a percentage value.");
        }
        int percent = Integer.parseInt(sSize.substring(0, ofPct));
        if (percent > 99 || percent < 1) {
            throw new IllegalArgumentException("Not a percentage value between 1- 99:" + sSize);
        }
        return (float)percent / 100.0f;
    }

    @Override
    protected void startThreads() {
        CacheFactory.log("Journal Resource Manager: The RAM Journal is configured to use a maximum of " + this.getMaxTotalRam() + " bytes.", 3);
        FlashJournalRM jrnlrm = this.m_jrnlrm;
        if (jrnlrm != null) {
            jrnlrm.start();
        }
        this.m_pool = this.instantiateBufferPool();
        super.startThreads();
        if (jrnlrm != null) {
            FlashConsumer flash = this.instantiateConsumer();
            flash.setJournal(jrnlrm.createJournal(flash));
            this.m_flash = flash;
        }
    }

    @Override
    protected String getDescription() {
        return super.getDescription() + ", MaxTotalRam=" + this.getMaxTotalRam() + ", NioRam=" + this.isNioRam() + ", MaxPoolSize=" + this.getMaxPoolSize() + ", BufferPool=" + this.getBufferPool() + ", FlashJournalRM=" + this.getFlashJournalRM();
    }

    @Override
    protected int getMaxJournalFiles() {
        return Math.min(512, (int)(this.m_cbMaxRam / this.m_cbMaxFile));
    }

    @Override
    protected long getDefaultMaxFileSize() {
        return 0x200000L;
    }

    @Override
    protected int getDefaultMaxValueSize() {
        return 16384;
    }

    @Override
    protected double getDefaultCollectorLoadFactor() {
        return 0.84;
    }

    @Override
    protected long getMinCollectorSleepMillis() {
        return 5000L;
    }

    @Override
    protected boolean isDedupEnabled() {
        return false;
    }

    @Override
    protected boolean isSingleEvacuation() {
        return false;
    }

    protected Journal getFlashJournal() {
        FlashConsumer flash = this.m_flash;
        return flash == null ? null : flash.getJournal();
    }

    @Override
    protected JournalImpl instantiateJournal() {
        return new JournalImpl();
    }

    protected FlashConsumer instantiateConsumer() {
        return new FlashConsumer();
    }

    protected FlashConsumer getFlashConsumer() {
        return this.m_flash;
    }

    @Override
    protected JournalFile getJournalFile(int nFileId) {
        return (JournalFile)super.getJournalFile(nFileId);
    }

    @Override
    protected JournalFile instantiateJournalFile(int nFile) {
        return new JournalFile(nFile);
    }

    @Override
    protected boolean isCompact(long lTicket) {
        assert (lTicket != 0L);
        return (lTicket & 0xC000000000000000L) == Long.MIN_VALUE;
    }

    protected boolean isRam(long lTicket) {
        assert (lTicket != 0L);
        return (lTicket & 0xC000000000000000L) == -4611686018427387904L;
    }

    protected boolean isFlash(long lTicket) {
        assert (lTicket != 0L);
        return (lTicket & Long.MIN_VALUE) == 0L;
    }

    @Override
    protected long getEvacuationMask() {
        return -9007199254740992L;
    }

    @Override
    protected int extractFileId(long lTicket) {
        assert (!this.isFlash(lTicket));
        assert (!this.isCompact(lTicket));
        return (int)((lTicket & 0x3FE0000000000000L) >>> 53);
    }

    @Override
    protected long extractOffset(long lTicket) {
        assert (!this.isFlash(lTicket));
        assert (!this.isCompact(lTicket));
        return (lTicket & 0x1FFFFFFFC00000L) >>> 22;
    }

    @Override
    protected int extractLength(long lTicket) {
        assert (!this.isFlash(lTicket));
        return (int)(this.isCompact(lTicket) ? (lTicket & 0x700000000000000L) >>> 56 : (lTicket & 0x3FFFFFL) >>> 0);
    }

    @Override
    protected long encodeTicket(int nFile, long of, int cb) {
        assert (nFile >= 0);
        assert (nFile <= 511);
        assert (of >= 0L);
        assert (of < Integer.MAX_VALUE);
        assert (cb >= 0);
        assert (cb <= 0x3FFFFF);
        long lTicket = 0xC000000000000000L | (long)nFile << 53 | of << 22 | (long)cb << 0;
        assert (this.extractFileId(lTicket) == nFile);
        assert (this.extractOffset(lTicket) == of);
        assert (this.extractLength(lTicket) == cb);
        return lTicket;
    }

    @Override
    protected String getTicketDescription(long lTicket) {
        try {
            if (this.isFlash(lTicket)) {
                return this.m_jrnlrm.getTicketDescription(lTicket);
            }
            return super.getTicketDescription(lTicket);
        }
        catch (Exception e) {
            return "Format=Corrupt, Bytes=0x" + Base.toHexString((int)lTicket, 8) + Base.toHexString((int)(lTicket >>> 32), 8);
        }
    }

    protected BufferPool instantiateBufferPool() {
        return new BufferPool();
    }

    protected BufferPool getBufferPool() {
        return this.m_pool;
    }

    protected class BufferPool {
        private final int m_cMax;
        private final BlockingQueue<WriteBuffer> m_queueBuffers;

        public BufferPool() {
            int cMax;
            this.m_cMax = cMax = (int)(RamJournalRM.this.getMaxPoolSize() / RamJournalRM.this.getMaxFileSize());
            this.m_queueBuffers = cMax == 0 ? null : new ArrayBlockingQueue(cMax);
        }

        public WriteBuffer allocate() {
            WriteBuffer buf;
            BlockingQueue<WriteBuffer> queue = this.m_queueBuffers;
            WriteBuffer writeBuffer = buf = queue == null ? null : (WriteBuffer)queue.poll();
            if (buf == null) {
                RamJournalRM mgr = RamJournalRM.this;
                int cbBuffer = (int)mgr.getMaxFileSize();
                if (RamJournalRM.this.isNioRam()) {
                    buf = new ByteBufferWriteBuffer(ByteBuffer.allocateDirect(cbBuffer));
                    ((ByteBufferWriteBuffer)buf).setLength(cbBuffer);
                } else {
                    buf = new ByteArrayWriteBuffer(cbBuffer, cbBuffer);
                    ((ByteArrayWriteBuffer)buf).setLength(cbBuffer);
                }
            }
            return buf;
        }

        public void release(WriteBuffer buf) {
            assert (buf != null);
            BlockingQueue<WriteBuffer> queue = this.m_queueBuffers;
            if (queue != null) {
                queue.offer(buf);
            }
        }

        public int getSize() {
            BlockingQueue<WriteBuffer> queue = this.m_queueBuffers;
            return queue == null ? 0 : queue.size();
        }

        public int getCapacity() {
            return this.m_cMax;
        }

        public String toString() {
            return "BufferPool{Size=" + this.getSize() + ", Capacity=" + this.getCapacity() + "}";
        }
    }

    protected class JournalFile
    extends AbstractJournalRM.JournalFile {
        protected volatile WriteBuffer m_bufWrite;
        protected volatile ReadBuffer m_bufRead;

        public JournalFile(int nFile) {
            WriteBuffer bufWrite;
            super(nFile);
            this.m_bufWrite = bufWrite = RamJournalRM.this.getBufferPool().allocate();
            this.m_bufRead = bufWrite.getUnsafeReadBuffer();
        }

        @Override
        public long enqueue(Binary bin) {
            long ofBefore;
            long lState;
            RamJournalRM mgr = RamJournalRM.this;
            int cbValue = bin.length();
            assert (cbValue > 0);
            if (cbValue > RamJournalRM.this.m_cbMaxValue) {
                Journal jrnlFlash = mgr.getFlashJournal();
                if (jrnlFlash == null) {
                    throw new IllegalArgumentException("Maximum value size is " + RamJournalRM.this.m_cbMaxValue);
                }
                long lTicket = jrnlFlash.write(bin);
                assert (RamJournalRM.this.isFlash(lTicket));
                assert (!RamJournalRM.this.isRam(lTicket));
                return lTicket;
            }
            AtomicLong lStateOffset = this.m_lStateOffset;
            while ((lState = (ofBefore = lStateOffset.get()) & 0xF000000000000000L) == 0L) {
                long ofAfter = ofBefore + (long)cbValue;
                if (ofAfter > RamJournalRM.this.m_cbMaxFile) {
                    if (!lStateOffset.compareAndSet(ofBefore, 0x2000000000000000L | ofBefore)) continue;
                    return 0L;
                }
                if (!lStateOffset.compareAndSet(ofBefore, ofAfter)) continue;
                int nFileId = this.m_nFile;
                long lTicket = RamJournalRM.this.encodeTicket(nFileId, ofBefore, cbValue);
                WriteBuffer bufWrite = this.m_bufWrite;
                if (mgr.isNioRam()) {
                    bufWrite = ((ByteBufferWriteBuffer)bufWrite).getUnsafeWriteBuffer();
                }
                bufWrite.write((int)ofBefore, bin);
                this.m_cbWritten.addAndGet(cbValue);
                assert (RamJournalRM.this.isRam(lTicket));
                assert (!RamJournalRM.this.isFlash(lTicket));
                return lTicket;
            }
            if (lState == 0x1000000000000000L) {
                throw new IllegalStateException();
            }
            return 0L;
        }

        @Override
        public Binary read(long lTicket) {
            RamJournalRM mgr = RamJournalRM.this;
            if (mgr.isFlash(lTicket)) {
                Journal jrnlFlash = mgr.getFlashJournal();
                if (jrnlFlash == null) {
                    throw new IllegalStateException();
                }
                Binary bin = jrnlFlash.read(lTicket);
                assert (bin != null);
                return bin;
            }
            assert (mgr.isRam(lTicket));
            int of = (int)RamJournalRM.this.extractOffset(lTicket);
            int cb = RamJournalRM.this.extractLength(lTicket);
            return this.m_bufRead.toBinary(of, cb);
        }

        @Override
        protected String getDescription() {
            WriteBuffer bufWrite = this.m_bufWrite;
            return super.getDescription() + ", BufferSize=" + (bufWrite == null ? "n/a" : Integer.valueOf(bufWrite.length()));
        }

        @Override
        public void dispose() {
            BufferPool pool = RamJournalRM.this.getBufferPool();
            WriteBuffer bufWrite = this.m_bufWrite;
            if (pool != null && bufWrite != null) {
                pool.release(bufWrite);
            }
            this.m_bufWrite = null;
            this.m_bufRead = null;
        }

        @Override
        public void notifyWriteCompleted() {
            WriteBuffer bufWrite = this.m_bufWrite;
            if (bufWrite != null && !RamJournalRM.this.isNioRam()) {
                this.m_bufRead = this.m_bufRead.toBinary(0, (int)this.getBytesWritten());
                BufferPool pool = RamJournalRM.this.getBufferPool();
                if (pool != null) {
                    pool.release(bufWrite);
                }
                this.m_bufWrite = null;
            }
        }
    }

    protected class FlashConsumer
    implements Journal.JournalConsumer {
        private Journal m_jrnl;
        private boolean m_fRamJournalDisposed;

        protected FlashConsumer() {
        }

        @Override
        public void evacuate(long lTicketMask, long lTicketValue) {
            RamJournalRM mgr = RamJournalRM.this;
            Iterator<AbstractJournalRM.JournalImpl> iter = mgr.iterateJournals();
            while (iter.hasNext()) {
                AbstractJournalRM.JournalImpl journal = iter.next();
                Journal.JournalConsumer consumer = journal.getConsumer();
                if (consumer == null) continue;
                try {
                    consumer.evacuate(lTicketMask, lTicketValue);
                }
                catch (RuntimeException e) {
                    Base.err("Journal Resource Manager: Exception while evacuating Journal \"" + journal + "\":");
                    Base.err(e);
                }
            }
        }

        @Override
        public void dedupe(byte[][] aab) {
            RamJournalRM mgr = RamJournalRM.this;
            Iterator<AbstractJournalRM.JournalImpl> iter = mgr.iterateJournals();
            while (iter.hasNext()) {
                Journal.JournalConsumer consumer = iter.next().getConsumer();
                if (consumer == null) continue;
                consumer.dedupe(aab);
            }
        }

        @Override
        public String getDescription() {
            return "FlashJournal=" + this.m_jrnl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            Journal jrnl;
            FlashConsumer flashConsumer = this;
            synchronized (flashConsumer) {
                jrnl = this.m_jrnl;
                if (jrnl != null) {
                    this.m_jrnl = null;
                }
            }
            if (jrnl != null) {
                jrnl.dispose();
                if (!this.m_fRamJournalDisposed) {
                    this.m_fRamJournalDisposed = true;
                    RamJournalRM.this.dispose();
                }
            }
        }

        public Journal getJournal() {
            return this.m_jrnl;
        }

        public void setJournal(Journal jrnl) {
            assert (jrnl != null);
            this.m_jrnl = jrnl;
        }

        public void notifyRamJournalDisposed() {
            this.m_fRamJournalDisposed = true;
        }
    }

    protected class JournalImpl
    extends AbstractJournalRM.JournalImpl {
        protected JournalImpl() {
        }

        @Override
        public Binary read(long lTicket) {
            return RamJournalRM.this.isFlash(lTicket) ? RamJournalRM.this.getFlashJournal().read(lTicket) : super.read(lTicket);
        }

        @Override
        public int release(long lTicket) {
            return RamJournalRM.this.isFlash(lTicket) ? RamJournalRM.this.getFlashJournal().release(lTicket) : super.release(lTicket);
        }

        @Override
        protected long writeOverflow(Binary bin) {
            Journal jrnl = RamJournalRM.this.getFlashJournal();
            return jrnl == null ? super.writeOverflow(bin) : jrnl.write(bin);
        }
    }
}

