/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.util.Base;
import java.net.InetAddress;

public class Ping {
    public static void main(String[] asArg) throws Exception {
        if (asArg.length != 1) {
            System.err.println("usage: com.tangosol.net.Ping <destination ip>");
            return;
        }
        String sDst = asArg[0];
        long cMillisInterval = Base.parseTime(System.getProperty("tangosol.coherence.net.ping.interval", "1s"));
        int cMillisTimeout = (int)Base.parseTime(System.getProperty("tangosol.coherence.net.ping.timeout", "5s"));
        InetAddress addrDst = InetAddress.getByName(sDst);
        while (true) {
            long ldtStart = System.nanoTime();
            if (addrDst.isReachable(cMillisTimeout)) {
                long ldtDelta = System.nanoTime() - ldtStart;
                System.out.println("Response received from " + addrDst + " after " + (double)ldtDelta / 1000000.0 + "ms");
                Thread.sleep(cMillisInterval);
                continue;
            }
            System.out.println("Request timeout for " + addrDst + " after " + cMillisTimeout + "ms; using " + "java.net.InetAddress.isReachable");
            if ((long)cMillisTimeout >= cMillisInterval) continue;
            Thread.sleep(cMillisInterval - (long)cMillisTimeout);
        }
    }
}

