/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.TcpDatagramSocket;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.SafeHashMap;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;

public class SocketOptions
implements java.net.SocketOptions,
XmlConfigurable {
    protected XmlElement m_xml;
    protected Map m_mapOptions = new SafeHashMap();
    protected static boolean s_fWarnReuseAddr;

    public boolean isConfigured() {
        return !this.m_mapOptions.isEmpty();
    }

    public void apply(ServerSocket socket) throws SocketException {
        SocketOptions.apply((java.net.SocketOptions)this, socket);
    }

    public void apply(Socket socket) throws SocketException {
        SocketOptions.apply((java.net.SocketOptions)this, socket);
    }

    public void apply(DatagramSocket socket) throws SocketException {
        SocketOptions.apply((java.net.SocketOptions)this, socket);
    }

    public void apply(MulticastSocket socket) throws SocketException {
        this.apply((DatagramSocket)socket);
    }

    @Override
    public XmlElement getConfig() {
        return this.m_xml;
    }

    @Override
    public void setConfig(XmlElement xml) {
        if (this.m_xml != null) {
            throw new IllegalStateException("already configured");
        }
        if (xml == null) {
            throw new IllegalArgumentException("Missing configuration");
        }
        Map map = this.m_mapOptions;
        XmlElement xmlSub = xml.getElement("reuse-address");
        if (xmlSub != null) {
            map.put(4, xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("receive-buffer-size")) != null) {
            map.put(4098, (int)Base.parseMemorySize(xmlSub.getString()));
        }
        if ((xmlSub = xml.getElement("send-buffer-size")) != null) {
            map.put(4097, (int)Base.parseMemorySize(xmlSub.getString()));
        }
        if ((xmlSub = xml.getElement("timeout")) != null) {
            map.put(4102, (int)Base.parseTime(xmlSub.getString()));
        }
        if ((xmlSub = xml.getElement("linger-timeout")) != null) {
            map.put(128, (int)(Base.parseTime(xmlSub.getString()) / 1000L));
        }
        if ((xmlSub = xml.getElement("keep-alive-enabled")) != null) {
            map.put(8, xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("out-of-band-inline")) != null) {
            map.put(4099, xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("tcp-delay-enabled")) != null) {
            map.put(1, !xmlSub.getBoolean(true));
        }
        if ((xmlSub = xml.getElement("traffic-class")) != null) {
            map.put(3, xmlSub.getInt());
        }
        this.m_xml = xml;
    }

    @Override
    public void setOption(int optID, Object value) throws SocketException {
        this.m_mapOptions.put(optID, value);
    }

    @Override
    public Object getOption(int optID) throws SocketException {
        return this.m_mapOptions.get(optID);
    }

    public void copyOptions(java.net.SocketOptions options) throws SocketException {
        if (options != null) {
            Map map = this.m_mapOptions;
            for (int nOp : new int[]{1, 4, 32, 3, 128, 4102, 4097, 4098, 8, 4099}) {
                Object oVal = options.getOption(nOp);
                if (oVal == null) continue;
                map.put(nOp, oVal);
            }
        }
    }

    public String toString() {
        Map map = this.m_mapOptions;
        StringBuffer sb = new StringBuffer("SocketOptions{");
        String sDelim = "";
        String sComma = ", ";
        Object oOption = map.get(4);
        if (oOption != null) {
            sb.append(sDelim).append("AddressReusable=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(4098)) != null) {
            sb.append(sDelim).append("ReceiveBufferSize=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(4097)) != null) {
            sb.append(sDelim).append("SendBufferSize=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(4102)) != null) {
            sb.append(sDelim).append("Timeout=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(128)) != null) {
            sb.append(sDelim).append("LingerTimeout=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(8)) != null) {
            sb.append(sDelim).append("KeepAliveEnabled=").append(oOption);
            sDelim = sComma;
        }
        if ((oOption = map.get(1)) != null) {
            sb.append(sDelim).append("TcpDelayEnabled=").append((Boolean)oOption == false);
            sDelim = sComma;
        }
        if ((oOption = map.get(3)) != null) {
            sb.append(sDelim).append("TrafficClass=").append(oOption);
        }
        return sb.append('}').toString();
    }

    protected static void warnBufferSize(Object socket, String sBuffer, int cb, int cbReal) {
        CacheFactory.log("Failed to set the " + sBuffer + " buffer size on " + socket + " to " + cb + " bytes; actual size is " + cbReal + " bytes." + " Consult your OS documentation regarding  increasing the" + " maximum socket buffer size. Proceeding with the actual value" + " may cause sub-optimal performance.", 2);
    }

    protected static void warnReuseAddr(boolean fReuse) {
        CacheFactory.log("The value of SO_REUSEADDR is being overriden to " + fReuse + " from the system default; this setting is not " + "portable and may result in differeing behavior across " + "environments.", 2);
    }

    public static SocketOptions load(XmlElement xml) {
        SocketOptions options = new SocketOptions();
        options.setConfig(xml);
        return options.isConfigured() ? options : null;
    }

    public static void apply(java.net.SocketOptions options, ServerSocket socket) throws SocketException {
        if (options == null || socket.isClosed()) {
            return;
        }
        try {
            Object oOption;
            if (!socket.isBound() && (oOption = options.getOption(4)) != null) {
                boolean fReuse = (Boolean)oOption;
                if (!s_fWarnReuseAddr && fReuse != socket.getReuseAddress()) {
                    s_fWarnReuseAddr = true;
                    SocketOptions.warnReuseAddr(fReuse);
                }
                socket.setReuseAddress(fReuse);
            }
            if ((oOption = options.getOption(4098)) != null) {
                int cb = (Integer)oOption;
                socket.setReceiveBufferSize(cb);
                int cbReal = socket.getReceiveBufferSize();
                if (cbReal < cb) {
                    SocketOptions.warnBufferSize(socket, "receive", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4102)) != null) {
                socket.setSoTimeout((Integer)oOption);
            }
        }
        catch (SocketException e) {
            if (socket.isClosed()) {
                return;
            }
            throw e;
        }
    }

    public static void apply(java.net.SocketOptions options, Socket socket) throws SocketException {
        if (options == null || socket.isClosed()) {
            return;
        }
        try {
            int cbReal;
            int cb;
            Object oOption;
            if (!socket.isBound() && (oOption = options.getOption(4)) != null) {
                boolean fReuse = (Boolean)oOption;
                if (!s_fWarnReuseAddr && fReuse != socket.getReuseAddress()) {
                    s_fWarnReuseAddr = true;
                    SocketOptions.warnReuseAddr(fReuse);
                }
                socket.setReuseAddress(fReuse);
            }
            if ((oOption = options.getOption(4098)) != null) {
                cb = (Integer)oOption;
                socket.setReceiveBufferSize(cb);
                cbReal = socket.getReceiveBufferSize();
                if (cbReal < cb) {
                    SocketOptions.warnBufferSize(socket, "receive", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4097)) != null) {
                cb = (Integer)oOption;
                socket.setSendBufferSize(cb);
                cbReal = socket.getSendBufferSize();
                if (cbReal < cb) {
                    SocketOptions.warnBufferSize(socket, "send", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4102)) != null) {
                socket.setSoTimeout((Integer)oOption);
            }
            if ((oOption = options.getOption(128)) != null) {
                socket.setSoLinger(true, (Integer)oOption);
            }
            if ((oOption = options.getOption(8)) != null) {
                socket.setKeepAlive((Boolean)oOption);
            }
            if ((oOption = options.getOption(1)) != null) {
                socket.setTcpNoDelay((Boolean)oOption);
            }
            if ((oOption = options.getOption(3)) != null) {
                socket.setTrafficClass((Integer)oOption);
            }
        }
        catch (SocketException e) {
            if (socket.isClosed()) {
                return;
            }
            throw e;
        }
    }

    public static void apply(java.net.SocketOptions options, DatagramSocket socket) throws SocketException {
        if (options == null || socket.isClosed()) {
            return;
        }
        if (socket instanceof TcpDatagramSocket) {
            ((TcpDatagramSocket)socket).setSocketOptions(options);
        }
        try {
            int cbReal;
            int cb;
            Object oOption;
            if (!socket.isBound() && (oOption = options.getOption(4)) != null) {
                boolean fReuse = (Boolean)oOption;
                if (!s_fWarnReuseAddr && fReuse != socket.getReuseAddress()) {
                    s_fWarnReuseAddr = true;
                    SocketOptions.warnReuseAddr(fReuse);
                }
                socket.setReuseAddress(fReuse);
            }
            if ((oOption = options.getOption(4098)) != null) {
                cb = (Integer)oOption;
                socket.setReceiveBufferSize(cb);
                cbReal = socket.getReceiveBufferSize();
                if (cbReal < cb) {
                    SocketOptions.warnBufferSize(socket, "receive", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4097)) != null) {
                cb = (Integer)oOption;
                socket.setSendBufferSize(cb);
                cbReal = socket.getSendBufferSize();
                if (cbReal < cb) {
                    SocketOptions.warnBufferSize(socket, "send", cb, cbReal);
                }
            }
            if ((oOption = options.getOption(4102)) != null) {
                socket.setSoTimeout((Integer)oOption);
            }
        }
        catch (SocketException e) {
            if (socket.isClosed()) {
                return;
            }
            throw e;
        }
    }

    public void apply(java.net.SocketOptions options, MulticastSocket socket) throws SocketException {
        SocketOptions.apply(options, socket);
    }
}

