/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.events.internal;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.events.Event;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.internal.AbstractEvent;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.Continuation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbstractEventDispatcher
implements EventDispatcher {
    protected Set<Enum> m_setTypes;
    protected Map<Enum, List<NamedInterceptor>> m_mapInterceptors = new ConcurrentHashMap<Enum, List<NamedInterceptor>>();

    public AbstractEventDispatcher() {
        this(new HashSet<Enum>());
    }

    public AbstractEventDispatcher(Set<Enum> setTypes) {
        this.m_setTypes = setTypes;
    }

    @Override
    public void addEventInterceptor(String sName, EventInterceptor interceptor, Set<Enum> setTypes, boolean fFirst) {
        Map<Enum, List<NamedInterceptor>> mapInterceptors = this.getInterceptorMap();
        NamedInterceptor namedInterceptor = new NamedInterceptor(sName, interceptor);
        for (Enum eventType : this.getSupportedTypes()) {
            if (setTypes != null && !setTypes.contains(eventType)) continue;
            List<NamedInterceptor> listInterceptors = mapInterceptors.get(eventType);
            if (listInterceptors == null) {
                listInterceptors = new CopyOnWriteArrayList<NamedInterceptor>();
                mapInterceptors.put(eventType, listInterceptors);
            }
            if (fFirst) {
                listInterceptors.add(0, namedInterceptor);
                continue;
            }
            listInterceptors.add(namedInterceptor);
        }
    }

    public Map<Enum, List<NamedInterceptor>> getInterceptorMap() {
        return this.m_mapInterceptors;
    }

    @Override
    public Set<Enum> getSupportedTypes() {
        return this.m_setTypes;
    }

    @Override
    public void removeEventInterceptor(String sName) {
        Map<Enum, List<NamedInterceptor>> mapInterceptors = this.getInterceptorMap();
        Iterator<Map.Entry<Enum, List<NamedInterceptor>>> iter = mapInterceptors.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Enum, List<NamedInterceptor>> entry = iter.next();
            List<NamedInterceptor> listInterceptors = entry.getValue();
            for (NamedInterceptor interceptor : listInterceptors) {
                if (!interceptor.getRegisteredName().equals(sName)) continue;
                listInterceptors.remove(interceptor);
                break;
            }
            if (!listInterceptors.isEmpty()) continue;
            iter.remove();
        }
    }

    public boolean isSubscribed(Enum eventType) {
        return this.getInterceptorMap().containsKey(eventType);
    }

    public Continuation getAddInterceptorContinuation(final String sIdentifier, final EventInterceptor interceptor, final Set<Enum> setTypes, final boolean fFirst) {
        return new Continuation(){

            @Override
            public void proceed(Object oResult) {
                AbstractEventDispatcher.this.addEventInterceptor(sIdentifier, interceptor, setTypes, fFirst);
            }
        };
    }

    public Continuation getRemoveInterceptorContinuation(final String sIdentifier) {
        return new Continuation(){

            @Override
            public void proceed(Object oResult) {
                AbstractEventDispatcher.this.removeEventInterceptor(sIdentifier);
            }
        };
    }

    protected Continuation getDispatchContinuation(final AbstractEvent event, final Continuation continuation) {
        return new Continuation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void proceed(Object oResult) {
                try {
                    List<NamedInterceptor> list = AbstractEventDispatcher.this.getInterceptorMap().get(event.getType());
                    if (list != null) {
                        event.dispatch(list);
                    }
                }
                catch (EventDeathException eDeath) {
                    if (continuation == null) {
                        throw new RuntimeException("Event " + event + " was vetoed", eDeath);
                    }
                    oResult = eDeath;
                }
                catch (Exception e) {
                    CacheFactory.log("Unexpected exception " + e + " while dispatching " + event + "\n" + Base.getStackTrace(e), 1);
                }
                finally {
                    if (continuation != null) {
                        continuation.proceed(oResult);
                    }
                }
            }
        };
    }

    protected static class NamedInterceptor
    implements EventInterceptor {
        protected String m_sName;
        protected EventInterceptor m_interceptor;

        public NamedInterceptor(String sName, EventInterceptor interceptor) {
            this.m_sName = sName;
            this.m_interceptor = interceptor;
        }

        public String getRegisteredName() {
            return this.m_sName;
        }

        public EventInterceptor getInterceptor() {
            return this.m_interceptor;
        }

        @Override
        public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            this.getInterceptor().introduceEventDispatcher(sIdentifier, dispatcher);
        }

        @Override
        public void onEvent(Event event) {
            this.getInterceptor().onEvent(event);
        }

        public String toString() {
            return this.m_sName;
        }
    }
}

