/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.internal;

import com.tangosol.net.AbstractPriorityTask;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.InvocableMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LockHolderLookup
extends AbstractPriorityTask
implements InvocableMap.ParallelAwareAggregator {
    private static final long REQUEST_TIMEOUT_MILLIS = 1000L;

    public LockHolderLookup() {
        this.setRequestTimeoutMillis(1000L);
    }

    @Override
    public Object aggregate(Set setEntries) {
        Integer IHolderId = null;
        Iterator iter = setEntries.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        InvocableMap.Entry entry = (InvocableMap.Entry)iter.next();
        try {
            Object storage = ClassHelper.invoke(entry, "getStorage", null);
            Map mapLease = (Map)ClassHelper.invoke(storage, "getLeaseMap", null);
            Object binKey = ClassHelper.invoke(entry, "getBinaryKey", null);
            Object lease = mapLease.get(binKey);
            IHolderId = lease == null ? null : (Integer)ClassHelper.invoke(lease, "getHolderId", null);
        }
        catch (Exception e) {
            CacheFactory.log("Could not get lease information for " + entry.getKey() + ": " + e, 4);
        }
        return IHolderId;
    }

    @Override
    public InvocableMap.EntryAggregator getParallelAggregator() {
        return this;
    }

    @Override
    public Object aggregateResults(Collection collResults) {
        return collResults.isEmpty() ? null : collResults.iterator().next();
    }
}

