/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractSparseArray;

public class PrimitiveSparseArray
extends AbstractSparseArray {
    public long getPrimitive(long lIndex) {
        PrimitiveNode node = (PrimitiveNode)this.find(lIndex);
        return node == null ? -1L : node.getPrimitiveValue();
    }

    public long removePrimitive(long lIndex) {
        PrimitiveNode node = (PrimitiveNode)this.find(lIndex);
        if (node == null) {
            return -1L;
        }
        this.remove(node);
        return node.getPrimitiveValue();
    }

    public long setPrimitive(long lIndex, long lValue) {
        AbstractSparseArray.Node node = this.findInsertionPoint(lIndex);
        if (node != null && node.key == lIndex) {
            return ((PrimitiveNode)node).setPrimitiveValue(lValue);
        }
        this.balancedInsertion(node, this.instantiateNode(lIndex, lValue));
        return -1L;
    }

    @Override
    protected AbstractSparseArray.Node instantiateNode(long lKey, Object oValue) {
        return this.instantiateNode(lKey, (Long)oValue);
    }

    protected AbstractSparseArray.Node instantiateNode(long lKey, long lValue) {
        return new PrimitiveNode(lKey, lValue);
    }

    @Override
    protected AbstractSparseArray.Crawler instantiateCrawler(AbstractSparseArray.Node head, int fromdir, boolean fForward) {
        return new Iterator(head, fromdir, fForward);
    }

    public class Iterator
    extends AbstractSparseArray.Crawler {
        protected Iterator(AbstractSparseArray.Node head, int fromdir, boolean fForward) {
            super(head, fromdir, fForward);
        }

        public long nextPrimitive() {
            return ((PrimitiveNode)this.nextNode()).getPrimitiveValue();
        }

        public long getPrimitiveValue() {
            return ((PrimitiveNode)this.currentNode()).getPrimitiveValue();
        }

        public long setPrimitiveValue(long lValue) {
            return ((PrimitiveNode)this.currentNode()).setPrimitiveValue(lValue);
        }
    }

    protected static class PrimitiveNode
    extends AbstractSparseArray.Node {
        protected long m_lValue;

        public PrimitiveNode(long lKey, long lValue) {
            this.key = lKey;
            this.m_lValue = lValue;
        }

        @Override
        public Object setValue(Object oValue) {
            return new Long(this.setPrimitiveValue((Long)oValue));
        }

        @Override
        public Object getValue() {
            return new Long(this.getPrimitiveValue());
        }

        public long setPrimitiveValue(long lValue) {
            long lOldValue = this.m_lValue;
            this.m_lValue = lValue;
            return lOldValue;
        }

        public long getPrimitiveValue() {
            return this.m_lValue;
        }
    }
}

