/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util.aggregator;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SimpleQueryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class QueryRecorder
implements InvocableMap.ParallelAwareAggregator,
ExternalizableLite,
PortableObject {
    private RecordType m_type;

    public QueryRecorder() {
    }

    public QueryRecorder(RecordType type) {
        this.m_type = type;
    }

    public RecordType getType() {
        return this.m_type;
    }

    @Override
    public Object aggregate(Set setEntries) {
        throw new UnsupportedOperationException("QueryRecorder cannot be used by this service.");
    }

    @Override
    public InvocableMap.EntryAggregator getParallelAggregator() {
        return this;
    }

    @Override
    public Object aggregateResults(Collection collResults) {
        return new SimpleQueryRecord(this.m_type, collResults);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_type = RecordType.fromInt(in.readInt());
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_type.toInt());
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_type = RecordType.fromInt(in.readInt(0));
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_type.toInt());
    }

    public static enum RecordType {
        EXPLAIN,
        TRACE;


        public int toInt() {
            return this.ordinal();
        }

        public static RecordType fromInt(int nOrdinal) {
            return ((RecordType[])RecordType.class.getEnumConstants())[nOrdinal];
        }
    }
}

