/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractStableIterator<T>
implements Iterator<T>,
Enumeration<T> {
    private boolean m_fNextReady;
    private T m_oNext;
    private boolean m_fCanDelete;
    private T m_oPrev;

    @Override
    public boolean hasNext() {
        if (this.m_fNextReady) {
            return true;
        }
        this.advance();
        return this.m_fNextReady;
    }

    @Override
    public T next() {
        if (!this.m_fNextReady) {
            this.advance();
            if (!this.m_fNextReady) {
                throw new NoSuchElementException();
            }
        }
        T oNext = this.m_oNext;
        this.m_fNextReady = false;
        this.m_fCanDelete = true;
        this.m_oPrev = oNext;
        return oNext;
    }

    @Override
    public void remove() {
        if (!this.m_fCanDelete) {
            throw new IllegalStateException();
        }
        this.m_fCanDelete = false;
        this.remove(this.m_oPrev);
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public T nextElement() {
        return this.next();
    }

    protected T getPrevious() {
        return this.m_oPrev;
    }

    protected void setNext(T oNext) {
        this.m_oNext = oNext;
        this.m_fNextReady = true;
    }

    protected abstract void advance();

    protected void remove(Object oPrev) {
        throw new UnsupportedOperationException();
    }
}

