/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import com.oracle.common.collections.Collections;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Enumeration<E>,
Iterator<E> {
    private static final Object[] EMPTY_ARRAY = Collections.EMPTY_ARRAY;
    protected final E[] m_aoItem;
    protected int m_iItem;
    protected final int m_ofLimit;
    protected final boolean m_fForward;

    public ArrayIterator(E[] aoItem) {
        this(aoItem, 0, aoItem.length, true, false);
    }

    public ArrayIterator(E[] aoItem, int ofStart, int cItems) {
        this(aoItem, ofStart, cItems, true, false);
    }

    public ArrayIterator(E[] aoItem, int ofStart, int cItems, boolean fForward, boolean fCopy) {
        if (cItems < 0) {
            throw new IllegalArgumentException("Negative count: " + cItems);
        }
        if (fForward ? ofStart < 0 || ofStart + cItems > aoItem.length : ofStart >= aoItem.length || ofStart - cItems < 0) {
            throw new IllegalArgumentException("Bad limits: aoItem.length=" + aoItem.length + ", ofStart=" + ofStart + ", cItems=" + cItems + ", fForward=" + fForward);
        }
        if (fCopy && cItems > 0) {
            aoItem = (Object[])aoItem.clone();
        }
        this.m_aoItem = aoItem;
        this.m_fForward = fForward;
        this.m_iItem = ofStart;
        this.m_ofLimit = fForward ? ofStart + cItems : ofStart - cItems;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public E nextElement() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        return this.m_fForward ? this.m_iItem < this.m_ofLimit : this.m_iItem > this.m_ofLimit;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            E o = this.m_aoItem[this.m_iItem];
            this.m_iItem = this.m_fForward ? ++this.m_iItem : --this.m_iItem;
            return o;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("iterator is immutable");
    }

    public E[] toArray() {
        return this.toArray(null);
    }

    public <T> T[] toArray(T[] ao) {
        int co;
        E[] aoItem = this.m_aoItem;
        int iNext = this.m_iItem;
        int iLast = this.m_ofLimit;
        boolean fForward = this.m_fForward;
        int n = co = fForward ? iLast - iNext : iNext - iLast;
        if (ao == null) {
            ao = new Object[co];
        } else if (ao.length < co) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), co);
        } else if (ao.length > co) {
            ao[co] = null;
        }
        if (fForward) {
            System.arraycopy(aoItem, iNext, ao, 0, co);
        } else {
            int i = 0;
            while (iNext > iLast) {
                ao[i++] = aoItem[iNext--];
            }
        }
        this.m_iItem = iLast;
        return ao;
    }
}

