/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.collections;

import com.oracle.common.collections.Collections;
import java.io.Serializable;
import java.util.Map;

public class SimpleMapEntry<K, V>
implements Map.Entry<K, V>,
Cloneable,
Serializable {
    protected K m_oKey;
    protected V m_oValue;

    public SimpleMapEntry(K oKey, V oValue) {
        this.m_oKey = oKey;
        this.m_oValue = oValue;
    }

    @Override
    public K getKey() {
        return this.m_oKey;
    }

    @Override
    public V getValue() {
        return this.m_oValue;
    }

    @Override
    public V setValue(V oValue) {
        V oPrev = this.m_oValue;
        this.m_oValue = oValue;
        return oPrev;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry that = (Map.Entry)o;
        return this == that || Collections.equals(this.getKey(), that.getKey()) && Collections.equals(this.getValue(), that.getValue());
    }

    @Override
    public int hashCode() {
        K oKey = this.getKey();
        V oValue = this.getValue();
        return (oKey == null ? 0 : oKey.hashCode()) ^ (oValue == null ? 0 : oValue.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry{Key=\"").append(this.getKey()).append("\", Value=\"").append(this.getValue()).append("\"}");
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

