/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.io;

import com.oracle.common.io.BufferManager;
import java.nio.ByteBuffer;

public abstract class AbstractBufferManager
implements BufferManager {
    @Override
    public ByteBuffer acquirePref(int cbPref) {
        if (cbPref <= this.getMaximumUnitSize()) {
            try {
                return this.acquire(cbPref);
            }
            catch (OutOfMemoryError e) {
                // empty catch block
            }
        }
        try {
            return this.acquire(this.getPreferredUnitSize());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return this.acquire(this.getMinimumUnitSize());
        }
    }

    @Override
    public ByteBuffer acquireSum(int cbSum) {
        return (ByteBuffer)this.acquirePref(Math.max(this.getMinimumUnitSize(), cbSum)).clear();
    }

    @Override
    public ByteBuffer truncate(ByteBuffer buff) {
        this.ensureCompatibility(buff);
        int cbUsed = buff.remaining();
        if (this.isUnderUtilized(buff)) {
            ByteBuffer buffNew;
            try {
                buffNew = this.acquire(cbUsed);
            }
            catch (OutOfMemoryError e) {
                return buff;
            }
            buffNew.put(buff).flip();
            this.release(buff);
            return buffNew;
        }
        return buff;
    }

    @Override
    public void release(ByteBuffer buff) {
        this.ensureCompatibility(buff);
    }

    protected int getMinimumUnitSize() {
        return 1024;
    }

    protected int getPreferredUnitSize() {
        return 65536;
    }

    protected int getMaximumUnitSize() {
        return Integer.MAX_VALUE;
    }

    protected boolean isUnderUtilized(ByteBuffer buff) {
        int cbCap = buff.capacity();
        return cbCap > this.getMinimumUnitSize() && buff.remaining() < cbCap >>> 3;
    }

    protected void ensureCompatibility(ByteBuffer buff) {
    }
}

