/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net;

import com.oracle.common.base.Factory;
import com.oracle.common.internal.net.RunnableSelectionService;
import com.oracle.common.net.SelectionService;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResumableSelectionService
extends RunnableSelectionService {
    protected final ThreadFactory m_factory;
    protected volatile Thread m_thread;

    public ResumableSelectionService(ThreadFactory factory) {
        this.m_factory = factory;
    }

    @Override
    public void register(SelectableChannel chan, SelectionService.Handler handler) throws IOException {
        super.register(chan, handler);
        if (handler != null) {
            this.ensureThread();
        }
    }

    @Override
    public void invoke(SelectableChannel chan, Runnable runnable) throws IOException {
        super.invoke(chan, runnable);
        this.ensureThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureThread() {
        if (this.m_thread == null) {
            ResumableSelectionService resumableSelectionService = this;
            synchronized (resumableSelectionService) {
                if (this.m_thread == null) {
                    Thread thread = this.m_factory.newThread(this);
                    thread.setName(this.toString());
                    this.m_thread = thread;
                    thread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Thread.currentThread() != this.m_thread) {
            throw new UnsupportedOperationException();
        }
        while (true) {
            try {
                super.run();
            }
            catch (Throwable e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unhandled exception in " + this + ", attempting to continue", e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            ResumableSelectionService resumableSelectionService = this;
            synchronized (resumableSelectionService) {
                if (this.isIdle()) {
                    this.m_thread = null;
                    return;
                }
            }
        }
    }

    public static class ServiceFactory
    implements Factory<ResumableSelectionService> {
        private ThreadFactory m_factory;
        private long m_cMillisTimeout;

        public ServiceFactory(ThreadFactory factoryThread, long cMillisTimeout) {
            this.m_factory = factoryThread;
            this.m_cMillisTimeout = cMillisTimeout;
        }

        @Override
        public ResumableSelectionService create() {
            ResumableSelectionService svc = new ResumableSelectionService(this.m_factory);
            svc.setIdleTimeout(this.m_cMillisTimeout);
            return svc;
        }
    }
}

