/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.internal.net.socketbus;

import com.oracle.common.base.Hasher;
import com.oracle.common.internal.net.socketbus.SocketMessageBus;
import com.oracle.common.io.BufferManager;
import com.oracle.common.io.BufferManagers;
import com.oracle.common.net.InetSocketAddressHasher;
import com.oracle.common.net.SelectionService;
import com.oracle.common.net.SelectionServices;
import com.oracle.common.net.SocketProvider;
import com.oracle.common.net.exabus.Bus;
import com.oracle.common.net.exabus.Depot;
import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.spi.Driver;
import com.oracle.common.net.exabus.util.UrlEndPoint;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOptions;
import java.util.logging.Logger;

public class SocketBusDriver
implements Driver {
    private static Logger LOGGER = Logger.getLogger(SocketBusDriver.class.getName());
    protected Depot m_depot;
    protected Dependencies m_dependencies;

    public SocketBusDriver(Dependencies deps) {
        this.m_dependencies = this.copyDependencies(deps).validate();
    }

    @Override
    public void setDepot(Depot depot) {
        this.m_depot = depot;
    }

    @Override
    public Depot getDepot() {
        return this.m_depot;
    }

    @Override
    public EndPoint resolveEndPoint(String sName) {
        block5: {
            if (sName == null) {
                return null;
            }
            Dependencies deps = this.getDependencies();
            String sMsg = deps.getMessageBusProtocol();
            String sMem = deps.getMemoryBusProtocol();
            if (sName.startsWith(sMsg) || sName.startsWith(sMem)) {
                try {
                    UrlEndPoint point = this.resolveSocketEndPoint(sName);
                    String sProtocol = point.getProtocol();
                    if (sProtocol.equals(sMsg) || sProtocol.equals(sMem)) {
                        return point;
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!sName.startsWith(sMsg + "://") && !sName.startsWith(sMem + "://")) break block5;
                    throw e;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isSupported(EndPoint point) {
        if (point == null) {
            return true;
        }
        if (point instanceof UrlEndPoint) {
            Dependencies deps = this.getDependencies();
            String sProtocol = ((UrlEndPoint)point).getProtocol();
            return sProtocol.equals(deps.getMessageBusProtocol()) || sProtocol.equals(deps.getMemoryBusProtocol());
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Bus createBus(EndPoint pointLocal) {
        if (!this.isSupported(pointLocal)) throw new IllegalArgumentException("unsupported EndPoint " + pointLocal);
        try {
            Dependencies deps = this.getDependencies();
            UrlEndPoint pointSocket = (UrlEndPoint)pointLocal;
            String sProtocol = pointSocket.getProtocol();
            if (sProtocol.equals(deps.getMessageBusProtocol())) {
                return new SocketMessageBus(this, pointSocket);
            }
            if (!sProtocol.equals(deps.getMemoryBusProtocol())) throw new IllegalArgumentException("unsupported EndPoint " + pointLocal);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating SocketBus instance for " + pointLocal, e);
        }
        throw new IllegalArgumentException("unsupported EndPoint " + pointLocal);
    }

    public UrlEndPoint resolveSocketEndPoint(String sName) {
        Dependencies deps = this.getDependencies();
        return new UrlEndPoint(sName, deps.getSocketProvider(), deps.getSocketAddressHasher());
    }

    public UrlEndPoint resolveBindPoint(String sProtocol, ServerSocket socket) {
        Dependencies deps = this.getDependencies();
        SocketProvider provider = deps.getSocketProvider();
        return new UrlEndPoint(sProtocol + "://" + provider.getAddressString(socket), provider, deps.getSocketAddressHasher());
    }

    public Dependencies getDependencies() {
        return this.m_dependencies;
    }

    protected DefaultDependencies copyDependencies(Dependencies deps) {
        return new DefaultDependencies(deps);
    }

    public static class DefaultDependencies
    implements Dependencies {
        protected SocketProvider m_provider;
        protected Hasher<? super SocketAddress> m_hasher;
        protected SelectionService m_service;
        protected String m_sProtocolMessageBus;
        protected String m_sProtocolMemoryBus;
        protected SocketOptions m_options;
        protected BufferManager m_bufferManager;
        protected Logger m_logger;
        protected long m_cReconnectDelayMillis = 200L;
        protected long m_cMaxReceiptDelayMillis = 500L;
        protected long m_cbAutoFlushThreshold = -1L;
        protected long m_cbForcedAckThreshold = -1L;
        public static final BufferManager DEFAULT_BUFFER_MANAGER = BufferManagers.getNetworkDirectManager();
        public static final SocketOptions DEFAULT_OPTIONS = new SocketOptions(){

            @Override
            public void setOption(int optID, Object value) throws SocketException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getOption(int optID) throws SocketException {
                switch (optID) {
                    case 1: {
                        return Boolean.TRUE;
                    }
                }
                return null;
            }
        };

        public DefaultDependencies() {
        }

        public DefaultDependencies(Dependencies deps) {
            if (deps != null) {
                this.m_provider = deps.getSocketProvider();
                this.m_hasher = deps.getSocketAddressHasher();
                this.m_service = deps.getSelectionService();
                this.m_sProtocolMessageBus = deps.getMessageBusProtocol();
                this.m_sProtocolMemoryBus = deps.getMemoryBusProtocol();
                this.m_options = deps.getSocketOptions();
                this.m_bufferManager = deps.getBufferManager();
                this.m_logger = deps.getLogger();
                this.m_cMaxReceiptDelayMillis = deps.getMaximumReceiptDelayMillis();
                this.m_cReconnectDelayMillis = deps.getSocketReconnectDelayMillis();
                this.m_cbAutoFlushThreshold = deps.getAutoFlushThreshold();
                this.m_cbForcedAckThreshold = deps.getForceAckThreshold();
            }
        }

        @Override
        public String getMessageBusProtocol() {
            return this.m_sProtocolMessageBus;
        }

        public DefaultDependencies setMessageBusProtocol(String sProtocol) {
            this.m_sProtocolMessageBus = sProtocol;
            return this;
        }

        @Override
        public String getMemoryBusProtocol() {
            return this.m_sProtocolMemoryBus;
        }

        public DefaultDependencies setMemoryBusProtocol(String sProtocol) {
            this.m_sProtocolMemoryBus = sProtocol;
            return this;
        }

        @Override
        public SelectionService getSelectionService() {
            SelectionService svc = this.m_service;
            return svc == null ? SelectionServices.getDefaultService() : svc;
        }

        public DefaultDependencies setSelectionService(SelectionService service) {
            this.m_service = service;
            return this;
        }

        @Override
        public SocketProvider getSocketProvider() {
            return this.m_provider;
        }

        public DefaultDependencies setSocketProvider(SocketProvider provider) {
            this.m_provider = provider;
            return this;
        }

        @Override
        public Hasher<? super SocketAddress> getSocketAddressHasher() {
            Hasher<? super SocketAddress> hasher = this.m_hasher;
            if (hasher == null) {
                return InetSocketAddressHasher.INSTANCE;
            }
            return hasher;
        }

        public DefaultDependencies setSocketAddressHahser(Hasher<? super SocketAddress> hasher) {
            this.m_hasher = hasher;
            return this;
        }

        @Override
        public SocketOptions getSocketOptions() {
            SocketOptions options = this.m_options;
            return options == null ? DEFAULT_OPTIONS : options;
        }

        public DefaultDependencies setSocketOptions(SocketOptions options) {
            this.m_options = options;
            return this;
        }

        @Override
        public BufferManager getBufferManager() {
            BufferManager manager = this.m_bufferManager;
            return manager == null ? DEFAULT_BUFFER_MANAGER : manager;
        }

        public DefaultDependencies setBufferManager(BufferManager manager) {
            this.m_bufferManager = manager;
            return this;
        }

        @Override
        public Logger getLogger() {
            Logger logger = this.m_logger;
            return logger == null ? LOGGER : logger;
        }

        public DefaultDependencies setLogger(Logger logger) {
            this.m_logger = logger;
            return this;
        }

        @Override
        public long getMaximumReceiptDelayMillis() {
            return this.m_cMaxReceiptDelayMillis;
        }

        public DefaultDependencies setMaximumReceiptDelayMillis(long cDelayMillis) {
            this.m_cMaxReceiptDelayMillis = cDelayMillis;
            return this;
        }

        @Override
        public long getSocketReconnectDelayMillis() {
            return this.m_cReconnectDelayMillis;
        }

        public DefaultDependencies setSocketReconnectDelayMillis(long cDelayMillis) {
            this.m_cReconnectDelayMillis = cDelayMillis;
            return this;
        }

        @Override
        public long getAutoFlushThreshold() {
            return this.m_cbAutoFlushThreshold;
        }

        public DefaultDependencies setAutoFlushThreshold(long cbThreshold) {
            this.m_cbAutoFlushThreshold = cbThreshold;
            return this;
        }

        @Override
        public long getForceAckThreshold() {
            return this.m_cbForcedAckThreshold;
        }

        public DefaultDependencies setForceAckThreshold(long threshold) {
            this.m_cbForcedAckThreshold = threshold;
            return this;
        }

        protected DefaultDependencies validate() {
            DefaultDependencies.ensureArgument(this.getMemoryBusProtocol(), "MemoryBusProtocol");
            DefaultDependencies.ensureArgument(this.getMessageBusProtocol(), "MessageBusProtocol");
            DefaultDependencies.ensureArgument(this.getSelectionService(), "SelectionService");
            DefaultDependencies.ensureArgument(this.getSocketAddressHasher(), "SocketAddressHasher");
            DefaultDependencies.ensureArgument(this.getSocketProvider(), "SocketProvider");
            if (this.getMemoryBusProtocol().equals(this.getMessageBusProtocol())) {
                throw new IllegalArgumentException("memory and mess bus protocols cannot use the sane names");
            }
            return this;
        }

        protected static void ensureArgument(Object o, String sName) {
            if (o == null) {
                throw new IllegalArgumentException(sName + " cannot be null");
            }
        }
    }

    public static interface Dependencies {
        public String getMessageBusProtocol();

        public String getMemoryBusProtocol();

        public SelectionService getSelectionService();

        public SocketProvider getSocketProvider();

        public Hasher<? super SocketAddress> getSocketAddressHasher();

        public SocketOptions getSocketOptions();

        public BufferManager getBufferManager();

        public Logger getLogger();

        public long getMaximumReceiptDelayMillis();

        public long getSocketReconnectDelayMillis();

        public long getAutoFlushThreshold();

        public long getForceAckThreshold();
    }
}

