/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddress32
extends SocketAddress {
    private String hostname = null;
    private InetAddress addr = null;
    private int port;

    private InetSocketAddress32() {
    }

    public InetSocketAddress32(int port) {
        this((InetAddress)null, port);
    }

    public InetSocketAddress32(InetAddress addr, int port) {
        this.port = port;
        if (addr == null) {
            try {
                this.addr = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.addr = addr;
        }
    }

    public InetSocketAddress32(String hostname, int port) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        try {
            this.addr = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            this.hostname = hostname;
            this.addr = null;
        }
        this.port = port;
    }

    public static InetSocketAddress32 createUnresolved(String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        InetSocketAddress32 s = new InetSocketAddress32();
        s.port = port;
        s.hostname = host;
        s.addr = null;
        return s;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.hostname == null && this.addr == null) {
            throw new InvalidObjectException("hostname and addr can't both be null");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.addr != null) {
            return this.addr.getHostName();
        }
        return null;
    }

    final String getHostString() {
        if (this.hostname != null) {
            return this.hostname;
        }
        if (this.addr != null) {
            if (this.addr.getHostName() != null) {
                return this.addr.getHostName();
            }
            return this.addr.getHostAddress();
        }
        return null;
    }

    public final boolean isUnresolved() {
        return this.addr == null;
    }

    public String toString() {
        if (this.isUnresolved()) {
            return this.hostname + ":" + this.port;
        }
        return this.addr.toString() + ":" + this.port;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !(obj instanceof InetSocketAddress32)) {
            return false;
        }
        InetSocketAddress32 sockAddr = (InetSocketAddress32)obj;
        boolean sameIP = false;
        sameIP = this.addr != null ? this.addr.equals(sockAddr.addr) : (this.hostname != null ? sockAddr.addr == null && this.hostname.equals(sockAddr.hostname) : sockAddr.addr == null && sockAddr.hostname == null);
        return sameIP && this.port == sockAddr.port;
    }

    public final int hashCode() {
        if (this.addr != null) {
            return this.addr.hashCode() + this.port;
        }
        if (this.hostname != null) {
            return this.hostname.hashCode() + this.port;
        }
        return this.port;
    }
}

