/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import com.oracle.common.net.SelectionService;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public abstract class SafeSelectionHandler<C extends SelectableChannel>
implements SelectionService.Handler {
    private final C m_channel;

    protected SafeSelectionHandler(C channel) {
        this.m_channel = channel;
    }

    protected abstract int onReadySafe(int var1) throws IOException;

    protected int onException(Throwable t) {
        try {
            ((AbstractInterruptibleChannel)this.m_channel).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public C getChannel() {
        return this.m_channel;
    }

    @Override
    public final int onReady(int nOps) {
        try {
            return this.onReadySafe(nOps);
        }
        catch (Throwable t) {
            return this.onException(t);
        }
    }
}

