/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.common.net;

import com.oracle.common.base.Factory;
import com.oracle.common.internal.net.HashSelectionService;
import com.oracle.common.internal.net.MultiProviderSelectionService;
import com.oracle.common.internal.net.ResumableSelectionService;
import com.oracle.common.net.SelectionService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class SelectionServices {
    public static SelectionService getDefaultService() {
        return DefaultServiceHolder.INSTANCE;
    }

    private static final class DefaultServiceHolder {
        private static final SelectionService INSTANCE;

        private DefaultServiceHolder() {
        }

        static {
            int cThreads = Runtime.getRuntime().availableProcessors();
            try {
                String sThreads = System.getProperty("selection.service.threads");
                if (sThreads != null) {
                    cThreads = Math.abs(Integer.parseInt(sThreads));
                }
            }
            catch (SecurityException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            long cMillisTimeout = 5000L;
            try {
                String sSec = System.getProperty("selection.service.timeout");
                if (sSec != null) {
                    cMillisTimeout = Math.abs(Integer.parseInt(sSec) * 1000);
                }
            }
            catch (SecurityException e) {
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ThreadFactory factoryThread = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = Executors.defaultThreadFactory().newThread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            INSTANCE = new MultiProviderSelectionService((Factory)new HashSelectionService.ServiceFactory(cThreads, new ResumableSelectionService.ServiceFactory(factoryThread, cMillisTimeout))){

                @Override
                public void shutdown() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

