/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.common.net.exabus.Depot;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Cluster$SocketManager$AcceptorChannel;
import com.tangosol.coherence.component.net.Cluster$SocketManager$MulticastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$PreferredUnicastUdpSocket;
import com.tangosol.coherence.component.net.Cluster$SocketManager$UnicastUdpSocket;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketProvider;
import com.tangosol.net.TcpDatagramSocket;
import com.tangosol.net.TcpSocketProvider;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class Cluster$SocketManager
extends Util {
    private transient Depot __m_Depot;
    private SocketProvider __m_SocketProvider;

    public Cluster$SocketManager() {
        this(null, null, true);
    }

    public Cluster$SocketManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new Cluster$SocketManager$AcceptorChannel("AcceptorChannel", this, true), "AcceptorChannel");
        this._addChild(new Cluster$SocketManager$MulticastUdpSocket("MulticastUdpSocket", this, true), "MulticastUdpSocket");
        this._addChild(new Cluster$SocketManager$PreferredUnicastUdpSocket("PreferredUnicastUdpSocket", this, true), "PreferredUnicastUdpSocket");
        this._addChild(new Cluster$SocketManager$UnicastUdpSocket("UnicastUdpSocket", this, true), "UnicastUdpSocket");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void bindSockets() throws IOException {
        DatagramSocket socketUdp;
        ClusterDependencies config = ((Cluster)this.get_Module()).getDependencies();
        Cluster$SocketManager$AcceptorChannel acceptorChannel = this.getAcceptorChannel();
        Cluster$SocketManager$UnicastUdpSocket udpSocket = this.getUnicastUdpSocket();
        SocketProvider provider = this.getSocketProvider();
        int nPort = config.getLocalPort();
        boolean fAutoAdjust = config.isLocalPortAutoAdjust();
        boolean fBound = false;
        boolean fAddrValidated = false;
        while (true) {
            socketUdp = null;
            AbstractInterruptibleChannel channelTcp = null;
            try {
                udpSocket.setPort(nPort);
                socketUdp = udpSocket.instantiateDatagramSocket();
                if (!config.isTcpRingEnabled() ? false : provider instanceof TcpSocketProvider ^ true) {
                    acceptorChannel.setPort(nPort);
                    channelTcp = acceptorChannel.instantiateChannel();
                    acceptorChannel.setChannel((ServerSocketChannel)channelTcp);
                    acceptorChannel.open();
                }
                udpSocket.setDatagramSocket(socketUdp);
                udpSocket.open();
                fBound = true;
            }
            catch (IOException e1) {
                if (socketUdp != null) {
                    socketUdp.close();
                }
                if (channelTcp != null) {
                    try {
                        channelTcp.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                if (!(!(!(socketUdp == null) ? false : channelTcp == null) ? false : fAddrValidated ^ true)) continue;
                if (InetAddressHelper.getAllLocalAddresses().contains(udpSocket.getInetAddress())) {
                    fAddrValidated = true;
                    continue;
                }
                throw e1;
                if (!fAutoAdjust ? false : ++nPort < 65535) continue;
            }
            break;
        }
        if (fBound) {
            fBound = false;
            ++nPort;
            Cluster$SocketManager$PreferredUnicastUdpSocket udpSocketPref = this.getPreferredUnicastUdpSocket();
            while (true) {
                DatagramSocket socketUdpPref = null;
                try {
                    udpSocketPref.setPort(nPort);
                    socketUdpPref = udpSocketPref.instantiateDatagramSocket();
                    udpSocketPref.setDatagramSocket(socketUdpPref);
                    udpSocketPref.open();
                    fBound = true;
                }
                catch (IOException e1) {
                    if (!(socketUdpPref != null)) continue;
                    socketUdpPref.close();
                    if (!fAutoAdjust ? false : ++nPort < 65536) continue;
                }
                break;
            }
        }
        if (!fBound) {
            throw new IOException(String.valueOf(provider) + " unable find available port(s)");
        }
        Component._trace(String.valueOf("TCMP bound to ") + socketUdp.getLocalSocketAddress() + " using " + provider, 4);
        Cluster$SocketManager$MulticastUdpSocket udpsocketMulticast = this.getMulticastUdpSocket();
        if (udpsocketMulticast.getInetAddress() != null) {
            try {
                udpsocketMulticast.open();
            }
            catch (UnsupportedOperationException e) {
                throw new UnsupportedOperationException(String.valueOf("Multicast is not supported by ") + provider + ", consider enabling well-known-addresses", e);
            }
        }
    }

    public void configure(DatagramSocket socket) throws IOException {
        if (socket instanceof TcpDatagramSocket) {
            TcpDatagramSocket datagram = (TcpDatagramSocket)socket;
            datagram.setPacketMagic(0xDDF00D0, -16);
            ClusterDependencies config = ((Cluster)this.get_Module()).getDependencies();
            datagram.setSocketOptions(config.getTcpDatagramSocketOptions());
            datagram.setListenBacklog(config.getTcpBacklog());
        }
    }

    public void configure(ServerSocket socket) throws IOException {
        ((Cluster)this.get_Module()).getClusterService().getTcpRing().getSocketOptions().apply(socket);
    }

    public Cluster$SocketManager$AcceptorChannel getAcceptorChannel() {
        return (Cluster$SocketManager$AcceptorChannel)this._findChild("AcceptorChannel");
    }

    public Depot getDepot() {
        return this.__m_Depot;
    }

    public Cluster$SocketManager$MulticastUdpSocket getMulticastUdpSocket() {
        return (Cluster$SocketManager$MulticastUdpSocket)this._findChild("MulticastUdpSocket");
    }

    public Cluster$SocketManager$PreferredUnicastUdpSocket getPreferredUnicastUdpSocket() {
        return (Cluster$SocketManager$PreferredUnicastUdpSocket)this._findChild("PreferredUnicastUdpSocket");
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public Cluster$SocketManager$UnicastUdpSocket getUnicastUdpSocket() {
        return (Cluster$SocketManager$UnicastUdpSocket)this._findChild("UnicastUdpSocket");
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Cluster$SocketManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Cluster$SocketManager();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void releaseSockets() {
        this.getUnicastUdpSocket().close();
        this.getPreferredUnicastUdpSocket().close();
        this.getMulticastUdpSocket().close();
        this.getAcceptorChannel().close();
    }

    public void setDepot(Depot depot) {
        this.__m_Depot = depot;
    }

    public void setSocketProvider(SocketProvider pSocketProvider) {
        this.__m_SocketProvider = pSocketProvider;
    }
}

