/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Member$SentQueue;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Member
extends Net
implements ExternalizableLite,
PortableObject,
com.tangosol.net.Member,
Externalizable {
    public static final String[] EDITION_NAME;
    public static final String[] MODE_NAME;
    public static final int SHOW_ALL = -1;
    public static final int SHOW_LICENSE = 1;
    public static final int SHOW_STATS = 2;
    public static final int SHOW_STD = 0;
    private transient InetAddress __m_Address;
    private transient int __m_ByteMask;
    private transient int __m_ByteOffset;
    private String __m_ClusterName;
    private volatile transient PacketIdentifier __m_ContiguousFromPacketId;
    private volatile transient PacketIdentifier __m_ContiguousToPacketId;
    private int __m_CpuCount;
    private transient boolean __m_Dead;
    private transient boolean __m_Deaf;
    private int __m_Edition;
    private transient Member$FlowControl __m_FlowControl;
    private int __m_Id;
    private transient long __m_LastIncomingMessageId;
    private transient long __m_LastIncomingMillis;
    private transient long __m_LastOutgoingMessageId;
    private transient long __m_LastOutgoingMillis;
    private transient long __m_LastSlowMillis;
    private transient long __m_LastTimeoutMillis;
    private transient boolean __m_Leaving;
    private transient int __m_MachineId;
    private String __m_MachineName;
    private String __m_MemberName;
    private transient WindowedArray __m_MessageIncoming;
    private transient SparseArray __m_MessagePile;
    private int __m_Mode;
    private volatile transient PacketIdentifier __m_NewestFromPacketId;
    private volatile transient PacketIdentifier __m_NewestToPacketId;
    private volatile transient Ack __m_PacketAck;
    private transient int __m_Port;
    private int __m_PreferredAckSize;
    private int __m_PreferredPacketLength;
    private transient int __m_PreferredPort;
    private transient InetSocketAddress __m_PreferredSocketAddress;
    private int __m_Priority;
    private String __m_ProcessName;
    private String __m_RackName;
    private transient Member$SentQueue __m_RecentPacketQueue;
    private String __m_RoleName;
    private String __m_SiteName;
    private transient InetSocketAddress __m_SocketAddress;
    private int __m_SocketCount;
    private transient long __m_StatsReceived;
    private transient long __m_StatsRepeated;
    private transient long __m_StatsResent;
    private transient long __m_StatsReset;
    private transient long __m_StatsSent;
    private transient long __m_Timestamp;
    private int __m_TxDebugDropCount;
    private UUID __m_Uid32;
    private static ListMap __mapChildren;

    static {
        try {
            EDITION_NAME = new String[]{"Data Client", "Real-Time Client", "Compute Client", "Standard Edition", "Enterprise Edition", "Grid Edition"};
            MODE_NAME = new String[]{"Evaluation", "Development", "Production"};
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Member.__initStatic();
    }

    public Member() {
        this(null, null, true);
    }

    public Member(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setMessageIncoming(new WindowedArray());
            this.setMessagePile(new SparseArray());
            this.setPreferredAckSize(65535);
            this.setTxDebugDropCount(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("FlowControl", Member$FlowControl.get_CLASS());
        Class clazz2 = __mapChildren.put("SentQueue", Member$SentQueue.get_CLASS());
    }

    public static int calcByteMask(int nId) {
        return 1 << (nId - 1) % 32;
    }

    public static int calcByteOffset(int nId) {
        return (nId - 1) / 32;
    }

    public int compareTo(Object o) {
        UUID uidThis = this.getUid32();
        UUID uidThat = ((Member)o).getUid32();
        return uidThis.compareTo(uidThat);
    }

    public void configure(Member member, long ldtTimestamp) {
        Component._assert(!(!(!(this.getCpuCount() == 0) ? false : this.getSocketCount() == 0) ? false : member.getCpuCount() > 0) ? false : member.getSocketCount() > 0);
        this.setTimestamp(ldtTimestamp <= 0L ? member.getTimestamp() : ldtTimestamp);
        this.setAddress(member.getAddress());
        this.setPort(member.getPort());
        this.setMachineId(member.getMachineId());
        this.setEdition(member.getEdition());
        this.setMode(member.getMode());
        this.setCpuCount(member.getCpuCount());
        this.setSocketCount(member.getSocketCount());
        this.setClusterName(member.getClusterName());
        this.setSiteName(member.getSiteName());
        this.setRackName(member.getRackName());
        this.setMachineName(member.getMachineName());
        this.setProcessName(member.getProcessName());
        this.setMemberName(member.getMemberName());
        this.setRoleName(member.getRoleName());
        this.setPriority(member.getPriority());
    }

    public void configure(ClusterDependencies deps, InetAddress addr, int nPort, int[] an) {
        this.configure(deps.getMemberIdentity(), addr);
        this.setPort(nPort);
        this.setMachineId(an[2]);
        this.setEdition(deps.getEdition());
        this.setMode(deps.getMode());
        this.setCpuCount(an[0]);
        this.setSocketCount(an[1]);
    }

    public void configure(MemberIdentity identity, InetAddress addr) {
        try {
            this.setAddress(addr == null ? InetAddress.getLocalHost() : addr);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.setTimestamp(Base.getSafeTimeMillis());
        this.setClusterName(identity.getClusterName());
        this.setSiteName(identity.getSiteName());
        this.setRackName(identity.getRackName());
        this.setMachineName(identity.getMachineName());
        this.setProcessName(identity.getProcessName());
        this.setMemberName(identity.getMemberName());
        this.setRoleName(identity.getRoleName());
        this.setPriority(identity.getPriority());
    }

    protected void configure(UUID uid) {
        InetAddress addr;
        Component._assert(uid != null);
        long ldt = uid.getTimestamp();
        byte[] abAddr = uid.getAddress();
        int nPort = uid.getPort();
        int nMachineId = uid.getCount();
        try {
            addr = InetAddressHelper.getByAddress(abAddr);
        }
        catch (UnknownHostException e) {
            throw new WrapperException(e);
        }
        this.setTimestamp(ldt);
        this.setAddress(addr);
        this.setPort(nPort);
        this.setMachineId(nMachineId);
        this.setUid32(uid);
    }

    public void declareZombie() {
        Component._assert(this.isDead());
        this.setTimestamp(Base.getSafeTimeMillis());
        this.setDeaf(true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Member) {
            Member that = (Member)obj;
            return Base.equals(this.getUid32(), that.getUid32());
        }
        return false;
    }

    public static Member findWeakestMember(Set setMembers) {
        long lRateWorst = Long.MAX_VALUE;
        Member memberWorst = null;
        while (true) {
            try {
                Iterator iter = setMembers.iterator();
                while (iter.hasNext()) {
                    long cTotal;
                    long lRate;
                    long cErrors;
                    Member member = (Member)iter.next();
                    if (!(member != null) || !((cErrors = member.getStatsResent() + member.getStatsRepeated()) > (long)0) || !((lRate = (cTotal = member.getStatsSent() + member.getStatsReceived()) / cErrors) < lRateWorst)) continue;
                    lRateWorst = lRate;
                    memberWorst = member;
                }
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
        return memberWorst;
    }

    public String formatStats() {
        Member$FlowControl flowControl = this.getFlowControl();
        long ldtNow = Base.getSafeTimeMillis();
        long ldtIn = this.getLastIncomingMillis();
        long ldtOut = this.getLastOutgoingMillis();
        long ldtSlow = this.getLastSlowMillis();
        double dTxSuccess = this.getStatsPublisherSuccessRate();
        double dRxSuccess = this.getStatsReceiverSuccessRate();
        dTxSuccess = (double)((int)(dTxSuccess * (double)10000)) / 10000.0;
        dRxSuccess = (double)((int)(dRxSuccess * (double)10000)) / 10000.0;
        return String.valueOf("PublisherSuccessRate=") + dTxSuccess + ", ReceiverSuccessRate=" + dRxSuccess + (flowControl == null ? "" : String.valueOf(", ") + flowControl.formatStats(true)) + ", LastIn=" + (ldtIn == 0L ? "n/a" : String.valueOf(ldtNow - ldtIn) + "ms") + ", LastOut=" + (ldtOut == 0L ? "n/a" : String.valueOf(ldtNow - ldtOut) + "ms") + ", LastSlow=" + (ldtSlow == 0L ? "n/a" : String.valueOf(ldtNow - ldtSlow) + "ms");
    }

    public InetAddress getAddress() {
        return this.__m_Address;
    }

    public int getByteMask() {
        return this.__m_ByteMask;
    }

    public int getByteOffset() {
        return this.__m_ByteOffset;
    }

    public String getClusterName() {
        return this.__m_ClusterName;
    }

    public PacketIdentifier getContiguousFromPacketId() {
        return this.__m_ContiguousFromPacketId;
    }

    public PacketIdentifier getContiguousToPacketId() {
        return this.__m_ContiguousToPacketId;
    }

    public int getCpuCount() {
        return this.__m_CpuCount;
    }

    public int getEdition() {
        return this.__m_Edition;
    }

    public Member$FlowControl getFlowControl() {
        return this.__m_FlowControl;
    }

    public int getId() {
        return this.__m_Id;
    }

    public long getLastIncomingMessageId() {
        return this.__m_LastIncomingMessageId;
    }

    public long getLastIncomingMillis() {
        return this.__m_LastIncomingMillis;
    }

    protected long getLastOutgoingMessageId() {
        return this.__m_LastOutgoingMessageId;
    }

    public long getLastOutgoingMillis() {
        return this.__m_LastOutgoingMillis;
    }

    public long getLastSlowMillis() {
        return this.__m_LastSlowMillis;
    }

    public long getLastTimeoutMillis() {
        return this.__m_LastTimeoutMillis;
    }

    public String getLicenseInfo() {
        return String.valueOf("Edition=") + EDITION_NAME[this.getEdition()] + ", Mode=" + MODE_NAME[this.getMode()] + ", CpuCount=" + this.getCpuCount() + ", SocketCount=" + this.getSocketCount();
    }

    public String getLocationInfo() {
        String sMember;
        String sProcess;
        String sMachine;
        String sRack;
        StringBuffer sb = new StringBuffer();
        String sSite = this.getSiteName();
        if (sSite != null) {
            sb.append(",site:").append(sSite);
        }
        if ((sRack = this.getRackName()) != null) {
            sb.append(",rack:").append(sRack);
        }
        if ((sMachine = this.getMachineName()) != null) {
            sb.append(",machine:").append(sMachine);
        }
        if ((sProcess = this.getProcessName()) != null) {
            sb.append(",process:").append(sProcess);
        }
        if ((sMember = this.getMemberName()) != null) {
            sb.append(",member:").append(sMember);
        }
        return sb.length() == 0 ? "" : sb.substring(1);
    }

    public int getMachineId() {
        return this.__m_MachineId;
    }

    public String getMachineName() {
        return this.__m_MachineName;
    }

    public String getMemberName() {
        return this.__m_MemberName;
    }

    public WindowedArray getMessageIncoming() {
        return this.__m_MessageIncoming;
    }

    public SparseArray getMessagePile() {
        return this.__m_MessagePile;
    }

    public int getMode() {
        return this.__m_Mode;
    }

    public PacketIdentifier getNewestFromPacketId() {
        return this.__m_NewestFromPacketId;
    }

    public PacketIdentifier getNewestToPacketId() {
        return this.__m_NewestToPacketId;
    }

    public int getNextDestinationMessageId() {
        long c = this.getLastOutgoingMessageId();
        this.setLastOutgoingMessageId(++c);
        return Packet.makeTrint(c);
    }

    public Ack getPacketAck() {
        return this.__m_PacketAck;
    }

    public int getPort() {
        return this.__m_Port;
    }

    public int getPreferredAckSize() {
        return this.__m_PreferredAckSize;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public int getPreferredPort() {
        return this.__m_PreferredPort;
    }

    public InetSocketAddress getPreferredSocketAddress() {
        InetSocketAddress addr = this.__m_PreferredSocketAddress;
        if (addr == null) {
            int nPort = this.getPreferredPort();
            if (nPort == 0) {
                return this.getSocketAddress();
            }
            addr = new InetSocketAddress(this.getAddress(), nPort);
            this.setPreferredSocketAddress(addr);
        }
        return addr;
    }

    public int getPriority() {
        return this.__m_Priority;
    }

    public String getProcessName() {
        return this.__m_ProcessName;
    }

    public String getRackName() {
        return this.__m_RackName;
    }

    public Member$SentQueue getRecentPacketQueue() {
        return this.__m_RecentPacketQueue;
    }

    public String getRoleName() {
        return this.__m_RoleName;
    }

    public String getSiteName() {
        return this.__m_SiteName;
    }

    public InetSocketAddress getSocketAddress() {
        InetSocketAddress addr = this.__m_SocketAddress;
        if (addr == null) {
            addr = new InetSocketAddress(this.getAddress(), this.getPort());
            this.setSocketAddress(addr);
        }
        return addr;
    }

    public int getSocketCount() {
        return this.__m_SocketCount;
    }

    public int[] getStatsCount() {
        return new int[]{this.getCpuCount(), this.getSocketCount()};
    }

    public double getStatsPublisherSuccessRate() {
        long lSent = this.getStatsSent();
        long lResent = this.getStatsResent();
        return lSent == 0L ? 1.0 : 1.0 - (double)lResent / (double)lSent;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public double getStatsReceiverSuccessRate() {
        long lReceived = this.getStatsReceived();
        long lRepeated = this.getStatsRepeated();
        return lReceived == 0L ? 1.0 : 1.0 - (double)lRepeated / (double)lReceived;
    }

    public long getStatsRepeated() {
        return this.__m_StatsRepeated;
    }

    public long getStatsResent() {
        return this.__m_StatsResent;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public long getTimestamp() {
        return this.__m_Timestamp;
    }

    public int getTxDebugDropCount() {
        return this.__m_TxDebugDropCount;
    }

    public UID getUid() {
        long ldt = this.getUid32().getTimestamp();
        InetAddress addr = this.getAddress();
        int nPort = this.getPort();
        int nMachineId = this.getMachineId();
        int nAddr = (int)(InetAddressHelper.toLong(addr) & 0xFFFFFFFFL);
        int nCount = nPort & 0xFFFF | (nMachineId & 0xFFFF) << 16;
        return new UID(nAddr, ldt, nCount);
    }

    public UUID getUid32() {
        UUID uid = this.__m_Uid32;
        if (uid == null) {
            long ldt = this.getTimestamp();
            InetAddress addr = this.getAddress();
            int nPort = this.getPort();
            int nMachineId = this.getMachineId();
            Component._assert(ldt != (long)0);
            uid = new UUID(ldt, addr, nPort, nMachineId);
            this.setUid32(uid);
        }
        return uid;
    }

    public UUID getUuid() {
        return this.getUid32();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Member".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Member();
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        UUID uuid = this.getUid32();
        return uuid == null ? super.hashCode() : uuid.hashCode();
    }

    public boolean isCollocated(Member member) {
        return this.getAddress().equals(member.getAddress());
    }

    public boolean isDead() {
        return this.__m_Dead;
    }

    public boolean isDeaf() {
        return this.__m_Deaf;
    }

    public boolean isLeaving() {
        return this.__m_Leaving;
    }

    public boolean isTimedOut() {
        return this.getLastTimeoutMillis() != 0L;
    }

    public boolean isZombie() {
        return !this.isDead() ? false : this.isDeaf();
    }

    public void onInit() {
        if (this.is_Deserialized()) {
            this.configure(this.getUid32());
            int nId = this.getId();
            this.setByteOffset(Member.calcByteOffset(nId));
            this.setByteMask(Member.calcByteMask(nId));
        } else {
            WindowedArray waMsg = this.getMessageIncoming();
            waMsg.remove(waMsg.add(null));
            this.setRecentPacketQueue((Member$SentQueue)this._newChild("SentQueue"));
            if (Member$FlowControl.isEnabled()) {
                Member$FlowControl fc = (Member$FlowControl)this._newChild("FlowControl");
                this.setFlowControl(fc);
            }
        }
        this.resetStats();
        super.onInit();
    }

    public void readExternal(PofReader in) throws IOException {
        UUID uid = (UUID)in.readObject(0);
        short nId = in.readShort(1);
        this.configure(uid);
        if (nId != 0) {
            this.setId(nId);
        }
        this.setEdition(in.readInt(2));
        this.setMode(in.readInt(3));
        this.setCpuCount(in.readInt(4));
        this.setSocketCount(in.readInt(5));
        this.setClusterName(in.readString(6));
        this.setSiteName(in.readString(7));
        this.setRackName(in.readString(8));
        this.setMachineName(in.readString(9));
        this.setProcessName(in.readString(10));
        this.setMemberName(in.readString(11));
        this.setRoleName(in.readString(12));
        this.setPriority(in.readInt(13));
    }

    public void readExternal(DataInput in) throws IOException {
        UUID uid = new UUID(in);
        int nId = in.readUnsignedShort();
        this.configure(uid);
        if (nId != 0) {
            this.setId(nId);
        }
        this.setEdition(ExternalizableHelper.readInt(in));
        this.setMode(ExternalizableHelper.readInt(in));
        this.setCpuCount(ExternalizableHelper.readInt(in));
        this.setSocketCount(ExternalizableHelper.readInt(in));
        this.setClusterName(ExternalizableHelper.readUTF(in));
        this.setSiteName(ExternalizableHelper.readUTF(in));
        this.setRackName(ExternalizableHelper.readUTF(in));
        this.setMachineName(ExternalizableHelper.readUTF(in));
        this.setProcessName(ExternalizableHelper.readUTF(in));
        this.setMemberName(ExternalizableHelper.readUTF(in));
        this.setRoleName(ExternalizableHelper.readUTF(in));
        this.setPriority(ExternalizableHelper.readInt(in));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal((DataInput)in);
    }

    public void resetStats() {
        Member$FlowControl flowControl = this.getFlowControl();
        if (flowControl != null) {
            flowControl.resetStats();
        }
        this.setStatsSent(0L);
        this.setStatsResent(0L);
        this.setStatsReceived(0L);
        this.setStatsRepeated(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    protected void setAddress(InetAddress addr) {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        InetAddress addrOld = this.getAddress();
        Component._assert(addrOld == null ? true : addrOld.equals(addr));
        this.__m_Address = addr;
    }

    protected void setByteMask(int nMask) {
        this.__m_ByteMask = nMask;
    }

    protected void setByteOffset(int nOffset) {
        this.__m_ByteOffset = nOffset;
    }

    protected void setClusterName(String sName) {
        String sNameOld = this.getClusterName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_ClusterName = sName;
    }

    public void setContiguousFromPacketId(PacketIdentifier packetId) {
        this.__m_ContiguousFromPacketId = packetId;
    }

    public void setContiguousToPacketId(PacketIdentifier packetId) {
        this.__m_ContiguousToPacketId = packetId;
    }

    private void setCpuCount(int cCpus) {
        if (!(cCpus > 0) ? false : this.getCpuCount() == 0) {
            this.__m_CpuCount = cCpus;
        }
    }

    public void setDead(boolean fDead) {
        Component._assert(fDead);
        if (this.isDead() ^ true) {
            this.__m_Dead = fDead;
            this.setTimestamp(Base.getSafeTimeMillis());
        }
        this.setDeaf(false);
    }

    public void setDeaf(boolean fDeaf) {
        this.__m_Deaf = fDeaf;
    }

    private void setEdition(int n) {
        Component._assert(this.getEdition() == 0);
        this.__m_Edition = n;
    }

    protected void setFlowControl(Member$FlowControl flowControl) {
        this.__m_FlowControl = flowControl;
    }

    public void setId(int nId) {
        if (nId <= 0) {
            throw new IllegalArgumentException();
        }
        int nIdOld = this.getId();
        Component._assert(nIdOld == 0 ? true : nId == nIdOld);
        this.__m_Id = nId;
        this.setByteOffset(Member.calcByteOffset(nId));
        this.setByteMask(Member.calcByteMask(nId));
    }

    public void setLastIncomingMessageId(long cMessages) {
        this.__m_LastIncomingMessageId = cMessages;
    }

    public void setLastIncomingMillis(long cMillis) {
        this.__m_LastIncomingMillis = cMillis;
    }

    protected void setLastOutgoingMessageId(long cMessages) {
        this.__m_LastOutgoingMessageId = cMessages;
    }

    public void setLastOutgoingMillis(long cMillis) {
        this.__m_LastOutgoingMillis = cMillis;
    }

    public void setLastSlowMillis(long lMillis) {
        this.__m_LastSlowMillis = lMillis;
    }

    public void setLastTimeoutMillis(long cTimeoutMillis) {
        this.__m_LastTimeoutMillis = cTimeoutMillis;
    }

    public void setLeaving(boolean fLeaving) {
        Component._assert(fLeaving);
        this.__m_Leaving = fLeaving;
    }

    protected void setMachineId(int nId) {
        if (nId < 0 ? true : nId > 65535) {
            throw new IllegalArgumentException();
        }
        int nIdOld = this.getMachineId();
        Component._assert(nIdOld == 0 ? true : nId == nIdOld);
        this.__m_MachineId = nId;
    }

    protected void setMachineName(String sName) {
        String sNameOld = this.getMachineName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_MachineName = sName;
    }

    protected void setMemberName(String sName) {
        String sNameOld = this.getMemberName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_MemberName = sName;
    }

    public void setMessageIncoming(WindowedArray waMessage) {
        this.__m_MessageIncoming = waMessage;
    }

    public void setMessagePile(SparseArray map) {
        this.__m_MessagePile = map;
    }

    private void setMode(int n) {
        Component._assert(this.getMode() == 0);
        this.__m_Mode = n;
    }

    public void setNewestFromPacketId(PacketIdentifier packetId) {
        this.__m_NewestFromPacketId = packetId;
    }

    public void setNewestToPacketId(PacketIdentifier packetId) {
        this.__m_NewestToPacketId = packetId;
    }

    public void setPacketAck(Ack packet) {
        this.__m_PacketAck = packet;
    }

    protected void setPort(int nPort) {
        if (nPort < 0 ? true : nPort > 65535) {
            throw new IllegalArgumentException();
        }
        int nPortOld = this.getPort();
        Component._assert(nPortOld == 0 ? true : nPort == nPortOld);
        this.__m_Port = nPort;
    }

    public void setPreferredAckSize(int cPackets) {
        this.__m_PreferredAckSize = cPackets;
    }

    public void setPreferredPacketLength(int cPackets) {
        this.__m_PreferredPacketLength = cPackets;
    }

    public void setPreferredPort(int nPort) {
        if (nPort <= 0 ? true : nPort > 65535) {
            throw new IllegalArgumentException();
        }
        int nPortOld = this.getPreferredPort();
        Component._assert(nPortOld == 0 ? true : nPort == nPortOld);
        this.__m_PreferredPort = nPort;
        this.setPreferredSocketAddress(null);
    }

    protected void setPreferredSocketAddress(InetSocketAddress addr) {
        this.__m_PreferredSocketAddress = addr;
    }

    protected void setPriority(int n) {
        this.__m_Priority = Math.min(Math.max(n, 0), 10);
    }

    protected void setProcessName(String sName) {
        String sNameOld = this.getProcessName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_ProcessName = sName;
    }

    protected void setRackName(String sName) {
        String sNameOld = this.getRackName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_RackName = sName;
    }

    protected void setRecentPacketQueue(Member$SentQueue queue) {
        this.__m_RecentPacketQueue = queue;
    }

    protected void setRoleName(String sName) {
        String sNameOld = this.getRoleName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_RoleName = sName;
    }

    protected void setSiteName(String sName) {
        String sNameOld = this.getSiteName();
        Component._assert(sNameOld == null ? true : sNameOld.equals(sName));
        this.__m_SiteName = sName;
    }

    protected void setSocketAddress(InetSocketAddress addr) {
        this.__m_SocketAddress = addr;
    }

    private void setSocketCount(int cSockets) {
        if (!(cSockets > 0) ? false : this.getSocketCount() == 0) {
            this.__m_SocketCount = cSockets;
        }
    }

    public void setStatsReceived(long cReceived) {
        this.__m_StatsReceived = cReceived;
    }

    public void setStatsRepeated(long cRepeated) {
        this.__m_StatsRepeated = cRepeated;
    }

    public void setStatsResent(long cResent) {
        this.__m_StatsResent = cResent;
    }

    public void setStatsReset(long ldtReset) {
        this.__m_StatsReset = ldtReset;
    }

    public void setStatsSent(long cSent) {
        this.__m_StatsSent = cSent;
    }

    protected void setTimestamp(long cMillis) {
        if (cMillis <= (long)0) {
            throw new IllegalArgumentException();
        }
        long cMillisOld = this.getTimestamp();
        Component._assert(((this.isDead() ? true : this.isDeaf()) ? true : cMillisOld == (long)0) ? true : cMillis == cMillisOld);
        this.__m_Timestamp = cMillis;
    }

    public void setTxDebugDropCount(int cPacket) {
        this.__m_TxDebugDropCount = cPacket;
    }

    protected void setUid32(UUID uid) {
        this.__m_Uid32 = uid;
    }

    public String toString() {
        return this.toString(SHOW_STD);
    }

    public String toString(int nShow) {
        String sRole;
        StringBuffer sb = new StringBuffer();
        sb.append("Member(Id=").append(this.getId()).append(", Timestamp=").append(new Timestamp(this.getTimestamp())).append(", Address=").append(InetAddressHelper.toString(this.getAddress())).append(':').append(this.getPort()).append(", MachineId=").append(this.getMachineId());
        String sLocation = this.getLocationInfo();
        if (sLocation.length() > 0) {
            sb.append(", Location=").append(sLocation);
        }
        if (!((sRole = this.getRoleName()) != null) ? false : sRole.length() > 0) {
            sb.append(", Role=").append(sRole);
        }
        if ((nShow & SHOW_LICENSE) != 0) {
            sb.append(", ").append(this.getLicenseInfo());
        }
        if ((nShow & SHOW_STATS) != 0) {
            sb.append(", ").append(this.formatStats());
        }
        sb.append(')');
        return sb.toString();
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.getUid32());
        out.writeShort(1, (short)this.getId());
        out.writeInt(2, this.getEdition());
        out.writeInt(3, this.getMode());
        out.writeInt(4, this.getCpuCount());
        out.writeInt(5, this.getSocketCount());
        out.writeString(6, this.getClusterName());
        out.writeString(7, this.getSiteName());
        out.writeString(8, this.getRackName());
        out.writeString(9, this.getMachineName());
        out.writeString(10, this.getProcessName());
        out.writeString(11, this.getMemberName());
        out.writeString(12, this.getRoleName());
        out.writeInt(13, this.getPriority());
    }

    public void writeExternal(DataOutput out) throws IOException {
        this.getUid32().writeExternal(out);
        out.writeShort(this.getId());
        ExternalizableHelper.writeInt(out, this.getEdition());
        ExternalizableHelper.writeInt(out, this.getMode());
        ExternalizableHelper.writeInt(out, this.getCpuCount());
        ExternalizableHelper.writeInt(out, this.getSocketCount());
        ExternalizableHelper.writeUTF(out, this.getClusterName());
        ExternalizableHelper.writeUTF(out, this.getSiteName());
        ExternalizableHelper.writeUTF(out, this.getRackName());
        ExternalizableHelper.writeUTF(out, this.getMachineName());
        ExternalizableHelper.writeUTF(out, this.getProcessName());
        ExternalizableHelper.writeUTF(out, this.getMemberName());
        ExternalizableHelper.writeUTF(out, this.getRoleName());
        ExternalizableHelper.writeInt(out, this.getPriority());
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }
}

