/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.oracle.common.net.exabus.EndPoint;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.util.Base;
import com.tangosol.util.Continuation;
import com.tangosol.util.WrapperException;

public class MessageHandler$Connection
extends Util {
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 4;
    public static final int STATE_DISCONNECTING = 3;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_RELEASED = 5;
    private Continuation __m_ConnectAction;
    private Queue __m_DeferredQueue;
    private boolean __m_Deferring;
    private Throwable __m_DisconnectCause;
    private Member __m_Member;
    private EndPoint __m_Peer;
    private int __m_State;
    private Queue __m_UnconfirmedReceiptQueue;

    public MessageHandler$Connection() {
        this(null, null, true);
    }

    public MessageHandler$Connection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeferring(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(Member member, Continuation continuation) {
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            this.setMember(member);
            this.drainDeferredMessages();
            switch (this.getState()) {
                case 0: {
                    this.setConnectAction(continuation);
                    this.setState(STATE_CONNECTING);
                    break;
                }
                case 1: {
                    this.setConnectAction(continuation);
                    this.onConnected();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        ((MessageHandler)this.get_Module()).getMessageBus().connect(this.getPeer());
    }

    protected void drainDeferredMessages() {
        Queue queueDeferred = this.getDeferredQueue();
        if (queueDeferred != null) {
            Message msg;
            Queue queueIn = ((MessageHandler)this.get_Module()).getIncomingQueue();
            Member member = this.getMember();
            while (!((msg = (Message)queueDeferred.removeNoWait()) == null)) {
                msg.setFromMember(member);
                queueIn.add(msg);
            }
            queueIn.flush();
        }
    }

    protected Continuation getConnectAction() {
        return this.__m_ConnectAction;
    }

    public Queue getDeferredQueue() {
        return this.__m_DeferredQueue;
    }

    public Throwable getDisconnectCause() {
        return this.__m_DisconnectCause;
    }

    public Member getMember() {
        return this.__m_Member;
    }

    public EndPoint getPeer() {
        return this.__m_Peer;
    }

    public int getState() {
        return this.__m_State;
    }

    public Queue getUnconfirmedReceiptQueue() {
        return this.__m_UnconfirmedReceiptQueue;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/MessageHandler$Connection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MessageHandler$Connection();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isDeferring() {
        return this.__m_Deferring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        Continuation action = null;
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            switch (this.getState()) {
                case 0: {
                    Component._assert(this.getMember() == null);
                    this.setState(STATE_CONNECTING);
                    break;
                }
                case 1: {
                    Component._assert(this.getMember() != null);
                    this.setState(STATE_CONNECTED);
                    action = this.getConnectAction();
                    this.setConnectAction(null);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf("Unexpected Connect event: ") + this);
                }
            }
        }
        if (action != null) {
            action.proceed(this.getPeer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeferredMessage(Message msg) {
        Queue queue = this.getDeferredQueue();
        MessageHandler$Connection messageHandler$Connection = this;
        synchronized (messageHandler$Connection) {
            Member member = this.getMember();
            if (member == null) {
                if (queue == null) {
                    queue = new Queue();
                    this.setDeferredQueue(queue);
                }
            } else {
                this.setDeferring(false);
                this.setDeferredQueue(null);
                Component._assert(queue == null ? true : queue.isEmpty());
                queue = ((MessageHandler)this.get_Module()).getIncomingQueue();
                msg.setFromMember(member);
            }
        }
        queue.add(msg);
    }

    public void onReceipt(Object oReceipt) {
        if (this.getState() == STATE_DISCONNECTED) {
            Queue queue = this.getUnconfirmedReceiptQueue();
            if (queue == null) {
                queue = new Queue();
                this.setUnconfirmedReceiptQueue(queue);
            }
            queue.add(oReceipt);
        } else {
            ((MessageHandler)this.get_Module()).processReceipt(oReceipt);
        }
    }

    public void onReleased() {
        Queue queue;
        if (this.getState() != STATE_DISCONNECTED) {
            Component._trace(String.valueOf("Unexpected Release event: ") + this, 1);
        }
        if ((queue = this.getUnconfirmedReceiptQueue()) != null) {
            while (queue.isEmpty() ^ true) {
                ((MessageHandler)this.get_Module()).processReceipt(queue.remove());
            }
        }
        this.setState(STATE_RELEASED);
    }

    public synchronized void release() {
        if (this.getState() < STATE_DISCONNECTING) {
            this.setState(STATE_DISCONNECTING);
        }
        ((MessageHandler)this.get_Module()).getMessageBus().release(this.getPeer());
    }

    protected void setConnectAction(Continuation cont) {
        this.__m_ConnectAction = cont;
    }

    protected void setDeferredQueue(Queue queue) {
        this.__m_DeferredQueue = queue;
    }

    protected void setDeferring(boolean fDefer) {
        this.__m_Deferring = fDefer;
    }

    public void setDisconnectCause(Throwable tCause) {
        this.__m_DisconnectCause = tCause;
    }

    protected void setMember(Member member) {
        Component._assert(!(member != null) ? false : this.getMember() == null, "Not resettable");
        this.__m_Member = member;
    }

    public void setPeer(EndPoint peer) {
        Component._assert(peer != null);
        Component._assert(this.getPeer() == null ? true : this.getPeer().equals(peer), "Not resettable");
        this.__m_Peer = peer;
    }

    public synchronized void setState(int nState) {
        this.__m_State = nState;
        this.notifyAll();
    }

    public void setUnconfirmedReceiptQueue(Queue queueReceipt) {
        this.__m_UnconfirmedReceiptQueue = queueReceipt;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + " {Peer=" + this.getPeer() + ", Member= " + this.getMember() + ", State=" + this.getState() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForState(int nState, long cWaitMillis) {
        if (this.getState() >= nState) return;
        boolean bl = false;
        if (bl) {
            return;
        }
        Grid service = ((MessageHandler)this.get_Module()).getService();
        long ldtStart = System.currentTimeMillis();
        long cWait = cWaitMillis;
        while (true) {
            MessageHandler$Connection messageHandler$Connection = this;
            synchronized (messageHandler$Connection) {
                Base.wait(this, cWait);
                if (this.getState() >= nState) return;
                boolean bl2 = false;
                if (bl2) {
                    return;
                }
                if (cWaitMillis > (long)0) {
                    cWait = service.checkRequestTimeout(ldtStart, cWaitMillis);
                }
            }
        }
    }
}

