/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.NotifyPacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.packet.notifyPacket.Request;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Base;
import java.io.IOException;
import java.sql.Time;
import java.util.ArrayList;

public abstract class Packet
extends Net {
    public static final int TRINT_DOMAIN_SPAN = 0x1000000;
    public static final int TRINT_MAX_VALUE = 0xFFFFFF;
    public static final int TRINT_MAX_VARIANCE = 0x800000;
    public static final int TYPE_ACK = 232718545;
    public static final int TYPE_BROADCAST = 232718546;
    public static final int TYPE_DIAGNOSTIC = 0xDDF00D0;
    public static final int TYPE_DIRECTED_FEW = 232718547;
    public static final int TYPE_DIRECTED_MANY = 232718548;
    public static final int TYPE_DIRECTED_ONE = 232718549;
    public static final int TYPE_REQUEST = 232718550;
    public static final int TYPE_SEQUEL_FEW = 232718551;
    public static final int TYPE_SEQUEL_MANY = 232718552;
    public static final int TYPE_SEQUEL_ONE = 232718553;
    public static final int TYPE_TEST_MULTICAST = 1952805748;
    private int __m_FromId;
    private int __m_PacketType;
    private long __m_ReceivedMillis;
    private int __m_SentCount;
    private long __m_SentMillis;
    private int __m_ToId;

    public Packet(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Packet[] extract(WriteBuffer buffer, PacketBufferPool pool, Packet[] aPacket, int nMemberId) throws IOException {
        ReadBuffer bufferIn = buffer.getUnsafeReadBuffer();
        ReadBuffer.BufferInput input = bufferIn.getBufferInput();
        int cPacket = 0;
        ArrayList<Packet> listPacket = null;
        boolean fOwned = false;
        int cSlots = aPacket == null ? 0 : aPacket.length;
        try {
            boolean fAvailable = true;
            while (fAvailable) {
                input.mark(3840);
                if (Packet.isForMember(input, nMemberId)) {
                    input.reset();
                    Packet packet = Packet.instantiate(input, nMemberId);
                    if (cPacket < cSlots) {
                        aPacket[cPacket] = packet;
                    } else if (cPacket == cSlots) {
                        listPacket = new ArrayList<Packet>(cSlots << 1);
                        int i = 0;
                        while (i < cPacket) {
                            listPacket.add(aPacket[i]);
                            ++i;
                        }
                        listPacket.add(packet);
                    } else {
                        listPacket.add(packet);
                    }
                    ++cPacket;
                    boolean bl = fAvailable = input.available() > 0;
                    if (!(packet instanceof MessagePacket)) continue;
                    MessagePacket msgPacket = (MessagePacket)packet;
                    int cb = msgPacket.getBodyLength();
                    if (fAvailable) {
                        WriteBuffer buf = pool.allocate(cb);
                        buf.write(0, bufferIn, input.getOffset() - cb, cb);
                        msgPacket.defineBufferView(buf.getUnsafeReadBuffer(), 0, cb);
                        msgPacket.setWriteBuffer(buf);
                        continue;
                    }
                    msgPacket.defineBufferView(bufferIn, input.getOffset() - cb, cb);
                    msgPacket.setWriteBuffer(buffer);
                    fOwned = true;
                    continue;
                }
                input.reset();
                Packet.skip(input);
                boolean bl = fAvailable = input.available() > 0;
            }
        }
        finally {
            Object var11_12 = null;
            if (fOwned ^ true) {
                pool.release(buffer);
            }
        }
        if (aPacket.length > cPacket) {
            aPacket[cPacket] = null;
        }
        return listPacket == null ? aPacket : listPacket.toArray(new Packet[cPacket]);
    }

    public String getDescription() {
        return null;
    }

    public int getFromId() {
        return this.__m_FromId;
    }

    public int getPacketType() {
        return this.__m_PacketType;
    }

    public long getReceivedMillis() {
        return this.__m_ReceivedMillis;
    }

    public int getSentCount() {
        return this.__m_SentCount;
    }

    public long getSentMillis() {
        return this.__m_SentMillis;
    }

    public int getToId() {
        return this.__m_ToId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Packet".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public static Packet instantiate(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        Packet packet;
        int nType = input.readInt();
        switch (nType) {
            case 232718546: {
                packet = new Broadcast();
                break;
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                packet = new Directed();
                break;
            }
            case 232718551: 
            case 232718552: 
            case 232718553: {
                packet = new Sequel();
                break;
            }
            case 232718550: {
                packet = new Request();
                break;
            }
            case 232718545: {
                packet = new Ack();
                break;
            }
            case 0xDDF00D0: {
                packet = new DiagnosticPacket();
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        packet.setPacketType(nType);
        if (nType != TYPE_BROADCAST) {
            packet.setToId(nMemberId);
        }
        packet.read(input, nMemberId);
        packet.setReceivedMillis(Base.getSafeTimeMillis());
        return packet;
    }

    public boolean isAddressedTo(int nMemberId) {
        return this.getToId() == nMemberId;
    }

    public boolean isConfirmationRequired() {
        return false;
    }

    public boolean isDeferrable() {
        return !this.isConfirmationRequired() ? false : this.isOutgoingMultipoint() ^ true;
    }

    public static boolean isForCoherence(ReadBuffer.BufferInput input) throws IOException {
        if (input.available() >= 4) {
            switch (input.readInt()) {
                case 232718545: 
                case 232718546: 
                case 232718547: 
                case 232718548: 
                case 232718549: 
                case 232718550: 
                case 232718551: 
                case 232718552: 
                case 232718553: 
                case 1952805748: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isForMember(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        int nType = input.readInt();
        if (nMemberId == 0) {
            return nType == TYPE_BROADCAST;
        }
        switch (nType) {
            case 232718546: {
                return true;
            }
            case 0xDDF00D0: 
            case 232718545: 
            case 232718549: 
            case 232718550: 
            case 232718553: {
                return input.readUnsignedShort() == nMemberId;
            }
            case 232718547: 
            case 232718551: {
                int i = 0;
                int c = input.readUnsignedByte();
                while (i < c) {
                    if (input.readUnsignedShort() == nMemberId) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case 232718548: 
            case 232718552: {
                int nMask;
                int cbSkip;
                int of = Member.calcByteOffset(nMemberId);
                int c = input.readUnsignedByte();
                if (of >= c) {
                    return false;
                }
                if (of > 0 && input.skipBytes(cbSkip = of << 2) != cbSkip) {
                    throw new IOException("skip bytes failed!");
                }
                int nBits = input.readInt();
                return (nBits & (nMask = Member.calcByteMask(nMemberId))) != 0;
            }
        }
        return false;
    }

    public boolean isIncoming() {
        return this.getReceivedMillis() != 0L;
    }

    public boolean isOutgoing() {
        return this.getReceivedMillis() == 0L;
    }

    public boolean isOutgoingBroadcast() {
        return false;
    }

    public boolean isOutgoingMultipoint() {
        return false;
    }

    public static int makeTrint(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
    }

    public static int readUnsignedTrint(ReadBuffer.BufferInput input) throws IOException {
        byte[] ab = new byte[3];
        input.readFully(ab);
        return (ab[0] & 0xFF) << 16 | (ab[1] & 0xFF) << 8 | (ab[2] & 0xFF) << 0;
    }

    public void setFromId(int nId) {
        Component._assert(this.isIncoming() ^ true);
        this.__m_FromId = nId;
    }

    protected void setPacketType(int nType) {
        this.__m_PacketType = nType;
    }

    protected void setReceivedMillis(long cMillis) {
        this.__m_ReceivedMillis = cMillis;
    }

    public void setSentCount(int cSent) {
        this.__m_SentCount = cSent;
    }

    public void setSentMillis(long cMillis) {
        this.__m_SentMillis = cMillis;
    }

    public void setToId(int nId) {
        Component._assert(this.isIncoming() ^ true);
        this.__m_ToId = nId;
    }

    public static void skip(ReadBuffer.BufferInput input) throws IOException {
        int nType = input.readInt();
        switch (nType) {
            case 232718546: {
                Broadcast.skip(input, nType);
                break;
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                Directed.skip(input, nType);
                break;
            }
            case 232718551: 
            case 232718552: 
            case 232718553: {
                Sequel.skip(input, nType);
                break;
            }
            case 232718550: {
                NotifyPacket.skip(input, nType);
                break;
            }
            case 232718545: {
                Ack.skip(input, nType);
                break;
            }
            case 0xDDF00D0: {
                DiagnosticPacket.skip(input, nType);
                break;
            }
            case 1952805748: {
                input.skip(input.available());
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        long lTime;
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{PacketType=0x").append(Base.toHexString(this.getPacketType(), 8)).append(", ToId=").append(this.getToId()).append(", FromId=").append(this.getFromId()).append(", Direction=");
        if (this.isIncoming()) {
            sb.append("Incoming, ReceivedMillis=");
            lTime = this.getReceivedMillis();
        } else {
            sb.append("Outgoing, SentCount=");
            sb.append(this.getSentCount());
            sb.append(", SentMillis=");
            lTime = this.getSentMillis();
        }
        if (lTime == (long)0) {
            sb.append("none");
        } else {
            sb.append(new Time(lTime));
            sb.append('.');
            sb.append(lTime % (long)1000);
        }
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append(", ").append(sDesc);
        }
        sb.append('}');
        return sb.toString();
    }

    public static long translateTrint(int nTrint, long lCurrent) {
        long lLo = lCurrent - (long)TRINT_MAX_VARIANCE;
        long lHi = lCurrent + (long)TRINT_MAX_VARIANCE;
        nTrint &= TRINT_MAX_VALUE;
        long lBase = lCurrent >>> 24;
        int i = -1;
        while (i <= 1) {
            long lGuess = lBase + (long)i << 24 | (long)nTrint;
            if (!(lGuess >= lLo) ? false : lGuess <= lHi) {
                if (lGuess < 1L) {
                    if (lCurrent > 2048L) {
                        Component._trace(String.valueOf("Large gap while initializing packet translation; ") + "current=" + lCurrent + " packet=" + nTrint + " value=" + lGuess, 6);
                    }
                    Component._assert((lGuess += (long)TRINT_DOMAIN_SPAN) >= 1L);
                }
                return lGuess;
            }
            ++i;
        }
        throw new IllegalStateException(String.valueOf("translateTrint failed: ") + "nTrint=" + nTrint + ", lCurrent=" + lCurrent);
    }

    public void write(WriteBuffer.BufferOutput output, MemberSet setTo) throws IOException {
    }

    public static void writeTrint(WriteBuffer.BufferOutput output, int n) throws IOException {
        output.write(new byte[]{(byte)(n >>> 16), (byte)(n >>> 8), (byte)n});
    }

    public static void writeTrint(WriteBuffer.BufferOutput output, long l) throws IOException {
        Packet.writeTrint(output, (int)(l & 0xFFFFFFL));
    }
}

