/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Net;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.SocketProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.SystemSocketProvider;
import com.tangosol.util.Base;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;

public abstract class Socket
extends Net {
    public static final int STATE_CLOSED = 2;
    public static final int STATE_INITIAL = 0;
    public static final int STATE_OPEN = 1;
    private InetAddress __m_InetAddress;
    private Exception __m_LastException;
    private long __m_LastOpenMillis;
    private Object __m_Lock;
    private int __m_Port;
    private SocketProvider __m_Provider;
    private boolean __m_Reopen;
    private int __m_ReopenTimeout;
    private int __m_SoTimeout;
    private int __m_State;

    public Socket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void close() {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static String formatStateName(int nState) {
        switch (nState) {
            case 0: {
                return "STATE_INITIAL";
            }
            case 1: {
                return "STATE_OPEN";
            }
            case 2: {
                return "STATE_CLOSED";
            }
        }
        return "<unknown>";
    }

    public String getDescription() {
        return String.valueOf("address:port=") + Socket.toString(this.getInetAddress()) + ":" + this.getPort();
    }

    public InetAddress getInetAddress() {
        return this.__m_InetAddress;
    }

    public Exception getLastException() {
        return this.__m_LastException;
    }

    public long getLastOpenMillis() {
        return this.__m_LastOpenMillis;
    }

    public Object getLock() {
        Object lock = this.__m_Lock;
        return lock == null ? this : lock;
    }

    public int getPort() {
        return this.__m_Port;
    }

    public SocketProvider getProvider() {
        return this.__m_Provider;
    }

    public int getReopenTimeout() {
        return this.__m_ReopenTimeout;
    }

    public int getSoTimeout() {
        return this.__m_SoTimeout;
    }

    public int getState() {
        return this.__m_State;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/Socket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isReopen() {
        return this.__m_Reopen;
    }

    protected void onException(IOException eException, long lSocketActionMillis) {
        if (!(lSocketActionMillis < this.getLastOpenMillis()) && this.refresh(eException) ^ true) {
            throw Base.ensureRuntimeException(eException);
        }
    }

    public void onInit() {
        this.setProvider(SocketProviderFactory.DEFAULT_PROVIDER);
        super.onInit();
    }

    protected void onInterruptedIOException(InterruptedIOException eException, long lSocketActionMillis) {
        this.onException(eException, lSocketActionMillis);
    }

    public void open() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean refresh(Exception eReason) {
        Object object = this.getLock();
        synchronized (object) {
            this.close();
            this.setLastException(eReason);
            if (!this.isReopen()) return false;
            long lTimeout = Base.getSafeTimeMillis() + (long)this.getReopenTimeout();
            while (true) {
                try {
                    this.open();
                    this.setLastException(null);
                    return true;
                }
                catch (Exception e) {
                    Thread.yield();
                    if (Base.getSafeTimeMillis() >= lTimeout) {
                        return false;
                    }
                    boolean bl = true;
                    if (bl) continue;
                }
                break;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInetAddress(InetAddress addr) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == STATE_INITIAL, "InetAddress cannot be modified once the socket has been opened");
            this.__m_InetAddress = addr;
        }
    }

    protected void setLastException(Exception e) {
        this.__m_LastException = e;
    }

    protected void setLastOpenMillis(long lMillis) {
        this.__m_LastOpenMillis = lMillis;
    }

    public void setLock(Object oLock) {
        Component._assert(this.getState() == STATE_INITIAL, "Lock cannot be modified once the socket has been opened");
        this.__m_Lock = oLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int nPort) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == STATE_INITIAL, "Port cannot be modified once the socket has been opened");
            this.__m_Port = nPort;
        }
    }

    public void setProvider(SocketProvider provider) {
        if (provider == null) {
            provider = SystemSocketProvider.INSTANCE;
        }
        this.__m_Provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReopen(boolean fReopen) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == STATE_INITIAL, "Reopen cannot be modified once the socket has been opened");
            this.__m_Reopen = fReopen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReopenTimeout(int cMillis) {
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() == STATE_INITIAL, "ReopenTimeout cannot be modified once the socket has been opened");
            this.__m_ReopenTimeout = cMillis;
        }
    }

    public void setSoTimeout(int cMillis) {
        this.__m_SoTimeout = cMillis;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.get_Name());
        sb.append("{State=").append(Socket.formatStateName(this.getState())).append(", ").append(this.getDescription()).append('}');
        return sb.toString();
    }

    public static String toString(InetAddress addr) {
        return InetAddressHelper.toString(addr);
    }

    protected void validateBufferSize(String sBufferName, int cbActualSize, int cbRequestedSize, int cbMinimumSize) {
        if (cbActualSize < cbRequestedSize) {
            String sMsg = String.valueOf(this.get_Name()) + " failed to set " + sBufferName + " buffer size to " + cbRequestedSize + " bytes; actual size is " + cbActualSize + " bytes. " + "Consult your OS documentation regarding increasing the maximum socket buffer size.";
            if (cbActualSize < cbMinimumSize) {
                Component._trace(sMsg, 1);
                throw new RuntimeException(sMsg);
            }
            sMsg = String.valueOf(sMsg) + " Proceeding with the actual value may cause sub-optimal performance.";
            Component._trace(sMsg, 2);
        }
    }

    protected void validateSoTimeout(int cActual, int cRequired) {
        if (cActual != cRequired) {
            throw new RuntimeException(String.valueOf("Failed to set SoTimeout to ") + cRequired + "; actual value is " + cActual);
        }
    }
}

