/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.extend;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Extend;
import com.tangosol.coherence.component.net.extend.Channel$MessageAction;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.message.Request$Status;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$NotifyChannelClosed;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.net.messaging.Response;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryWriteBuffer;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Gate;
import com.tangosol.util.ListMap;
import com.tangosol.util.LongArray;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import com.tangosol.util.ThreadGate;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;

public class Channel
extends Extend
implements PofContext,
PofSerializer,
com.tangosol.net.messaging.Channel {
    private Map __m_AttributeMap;
    private volatile boolean __m_CloseNotify;
    private volatile boolean __m_CloseOnExit;
    private volatile Throwable __m_CloseThrowable;
    private volatile transient com.tangosol.net.messaging.Connection __m_Connection;
    private int __m_Id;
    private Protocol.MessageFactory __m_MessageFactory;
    private volatile boolean __m_Open;
    private Channel.Receiver __m_Receiver;
    private LongArray __m_RequestArray;
    private transient long __m_RequestId;
    private boolean __m_SecureContext;
    private Serializer __m_Serializer;
    private Subject __m_Subject;
    private transient Gate __m_ThreadGate;
    private static ListMap __mapChildren;

    static {
        Channel.__initStatic();
    }

    public Channel() {
        this(null, null, true);
    }

    public Channel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setAttributeMap(new SafeHashMap());
            this.setRequestArray(new SparseArray());
            this.setThreadGate(new ThreadGate());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("MessageAction", Channel$MessageAction.get_CLASS());
    }

    protected void assertOpen() {
        if (this.isOpen() ^ true) {
            throw new ConnectionException("channel is closed", this.getConnection());
        }
    }

    protected long calculateRequestTimeout(Request request) {
        Peer manager = this.getConnectionManager();
        long cMillis = 0L;
        if (manager != null) {
            cMillis = manager.getRequestTimeout();
            if (request instanceof PriorityTask) {
                cMillis = Service.adjustTimeout(cMillis, ((PriorityTask)((Object)request)).getRequestTimeoutMillis());
            }
        }
        return cMillis;
    }

    public void close() {
        this.close(true, null);
    }

    public void close(boolean fNotify, Throwable e) {
        if (this.isOpen()) {
            if (this.getId() == 0) {
                throw new UnsupportedOperationException("cannot closed reserved channel: 0");
            }
            Peer manager = this.getConnectionManager();
            if (Thread.currentThread() == manager.getThread()) {
                this.closeInternal(fNotify, e, 0L);
            } else {
                Component._assert(this.isActiveThread() ^ true, "cannot close a channel while executing within the channel");
                manager.closeChannel(this, fNotify, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean closeInternal(boolean fNotify, Throwable e, long cMillis) {
        LongArray laStatus;
        if (this.isOpen() ^ true) {
            return false;
        }
        LongArray longArray = laStatus = this.getRequestArray();
        // MONITORENTER : longArray
        Throwable eStatus = e == null ? new ConnectionException("channel closed", this.getConnection()) : e;
        LongArray.Iterator iter = laStatus.iterator();
        while (iter.hasNext()) {
            Request.Status status = (Request.Status)iter.next();
            iter.remove();
            status.cancel(eStatus);
        }
        boolean fClose = this.gateClose(cMillis);
        try {
            block16: {
                block17: {
                    if (fClose ^ true) {
                        this.setCloseOnExit(true);
                        this.setCloseNotify(fNotify);
                        this.setCloseThrowable(e);
                        fClose = this.gateClose(0L);
                    }
                    if (!(!fClose ? false : this.isOpen())) break block17;
                    Channel.Receiver receiver = this.getReceiver();
                    if (receiver != null) {
                        try {
                            receiver.unregisterChannel(this);
                            break block16;
                        }
                        catch (Throwable ee) {
                            Component._trace(ee, String.valueOf("Error unregistering channel from receiver: ") + receiver);
                        }
                    }
                    break block16;
                }
                boolean receiver = false;
                Object var10_15 = null;
                if (fClose) {
                    this.gateOpen();
                }
                var10_15 = null;
                // MONITOREXIT : longArray
                return receiver;
            }
            this.setOpen(false);
            Object var10_16 = null;
            if (fClose) {
                this.gateOpen();
            }
        }
        catch (Throwable receiver) {
            Object var10_17 = null;
            if (!fClose) throw receiver;
            this.gateOpen();
            throw receiver;
        }
        if (!(!fNotify ? false : this.isOpen() ^ true) ? false : this.getId() != 0) {
            try {
                Connection connection = (Connection)this.getConnection();
                com.tangosol.net.messaging.Channel channel0 = connection.getChannel(0);
                Protocol.MessageFactory factory0 = channel0.getMessageFactory();
                Peer$MessageFactory$NotifyChannelClosed message = (Peer$MessageFactory$NotifyChannelClosed)factory0.createMessage(Peer$MessageFactory$NotifyChannelClosed.TYPE_ID);
                message.setCause(e);
                message.setChannelId(this.getId());
                channel0.send(message);
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
        ((Connection)this.getConnection()).unregisterChannel(this);
        this.getConnectionManager().onChannelClosed(this);
        return true;
    }

    public Message createMessage(int nType) {
        return this.getMessageFactory().createMessage(nType);
    }

    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        PofBufferReader reader = new PofBufferReader(in, this);
        return reader.readObject(-1);
    }

    public Object deserialize(PofReader in) throws IOException {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofSerializer) {
            return ((PofSerializer)((Object)serializer)).deserialize(in);
        }
        Binary bin = in.readBinary(0);
        in.readRemainder();
        return serializer.deserialize(bin.getBufferInput());
    }

    protected void execute(Message message) {
        Channel.Receiver receiver = message instanceof Response ? null : this.getReceiver();
        if (this.isSecureContext()) {
            Channel$MessageAction action = new Channel$MessageAction();
            action.setMessage(message);
            action.setReceiver(receiver);
            Subject.doAs(this.getSubject(), action);
        } else if (receiver == null) {
            message.run();
        } else {
            receiver.onMessage(message);
        }
    }

    protected boolean gateClose(long cMillis) {
        return this.getThreadGate().close(cMillis);
    }

    public void gateEnter() {
        block6: {
            Connection connection = (Connection)this.getConnection();
            connection.gateEnter();
            try {
                Gate gate = this.getThreadGate();
                if (!this.isCloseOnExit() ? false : gate.isEnteredByCurrentThread() ^ true) {
                    throw new ConnectionException("channel is closing", (com.tangosol.net.messaging.Connection)connection);
                }
                if (gate.enter(0L)) {
                    try {
                        this.assertOpen();
                        break block6;
                    }
                    catch (Throwable ee) {
                        gate.exit();
                        throw Extend.ensureRuntimeException(ee);
                    }
                }
                throw new ConnectionException("connection is closing", (com.tangosol.net.messaging.Connection)connection);
            }
            catch (Throwable e) {
                connection.gateExit();
                throw Extend.ensureRuntimeException(e);
            }
        }
    }

    public void gateExit() {
        Gate gate = this.getThreadGate();
        gate.exit();
        ((Connection)this.getConnection()).gateExit();
        if (!this.isCloseOnExit() ? false : gate.isEnteredByCurrentThread() ^ true) {
            boolean fClose;
            block5: {
                fClose = this.gateClose(0L);
                try {
                    if (!(!fClose ? false : this.isOpen())) break block5;
                    this.gateOpen();
                    fClose = false;
                    this.close(this.isCloseNotify(), this.getCloseThrowable());
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (fClose) {
                        this.gateOpen();
                    }
                    throw throwable;
                }
            }
            Object var4_3 = null;
            if (fClose) {
                this.gateOpen();
            }
        }
    }

    protected void gateOpen() {
        this.getThreadGate().open();
    }

    protected long generateRequestId() {
        long lId = this.getRequestId();
        this.setRequestId(lId + (long)1);
        return lId;
    }

    public Object getAttribute(String sName) {
        return this.getAttributeMap().get(sName);
    }

    public Map getAttributeMap() {
        return this.__m_AttributeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getAttributes() {
        Map map;
        Map map2 = map = this.getAttributeMap();
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            return hashMap;
        }
    }

    public Class getClass(int nTypeId) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getClass(nTypeId);
        }
        throw new IllegalStateException(String.valueOf("cannot determine class for user type ID: ") + nTypeId);
    }

    public String getClassName(int nTypeId) {
        return this.getClass(nTypeId).getName();
    }

    public Throwable getCloseThrowable() {
        return this.__m_CloseThrowable;
    }

    public com.tangosol.net.messaging.Connection getConnection() {
        return this.__m_Connection;
    }

    public Peer getConnectionManager() {
        com.tangosol.net.messaging.Connection connection = this.getConnection();
        return connection == null ? null : (Peer)connection.getConnectionManager();
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getId());
        boolean fOpen = this.isOpen();
        sb.append(", Open=").append(fOpen);
        if (fOpen) {
            com.tangosol.net.messaging.Connection connection = this.getConnection();
            sb.append(", Connection=").append(connection == null ? "null" : String.valueOf(connection.getId()));
        }
        return sb.toString();
    }

    public int getId() {
        return this.__m_Id;
    }

    public Protocol.MessageFactory getMessageFactory() {
        return this.__m_MessageFactory;
    }

    public PofSerializer getPofSerializer(int nTypeId) {
        String sTarget;
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getPofSerializer(nTypeId);
        }
        if (nTypeId == 0) {
            return this;
        }
        try {
            sTarget = this.getConnectionManager().toString();
        }
        catch (RuntimeException e) {
            sTarget = this.toString();
        }
        throw new IllegalStateException(String.valueOf(sTarget) + " has not been configured with a PofContext; " + " this channel cannot decode POF-encoded user types");
    }

    public Channel.Receiver getReceiver() {
        return this.__m_Receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Request getRequest(long lId) {
        LongArray laStatus;
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            Request.Status status = (Request.Status)laStatus.get(lId);
            Request request = status == null ? null : status.getRequest();
            return request;
        }
    }

    public LongArray getRequestArray() {
        return this.__m_RequestArray;
    }

    protected long getRequestId() {
        return this.__m_RequestId;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public Subject getSubject() {
        return this.__m_Subject;
    }

    protected Gate getThreadGate() {
        return this.__m_ThreadGate;
    }

    public int getUserTypeIdentifier(Class clz) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(clz);
        }
        Component._assert(clz != null);
        return 0;
    }

    public int getUserTypeIdentifier(Object o) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(o);
        }
        Component._assert(o != null);
        return 0;
    }

    public int getUserTypeIdentifier(String sClass) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).getUserTypeIdentifier(sClass);
        }
        Component._assert(sClass != null);
        return 0;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/extend/Channel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Channel();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isActiveThread() {
        return this.getThreadGate().isEnteredByCurrentThread();
    }

    public boolean isCloseNotify() {
        return this.__m_CloseNotify;
    }

    public boolean isCloseOnExit() {
        return this.__m_CloseOnExit;
    }

    public boolean isOpen() {
        return this.__m_Open;
    }

    public boolean isSecureContext() {
        return this.__m_SecureContext;
    }

    public boolean isUserType(Class clz) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(clz);
        }
        Component._assert(clz != null);
        return false;
    }

    public boolean isUserType(Object o) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(o);
        }
        Component._assert(o != null);
        return false;
    }

    public boolean isUserType(String sClass) {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofContext) {
            return ((PofContext)serializer).isUserType(sClass);
        }
        Component._assert(sClass != null);
        return false;
    }

    public void onInit() {
        this.setSecureContext(SecurityHelper.getCurrentSubject() != null);
        super.onInit();
    }

    public void onRequestCompleted(Request.Status status) {
        this.unregisterRequest(status);
    }

    public void open() {
        this.openInternal();
    }

    public void openInternal() {
        if (this.isOpen()) {
            return;
        }
        Component._assert(this.getConnection() != null);
        Component._assert(this.getMessageFactory() != null);
        Component._assert(this.getSerializer() != null);
        this.setOpen(true);
        Channel.Receiver receiver = this.getReceiver();
        if (receiver != null) {
            try {
                receiver.registerChannel(this);
            }
            catch (Throwable e) {
                Component._trace(e, String.valueOf("Error registering channel with receiver: ") + receiver);
            }
        }
        this.getConnectionManager().onChannelOpened(this);
    }

    protected void post(Message message) {
        boolean fEnter;
        if (message instanceof Response) {
            Component._assert(this.isActiveThread(), "can only send a response while executing within a channel");
            fEnter = false;
        } else {
            fEnter = true;
        }
        if (fEnter) {
            this.gateEnter();
        }
        try {
            try {
                message.setChannel(this);
                this.getConnectionManager().post(message);
            }
            catch (Throwable e) {
                Request.Status status;
                if (message instanceof Request && (status = ((Request)message).getStatus()) != null) {
                    status.cancel(e);
                }
                throw Base.ensureRuntimeException(e);
            }
            Object var4_6 = null;
            if (fEnter) {
                this.gateExit();
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (fEnter) {
                this.gateExit();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Message message) {
        Component._assert(message != null);
        try {
            this.gateEnter();
        }
        catch (ConnectionException e) {
            return;
        }
        try {
            block24: {
                try {
                    if (message instanceof Request) {
                        Request request = (Request)message;
                        try {
                            this.execute(message);
                        }
                        catch (RuntimeException e) {
                            Response response = request.ensureResponse();
                            Component._assert(response != null);
                            if (request.getStatus() == null && Component._isTraceEnabled(5)) {
                                Component._trace(String.valueOf("An exception occurred while processing a ") + ClassHelper.getSimpleName(message.getClass()) + " for Service=" + this.getConnectionManager().getServiceName() + ": " + Component.getStackTrace(e), 5);
                            }
                            response.setFailure(true);
                            response.setResult(e);
                        }
                        Response response = request.ensureResponse();
                        Component._assert(response != null);
                        response.setRequestId(request.getId());
                        this.send(response);
                        break block24;
                    }
                    if (message instanceof Response) {
                        Request$Status status;
                        Response response = (Response)message;
                        LongArray laStatus = this.getRequestArray();
                        long lId = response.getRequestId();
                        LongArray longArray = laStatus;
                        synchronized (longArray) {
                            status = (Request$Status)laStatus.get(lId);
                        }
                        if (status == null) break block24;
                        try {
                            this.execute(response);
                            if (response.isFailure()) {
                                Object oResult = response.getResult();
                                if (oResult instanceof Throwable) {
                                    status.cancel((Throwable)oResult);
                                } else {
                                    status.cancel(new RuntimeException(String.valueOf(oResult)));
                                }
                            } else {
                                status.setResponse(response);
                            }
                            break block24;
                        }
                        catch (Throwable e) {
                            status.cancel(e);
                            if (e instanceof Error) {
                                throw (Error)e;
                            }
                            break block24;
                        }
                    }
                    this.execute(message);
                }
                catch (Throwable e) {
                    Connection connection = (Connection)this.getConnection();
                    if (connection.isCloseOnExit() ^ true ? true : Thread.currentThread().isInterrupted() ^ true) {
                        Component._trace(e, String.valueOf("Caught an unhandled exception while processing a ") + ClassHelper.getSimpleName(message.getClass()) + " for Service=" + this.getConnectionManager().getServiceName());
                    }
                    if (this.getId() == 0) {
                        connection.setCloseOnExit(true);
                        connection.setCloseNotify(true);
                        connection.setCloseThrowable(e);
                    } else {
                        this.setCloseOnExit(true);
                        this.setCloseNotify(true);
                        this.setCloseThrowable(e);
                    }
                    if (!(e instanceof Error)) break block24;
                    throw (Error)e;
                }
            }
            Object var3_8 = null;
            this.gateExit();
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.gateExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Request.Status registerRequest(Request request) {
        LongArray laStatus;
        Component._assert(request != null);
        Request$Status status = new Request$Status();
        status.setChannel(this);
        status.setDefaultTimeoutMillis(this.calculateRequestTimeout(request));
        status.setRequest(request);
        request.setStatus(status);
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            this.assertOpen();
            long lId = this.generateRequestId();
            request.setId(lId);
            Object oStatus = laStatus.set(lId, status);
            if (oStatus != null) {
                laStatus.set(lId, oStatus);
                Component._assert(false, String.valueOf("duplicate request: ") + request);
            }
        }
        return status;
    }

    public Object removeAttribute(String sName) {
        return this.getAttributeMap().remove(sName);
    }

    public Object request(Request request) {
        return this.request(request, -1L);
    }

    public Object request(Request request, long cMillis) {
        Peer manager = this.getConnectionManager();
        Component._assert(manager.getThread() != Thread.currentThread(), "request() is a blocking call and cannot be called on the service thread");
        manager.waitAcceptingClients();
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Request.Status status = this.registerRequest(request);
        this.post(request);
        Response response = status.waitForResponse(cMillis);
        if (response.isFailure()) {
            Object oResult = response.getResult();
            if (oResult instanceof Throwable) {
                throw Extend.ensureRuntimeException((Throwable)oResult);
            }
            throw new RuntimeException(String.valueOf("received error: ") + oResult);
        }
        return response.getResult();
    }

    public void send(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.post(message);
    }

    public Request.Status send(Request request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Request.Status status = this.registerRequest(request);
        this.post(request);
        return status;
    }

    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        PofBufferWriter writer = new PofBufferWriter(out, (PofContext)this);
        writer.writeObject(-1, o);
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        Serializer serializer = this.getSerializer();
        if (serializer instanceof PofSerializer) {
            ((PofSerializer)((Object)serializer)).serialize(out, o);
        } else {
            BinaryWriteBuffer buf = new BinaryWriteBuffer(32);
            serializer.serialize(buf.getBufferOutput(), o);
            out.writeBinary(0, buf.toBinary());
            out.writeRemainder(null);
        }
    }

    public Object setAttribute(String sName, Object oValue) {
        return this.getAttributeMap().put(sName, oValue);
    }

    protected void setAttributeMap(Map map) {
        this.__m_AttributeMap = map;
    }

    public void setCloseNotify(boolean f) {
        this.__m_CloseNotify = f;
    }

    public void setCloseOnExit(boolean fClose) {
        this.__m_CloseOnExit = fClose;
    }

    public void setCloseThrowable(Throwable e) {
        this.__m_CloseThrowable = e;
    }

    public void setConnection(com.tangosol.net.messaging.Connection connection) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Connection = connection;
    }

    public void setId(int nId) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Id = nId;
    }

    public void setMessageFactory(Protocol.MessageFactory factory) {
        Component._assert(this.isOpen() ^ true);
        this.__m_MessageFactory = factory;
    }

    protected void setOpen(boolean fOpen) {
        this.__m_Open = fOpen;
    }

    public void setReceiver(Channel.Receiver receiver) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Receiver = receiver;
    }

    protected void setRequestArray(LongArray la) {
        this.__m_RequestArray = la;
    }

    protected void setRequestId(long lId) {
        this.__m_RequestId = lId;
    }

    protected void setSecureContext(boolean fSecure) {
        this.__m_SecureContext = fSecure;
    }

    public void setSerializer(Serializer serializer) {
        Component._assert(this.isOpen() ^ true);
        this.__m_Serializer = serializer;
    }

    public void setSubject(Subject subject) {
        this.setSecureContext(this.isSecureContext() ? true : subject != null);
        this.__m_Subject = subject;
    }

    protected void setThreadGate(Gate gate) {
        this.__m_ThreadGate = gate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterRequest(Request.Status status) {
        LongArray laStatus;
        Component._assert(status != null);
        LongArray longArray = laStatus = this.getRequestArray();
        synchronized (longArray) {
            laStatus.remove(status.getRequest().getId());
        }
    }
}

