/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.management.model.localModel;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.management.model.LocalModel;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$BufferPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.io.MultiBufferWriteBuffer;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConnectionManagerModel
extends LocalModel {
    private transient String __m_HostIP;
    private transient Date __m__CreateTime;
    private TcpAcceptor __m__TcpAcceptor;

    public ConnectionManagerModel() {
        this(null, null, true);
    }

    public ConnectionManagerModel(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_SnapshotMap(new HashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getConnectionCount() {
        Set setConn = this.get_TcpAcceptor().getConnectionSet();
        return setConn == null ? 0 : setConn.size();
    }

    public String getHostIP() {
        InetSocketAddress address;
        String sAddr = this.__m_HostIP;
        if (sAddr == null && (address = this.get_TcpAcceptor().getLocalAddress()) != null) {
            sAddr = String.valueOf(address.getHostName()) + ":" + address.getPort();
            this.setHostIP(sAddr);
        }
        return sAddr;
    }

    public long getIncomingBufferPoolCapacity() {
        TcpAcceptor$BufferPool pool = this.get_TcpAcceptor().getBufferPoolIn();
        return pool == null ? 0L : (long)pool.getMaximumCapacity();
    }

    public long getIncomingBufferPoolSize() {
        TcpAcceptor$BufferPool pool = this.get_TcpAcceptor().getBufferPoolIn();
        return pool == null ? 0L : (long)(pool.getSize() * pool.getBufferSize());
    }

    public long getOutgoingBufferPoolCapacity() {
        TcpAcceptor$BufferPool pool = this.get_TcpAcceptor().getBufferPoolOut();
        return pool == null ? 0 : pool.getMaximumCapacity();
    }

    public long getOutgoingBufferPoolSize() {
        TcpAcceptor$BufferPool pool = this.get_TcpAcceptor().getBufferPoolOut();
        return pool == null ? 0L : (long)(pool.getSize() * pool.getBufferSize());
    }

    public long getOutgoingByteBacklog() {
        long cBacklog = 0L;
        Set setConn = this.get_TcpAcceptor().getConnectionSet();
        if (setConn != null) {
            Iterator iterConn = setConn.iterator();
            while (iterConn.hasNext()) {
                TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iterConn.next();
                if (!(conn != null)) continue;
                Queue q = conn.getOutgoingQueue();
                Iterator iterBuff = q.iterator();
                while (iterBuff.hasNext()) {
                    MultiBufferWriteBuffer buff = (MultiBufferWriteBuffer)iterBuff.next();
                    cBacklog += (long)buff.length();
                }
            }
        }
        return cBacklog;
    }

    public long getOutgoingMessageBacklog() {
        Set setConn = this.get_TcpAcceptor().getConnectionSet();
        if (setConn != null) {
            long cBacklog = 0L;
            Iterator iter = setConn.iterator();
            while (iter.hasNext()) {
                TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iter.next();
                if (!(conn != null)) continue;
                cBacklog += (long)conn.getOutgoingQueue().size();
            }
            return cBacklog;
        }
        return 0L;
    }

    public long getTotalBytesReceived() {
        return this.get_TcpAcceptor().getStatsBytesReceived();
    }

    public long getTotalBytesSent() {
        return this.get_TcpAcceptor().getStatsBytesSent();
    }

    public long getTotalMessagesReceived() {
        return this.get_TcpAcceptor().getStatsReceived();
    }

    public long getTotalMessagesSent() {
        return this.get_TcpAcceptor().getStatsSent();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/management/model/localModel/ConnectionManagerModel".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public Date get_CreateTime() {
        return this.__m__CreateTime;
    }

    public static Component get_Instance() {
        return new ConnectionManagerModel();
    }

    private final Component get_Module() {
        return this;
    }

    public TcpAcceptor get_TcpAcceptor() {
        return this.__m__TcpAcceptor;
    }

    public void readExternal(DataInput in) throws IOException {
        super.readExternal(in);
        Map mapSnapshot = this.get_SnapshotMap();
        mapSnapshot.put("ConnectionCount", Base.makeInteger(ExternalizableHelper.readInt(in)));
        mapSnapshot.put("HostIP", ExternalizableHelper.readUTF(in));
        mapSnapshot.put("IncomingBufferPoolCapacity", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("IncomingBufferPoolSize", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OutgoingBufferPoolCapacity", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OutgoingBufferPoolSize", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OutgoingByteBacklog", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("OutgoingMessageBacklog", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalBytesReceived", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalBytesSent", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalMessagesReceived", Base.makeLong(ExternalizableHelper.readLong(in)));
        mapSnapshot.put("TotalMessagesSent", Base.makeLong(ExternalizableHelper.readLong(in)));
    }

    public void resetStatistics() {
        this.get_TcpAcceptor().resetStats();
    }

    protected void setHostIP(String sAddress) {
        this.__m_HostIP = sAddress;
    }

    public void set_CreateTime(Date p_CreateTime) {
        this.__m__CreateTime = p_CreateTime;
    }

    public void set_TcpAcceptor(TcpAcceptor acceptor) {
        this.__m__TcpAcceptor = acceptor;
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        Map mapSnapshot = this.get_SnapshotMap();
        ExternalizableHelper.writeInt(out, this.getConnectionCount());
        ExternalizableHelper.writeUTF(out, this.getHostIP());
        ExternalizableHelper.writeLong(out, this.getIncomingBufferPoolCapacity());
        ExternalizableHelper.writeLong(out, this.getIncomingBufferPoolSize());
        ExternalizableHelper.writeLong(out, this.getOutgoingBufferPoolCapacity());
        ExternalizableHelper.writeLong(out, this.getOutgoingBufferPoolSize());
        ExternalizableHelper.writeLong(out, this.getOutgoingByteBacklog());
        ExternalizableHelper.writeLong(out, this.getOutgoingMessageBacklog());
        ExternalizableHelper.writeLong(out, this.getTotalBytesReceived());
        ExternalizableHelper.writeLong(out, this.getTotalBytesSent());
        ExternalizableHelper.writeLong(out, this.getTotalMessagesReceived());
        ExternalizableHelper.writeLong(out, this.getTotalMessagesSent());
    }
}

