/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import java.io.IOException;

public abstract class NotifyPacket
extends Packet {
    private int[] __m_MessageId;
    private int[] __m_MessagePartIndex;
    private volatile int __m_NotifyCount;
    private volatile long __m_ScheduledMillis;

    public NotifyPacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addPacket(int nMsgId, int nMsgPart) {
        Component._assert(this.isOutgoing());
        int c = this.getNotifyCount();
        this.setMessageId(c, nMsgId);
        this.setMessagePartIndex(c, nMsgPart);
        this.setNotifyCount(c + 1);
    }

    public void addPacket(MessagePacket packet) {
        this.addPacket(Packet.makeTrint(packet.getFromMessageId()), packet.getMessagePartIndex());
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        int c = this.getNotifyCount();
        sb.append("NotifyCount=").append(c);
        if (c > 0) {
            sb.append(", MessageId:MessagePartIndex=[");
            int i = 0;
            while (i < c) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getMessageId(i)).append(':').append(this.getMessagePartIndex(i));
                ++i;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected int[] getMessageId() {
        return this.__m_MessageId;
    }

    public int getMessageId(int i) {
        return this.getMessageId()[i];
    }

    protected int[] getMessagePartIndex() {
        return this.__m_MessagePartIndex;
    }

    public int getMessagePartIndex(int i) {
        return this.getMessagePartIndex()[i];
    }

    public int getNotifyCount() {
        return this.__m_NotifyCount;
    }

    public long getScheduledMillis() {
        return this.__m_ScheduledMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/NotifyPacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    private final Component get_Module() {
        return this;
    }

    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        this.setToId(input.readUnsignedShort());
        this.setFromId(input.readUnsignedShort());
        this.readBody(input);
    }

    public void readBody(ReadBuffer.BufferInput input) throws IOException {
        int c = input.readUnsignedShort();
        this.setNotifyCount(c);
        this.setMessageId(new int[c]);
        this.setMessagePartIndex(new int[c]);
        int i = 0;
        while (i < c) {
            this.setMessageId(i, Packet.readUnsignedTrint(input));
            this.setMessagePartIndex(i, Packet.readUnsignedTrint(input));
            ++i;
        }
    }

    protected void setMessageId(int i, int nMsgId) {
        int[] an = this.getMessageId();
        if (an == null ? true : i >= an.length) {
            int cNew = Math.max(i + (i >>> 1), 16);
            int[] anNew = new int[cNew];
            if (an != null) {
                System.arraycopy(an, 0, anNew, 0, an.length);
            }
            an = anNew;
            this.setMessageId(anNew);
        }
        an[i] = nMsgId;
    }

    protected void setMessageId(int[] anMsgId) {
        this.__m_MessageId = anMsgId;
    }

    protected void setMessagePartIndex(int i, int nMsgPart) {
        int[] an = this.getMessagePartIndex();
        if (an == null ? true : i >= an.length) {
            int cNew = Math.max(i + (i >>> 1), 16);
            int[] anNew = new int[cNew];
            if (an != null) {
                System.arraycopy(an, 0, anNew, 0, an.length);
            }
            an = anNew;
            this.setMessagePartIndex(anNew);
        }
        an[i] = nMsgPart;
    }

    protected void setMessagePartIndex(int[] anMsgPart) {
        this.__m_MessagePartIndex = anMsgPart;
    }

    protected void setNotifyCount(int c) {
        this.__m_NotifyCount = c;
    }

    public void setScheduledMillis(long cMillis) {
        this.__m_ScheduledMillis = cMillis;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        input.readUnsignedShort();
        input.readUnsignedShort();
        NotifyPacket.skipBody(input);
    }

    public static void skipBody(ReadBuffer.BufferInput input) throws IOException {
        int cbSkip = input.readUnsignedShort() * 6;
        long cbSkipped = input.skip(cbSkip);
        Component._assert(cbSkipped == (long)cbSkip);
    }

    public void write(WriteBuffer.BufferOutput output, MemberSet setTo) throws IOException {
        output.writeInt(this.getPacketType());
        output.writeShort(this.getToId());
        output.writeShort(this.getFromId());
        this.writeBody(output);
    }

    public void writeBody(WriteBuffer.BufferOutput output) throws IOException {
        int c = this.getNotifyCount();
        int[] anMsgId = this.getMessageId();
        int[] anMsgPart = this.getMessagePartIndex();
        output.writeShort(c);
        int i = 0;
        while (i < c) {
            Packet.writeTrint(output, anMsgId[i]);
            Packet.writeTrint(output, anMsgPart[i]);
            ++i;
        }
    }
}

