/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.packet.messagePacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.sql.Time;
import java.util.Iterator;

public class Directed
extends MessagePacket {
    private int __m_ToMessageId;

    public Directed() {
        this(null, null, true);
    }

    public Directed(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDeliveryState(0);
            this.setPacketType(232718548);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static int calcHeaderLength(MemberSet setMember) {
        int cMembers = setMember == null ? 1 : setMember.size();
        if (cMembers == 1) {
            return 23;
        }
        int cbFew = 19 + 5 * cMembers;
        int cbMany = 21 + 3 * cMembers + 4 * ((setMember.getLastId() + 31) / 32);
        return (!(cbFew < cbMany) ? false : cMembers <= 255) ? cbFew : cbMany;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("ToMemberSet=");
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember == null) {
            sb.append("null");
        } else {
            sb.append('[');
            boolean fFirst = true;
            Iterator iter = setMember.iterator();
            while (iter.hasNext()) {
                if (fFirst) {
                    fFirst = false;
                } else {
                    sb.append(", ");
                }
                Member member = (Member)iter.next();
                int nMember = member.getId();
                sb.append(nMember);
                int nToMsgId = setMember.getDestinationMessageId(nMember);
                if (!(nToMsgId != 0)) continue;
                sb.append('(').append(nToMsgId).append(')');
            }
            sb.append(']');
        }
        long ldtResend = this.getResendScheduled();
        long ldtTimeout = this.getResendTimeout();
        String sResend = ldtResend <= (long)0 ? "none" : String.valueOf(new Time(ldtResend).toString()) + "." + ldtResend % (long)1000;
        String sTimeout = ldtTimeout <= (long)0 ? "none" : String.valueOf(new Time(ldtTimeout).toString()) + "." + ldtTimeout % (long)1000;
        sb.append(", ServiceId=").append(this.getServiceId()).append(", MessageType=").append(this.getMessageType()).append(", FromMessageId=").append(this.getFromMessageId()).append(", ToMessageId=").append(this.getToMessageId()).append(", MessagePartCount=").append(this.getMessagePartCount()).append(", MessagePartIndex=").append(this.getMessagePartIndex()).append(", NackInProgress=").append(this.isNackInProgress()).append(", ResendScheduled=").append(sResend).append(", Timeout=").append(sTimeout).append(", PendingResendSkips=").append(this.getPendingResendSkips()).append(", DeliveryState=").append(this.formatDeliveryState(this.getDeliveryState())).append(", Body=").append(this.getReadBuffer().length());
        return sb.toString();
    }

    public int getDestinationMessageId(int nMemberId) {
        if (nMemberId == this.getToId()) {
            return this.getToMessageId();
        }
        DependentMemberSet setMember = this.getToMemberSet();
        if (setMember != null) {
            return setMember.getDestinationMessageId(nMemberId);
        }
        return 0;
    }

    public int getHeaderLength() {
        return Directed.calcHeaderLength(this.getToMemberSet());
    }

    public int getToMessageId() {
        return this.__m_ToMessageId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/packet/messagePacket/Directed".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Directed();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isConfirmationRequired() {
        return true;
    }

    public void read(ReadBuffer.BufferInput input, int nMemberId) throws IOException {
        int cMembers = 0;
        int iMember = -1;
        switch (this.getPacketType()) {
            case 232718549: {
                int nIdTmp = input.readUnsignedShort();
                Component._assert(nIdTmp == nMemberId);
                cMembers = 1;
                iMember = 0;
                break;
            }
            case 232718547: {
                cMembers = input.readUnsignedByte();
                int i = 0;
                while (i < cMembers) {
                    if (input.readUnsignedShort() == nMemberId) {
                        iMember = i;
                    }
                    ++i;
                }
                break;
            }
            case 232718548: {
                int cBitSets = input.readUnsignedByte();
                int nTheSet = Member.calcByteOffset(nMemberId);
                int nTheMask = Member.calcByteMask(nMemberId);
                int nPartial = nTheMask >>> 1;
                int i = 1;
                int iShift = 1;
                while (i <= 5) {
                    nPartial |= nPartial >>> iShift;
                    ++i;
                    iShift <<= 1;
                }
                i = 0;
                while (i < cBitSets) {
                    int nBits = input.readInt();
                    if (i == nTheSet) {
                        Component._assert((nBits & nTheMask) != 0);
                        iMember = cMembers + MemberSet.countBits(nBits & nPartial);
                    }
                    cMembers += MemberSet.countBits(nBits);
                    ++i;
                }
                int cMembersTmp = input.readUnsignedShort();
                Component._assert(cMembersTmp == cMembers);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + this.getPacketType());
            }
        }
        Component._assert(!(!(cMembers > 0) ? false : iMember >= 0) ? false : iMember < cMembers);
        int cbSkip = iMember * 3;
        if (cbSkip > 0) {
            long cbSkipped = input.skip(cbSkip);
            Component._assert(cbSkipped == (long)cbSkip);
        }
        this.setToMessageId(Packet.readUnsignedTrint(input));
        cbSkip = (cMembers - iMember - 1) * 3;
        if (cbSkip > 0) {
            long cbSkipped = input.skip(cbSkip);
            Component._assert(cbSkipped == (long)cbSkip);
        }
        this.setFromId(input.readUnsignedShort());
        this.setFromMessageId(Packet.readUnsignedTrint(input));
        this.setMessagePartCount(Packet.readUnsignedTrint(input));
        this.setServiceId(input.readUnsignedShort());
        this.setMessageType(input.readShort());
        this.readBody(input);
    }

    public int selectType(MemberSet memberSet) {
        int cMembers = memberSet.size();
        switch (cMembers) {
            case 0: {
                throw new IllegalArgumentException("no members in set!");
            }
            case 1: {
                return Packet.TYPE_DIRECTED_ONE;
            }
            case 2: 
            case 3: {
                return Packet.TYPE_DIRECTED_FEW;
            }
        }
        if (cMembers > 255) {
            return Packet.TYPE_DIRECTED_MANY;
        }
        int cbFew = 19 + 5 * cMembers;
        int cbMany = 21 + 3 * cMembers + 4 * (memberSet.getLastId() / 32 + 1);
        return cbFew <= cbMany ? Packet.TYPE_DIRECTED_FEW : Packet.TYPE_DIRECTED_MANY;
    }

    public void setToMessageId(int nId) {
        this.__m_ToMessageId = nId;
    }

    public static void skip(ReadBuffer.BufferInput input, int nType) throws IOException {
        int cMembers = 0;
        long cbSkip = 0L;
        switch (nType) {
            case 232718549: {
                cMembers = 1;
                cbSkip += 2L;
                break;
            }
            case 232718547: {
                cMembers = input.readUnsignedByte();
                cbSkip += (long)(cMembers << 1);
                break;
            }
            case 232718548: {
                int cBitSets = input.readUnsignedByte();
                long cbSkipped = input.skip(cbSkip += (long)(cBitSets << 2));
                Component._assert(cbSkipped == cbSkip);
                cbSkip = 0L;
                cMembers = input.readUnsignedShort();
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        cbSkip += (long)cMembers * 3L;
        long cbSkipped = input.skip(cbSkip += 12L);
        Component._assert(cbSkipped == cbSkip);
        MessagePacket.skipBody(input);
    }

    public void write(WriteBuffer.BufferOutput output, MemberSet setTo) throws IOException {
        int nType = this.selectType(setTo);
        this.setPacketType(nType);
        output.writeInt(nType);
        DependentMemberSet setMember = this.getToMemberSet();
        switch (nType) {
            case 232718549: {
                setTo.writeOne(output);
                if (setMember == null) {
                    Packet.writeTrint(output, this.getToMessageId());
                    break;
                }
                setMember.writeOneToMessageId(output, setTo);
                break;
            }
            case 232718547: {
                setTo.writeFew(output);
                setMember.writeFewToMessageId(output, setTo);
                break;
            }
            case 232718548: {
                setTo.writeMany(output);
                setMember.writeManyToMessageId(output, setTo);
                break;
            }
            default: {
                throw new IOException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        output.writeShort(this.getFromId());
        Packet.writeTrint(output, this.getFromMessageId());
        Packet.writeTrint(output, this.getMessagePartCount());
        output.writeShort(this.getServiceId());
        output.writeShort(this.getMessageType());
        this.writeBody(output);
    }
}

