/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.socket.udpSocket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Socket;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.util.HashHelper;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketAddress;

public class MulticastUdpSocket
extends UdpSocket {
    private SocketAddress __m_Address;
    private InetAddress __m_InterfaceInetAddress;
    private int __m_TimeToLive;

    public MulticastUdpSocket() {
        this(null, null, true);
    }

    public MulticastUdpSocket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setIgnoreSendErrors(false);
            this.setPacketLength(0);
            this.setRxDebugDropRate(0);
            this.setSoTimeout(-1);
            this.setTimeToLive(-1);
            this.setTxDebugDropRate(0);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public SocketAddress getAddress() {
        SocketAddress addr = this.__m_Address;
        if (addr == null) {
            addr = new InetSocketAddress(this.getInetAddress(), this.getPort());
            this.setAddress(addr);
        }
        return addr;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", InterfaceAddress=").append(Socket.toString(this.getInterfaceInetAddress())).append(", TimeToLive=").append(this.getTimeToLive());
        return sb.toString();
    }

    public InetAddress getInterfaceInetAddress() {
        return this.__m_InterfaceInetAddress;
    }

    public int getTimeToLive() {
        return this.__m_TimeToLive;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/socket/udpSocket/MulticastUdpSocket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new MulticastUdpSocket();
    }

    private final Component get_Module() {
        return this;
    }

    public int hashCode() {
        return HashHelper.hash(this.getTimeToLive() == 0, super.hashCode());
    }

    protected DatagramSocket instantiateDatagramSocket() throws IOException {
        int cTTL;
        InetAddress addr = this.getInetAddress();
        InetAddress addrInterface = this.getInterfaceInetAddress();
        int nPort = this.getPort();
        MulticastSocket socket = this.getProvider().openMulticastSocket();
        this.configure(socket);
        if (nPort == 65536) {
            socket.bind(null);
            this.setPort(socket.getLocalPort());
        } else {
            socket.bind(new InetSocketAddress(nPort));
        }
        if (!(addrInterface != null) ? false : InetAddressHelper.isAnyLocalAddress(addrInterface) ^ true) {
            socket.setInterface(addrInterface);
        }
        if ((cTTL = this.getTimeToLive()) >= 0) {
            socket.setTimeToLive(cTTL);
        }
        socket.joinGroup(addr);
        return socket;
    }

    protected void setAddress(SocketAddress addr) {
        this.__m_Address = addr;
    }

    public void setInetAddress(InetAddress addr) {
        if (addr == null ? true : addr.isMulticastAddress() ^ true) {
            throw new IllegalArgumentException(String.valueOf("MulticastUdpSocket.InetAddress is not in the multicast range: ") + Socket.toString(addr));
        }
        super.setInetAddress(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterfaceInetAddress(InetAddress addr) {
        if (!(addr != null) ? false : addr.isMulticastAddress()) {
            throw new IllegalArgumentException(String.valueOf("MulticastUdpSocket.InterfaceInetAddress is in the multicast range: ") + Socket.toString(addr));
        }
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "InterfaceInetAddress cannot be modified once the socket is open");
            this.__m_InterfaceInetAddress = addr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeToLive(int ttl) {
        if (ttl < 0) {
            return;
        }
        if (ttl > 255) {
            throw new IllegalArgumentException(String.valueOf("MulticastUdpSocket.TimeToLive is out of range (0..255): ") + ttl);
        }
        Object object = this.getLock();
        synchronized (object) {
            Component._assert(this.getState() != Socket.STATE_OPEN, "TimeToLive cannot be modified once the socket is open");
            this.__m_TimeToLive = ttl;
        }
    }
}

