/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.application.console.Coherence;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.net.extend.RemoteService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteCacheService;
import com.tangosol.coherence.component.net.extend.remoteService.RemoteInvocationService;
import com.tangosol.coherence.component.net.management.Gateway;
import com.tangosol.coherence.component.util.LocalCache;
import com.tangosol.coherence.component.util.SafeCluster$ShutdownHook;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.safeService.SafeCacheService;
import com.tangosol.coherence.component.util.safeService.SafeInvocationService;
import com.tangosol.coherence.component.util.safeService.SafeProxyService;
import com.tangosol.coherence.component.util.safeService.safeCacheService.SafeDistributedCacheService;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.internal.net.cluster.DefaultClusterDependencies;
import com.tangosol.internal.net.cluster.LegacyXmlClusterDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.Service;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.internal.ClusterJoinException;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.management.Registry;
import com.tangosol.net.security.IdentityAsserter;
import com.tangosol.net.security.IdentityTransformer;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.Disposable;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteSet;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SafeCluster
extends Util
implements Cluster,
OperationalContext,
ServiceListener,
SynchronousListener {
    private transient Cluster __m_Cluster;
    private ClassLoader __m_ContextClassLoader;
    private ClusterDependencies __m_Dependencies;
    private Set __m_LocalServices;
    private transient Registry __m_Management;
    private boolean __m_Restart;
    private ScopedReferenceStore __m_ScopedStore;
    private SafeCluster$ShutdownHook __m_ShutdownHook;
    private com.tangosol.coherence.component.net.Member __m_SurrogateMember;
    private static ListMap __mapChildren;

    static {
        SafeCluster.__initStatic();
    }

    public SafeCluster() {
        this(null, null, true);
    }

    public SafeCluster(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setLocalServices(new LiteSet());
            this.setRestart(true);
            this.setScopedStore(new ScopedReferenceStore());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("ShutdownHook", SafeCluster$ShutdownHook.get_CLASS());
    }

    protected void cleanup() {
        this.setCluster(null);
        this.setSurrogateMember(null);
        ScopedReferenceStore store = this.getScopedStore();
        store.lockAll();
        try {
            store.clear();
        }
        finally {
            Object var3_2 = null;
            store.unlockAll();
        }
        this.getLocalServices().clear();
    }

    public void configure(XmlElement xmlConfig) {
        this.setDependencies(new LegacyXmlClusterDependencies().fromXml(xmlConfig));
    }

    protected ClusterDependencies ensureDependencies() {
        ClusterDependencies deps = this.getDependencies();
        if (deps == null) {
            this.configure(CacheFactory.getClusterConfig());
            deps = this.getDependencies();
        }
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service ensureLocalService(String sName, String sType) {
        Component serviceLocal;
        Component service;
        if (sType.equals(CacheService.TYPE_LOCAL)) {
            service = new LocalCache();
            ((LocalCache)service).setServiceName(sName);
            ((LocalCache)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals(CacheService.TYPE_REMOTE)) {
            service = new RemoteCacheService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else if (sType.equals(InvocationService.TYPE_REMOTE)) {
            service = new RemoteInvocationService();
            ((RemoteService)service).setServiceName(sName);
            ((RemoteService)service).setCluster(this);
            serviceLocal = service;
        } else {
            throw new IllegalArgumentException(String.valueOf("illegal local service type: ") + sType);
        }
        serviceLocal.addServiceListener(this);
        String sHook = System.getProperty("tangosol.coherence.shutdownhook.local", "true");
        Set setLocal = this.getLocalServices();
        if (!(!setLocal.isEmpty() ? false : this.getShutdownHook() == null) ? false : "true".equals(sHook)) {
            Set set = setLocal;
            synchronized (set) {
                if (!setLocal.isEmpty() ? false : this.getShutdownHook() == null) {
                    try {
                        SafeCluster$ShutdownHook hook = new SafeCluster$ShutdownHook();
                        hook.set_Feed(new WeakReference<SafeCluster>(this));
                        this.setShutdownHook(hook);
                        hook.register();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
        setLocal.add(serviceLocal);
        return serviceLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cluster ensureRunningCluster() {
        com.tangosol.coherence.component.net.Cluster cluster = (com.tangosol.coherence.component.net.Cluster)this.getCluster();
        if (!(cluster == null ? true : cluster.isRunning() ^ true)) return cluster;
        Gateway registry = (Gateway)this.getManagement();
        boolean fRegister = registry != null;
        SafeCluster safeCluster = this;
        synchronized (safeCluster) {
            cluster = (com.tangosol.coherence.component.net.Cluster)this.getCluster();
            if (cluster == null ? true : cluster.isRunning() ^ true) {
                if (!this.isRestart()) throw new IllegalStateException("SafeCluster has been explicitly stopped or has not been started");
                if (cluster != null) {
                    cluster.ensureStopped();
                    cluster = null;
                    this.setCluster(null);
                    Component._trace("Restarting cluster", 3);
                }
                cluster = this.restartCluster();
                this.setCluster(cluster);
            } else {
                fRegister = false;
            }
        }
        if (!fRegister) return cluster;
        registry.reset();
        String sNodeName = registry.ensureGlobalName(Registry.NODE_TYPE);
        registry.register(sNodeName, this.getLocalMember());
        String sP2PName = registry.ensureGlobalName(Registry.POINT_TO_POINT_TYPE);
        registry.register(sP2PName, cluster.getClusterService().getClusterMemberSet());
        registry.registerReporter();
        registry.registerCustomBeans();
        return cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SafeService ensureSafeService(String sName, String sType) {
        ScopedReferenceStore store = this.getScopedStore();
        SafeService serviceSafe = (SafeService)store.getService(sName);
        if (serviceSafe == null) {
            SafeCluster safeCluster = this;
            synchronized (safeCluster) {
                serviceSafe = (SafeService)store.getService(sName);
                if (serviceSafe == null) {
                    Service service = SafeCluster.isLocalService(sType) ? this.ensureLocalService(sName, sType) : this.getRunningCluster().ensureService(sName, sType);
                    serviceSafe = this.instantiateSafeService(service);
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    serviceSafe.setServiceType(sType);
                    serviceSafe.setService(service);
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    serviceSafe.setSubject(SecurityHelper.getCurrentSubject());
                    store.putService(serviceSafe, sName, sType);
                }
            }
        }
        return serviceSafe;
    }

    public Service ensureService(String sName, String sType) {
        String sCacheName = InvocationService.TYPE_DEFAULT.equals(sType) ? null : "*";
        Security.checkPermission(this.getCluster(), sName, sCacheName, "join");
        SafeService serviceSafe = (SafeService)this.getScopedStore().getService(sName);
        if (serviceSafe == null) {
            serviceSafe = this.ensureSafeService(sName, sType);
        }
        if (serviceSafe.getServiceType().equals(sType) ^ true) {
            throw new IllegalArgumentException(String.valueOf("Requested service type \"") + sType + "\", but the existing service has type \"" + serviceSafe.getServiceType() + '\"');
        }
        return serviceSafe;
    }

    public Cluster getCluster() {
        return this.__m_Cluster;
    }

    public String getClusterName() {
        return this.getRunningCluster().getClusterName();
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader loader = this.__m_ContextClassLoader;
        if (loader == null) {
            loader = Base.getContextClassLoader(this);
        }
        return loader;
    }

    public ClusterDependencies getDependencies() {
        return this.__m_Dependencies;
    }

    public int getEdition() {
        return this.ensureDependencies().getEdition();
    }

    public String getEditionName() {
        return Coherence.EDITION_NAMES[this.ensureDependencies().getEdition()];
    }

    public Map getFilterMap() {
        return this.ensureDependencies().getFilterMap();
    }

    public IdentityAsserter getIdentityAsserter() {
        Security.getInstance();
        return Security.getIdentityAsserter();
    }

    public IdentityTransformer getIdentityTransformer() {
        Security.getInstance();
        return Security.getIdentityTransformer();
    }

    public Member getLocalMember() {
        com.tangosol.coherence.component.net.Cluster cluster = (com.tangosol.coherence.component.net.Cluster)this.getCluster();
        return cluster == null ? this.getSurrogateMember() : cluster.getLocalMember();
    }

    protected Set getLocalServices() {
        return this.__m_LocalServices;
    }

    public Registry getManagement() {
        return this.__m_Management;
    }

    public Set getMemberSet() {
        return this.getRunningCluster().getMemberSet();
    }

    public Member getOldestMember() {
        return this.getRunningCluster().getOldestMember();
    }

    public Disposable getResource(String sName) {
        return this.getRunningCluster().getResource(sName);
    }

    protected Cluster getRunningCluster() {
        return this.ensureRunningCluster();
    }

    public ScopedReferenceStore getScopedStore() {
        return this.__m_ScopedStore;
    }

    public Map getSerializerMap() {
        return this.ensureDependencies().getSerializerMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(String sName) {
        Security.checkPermission(this.getCluster(), sName, null, "join");
        ScopedReferenceStore store = this.getScopedStore();
        SafeService serviceSafe = (SafeService)store.getService(sName);
        if (serviceSafe == null) {
            SafeCluster safeCluster = this;
            synchronized (safeCluster) {
                Service service;
                serviceSafe = (SafeService)store.getService(sName);
                if (serviceSafe == null && (service = this.getRunningCluster().getService(sName)) != null) {
                    serviceSafe = this.instantiateSafeService(service);
                    serviceSafe.setSafeCluster(this);
                    serviceSafe.setServiceName(sName);
                    String sServiceType = service.getInfo().getServiceType();
                    serviceSafe.setServiceType(sServiceType);
                    serviceSafe.setService(service);
                    serviceSafe.setContextClassLoader(this.getContextClassLoader());
                    store.putService(serviceSafe, sName, sServiceType);
                }
            }
        }
        return serviceSafe;
    }

    public ServiceInfo getServiceInfo(String sName) {
        return this.getRunningCluster().getServiceInfo(sName);
    }

    public Enumeration getServiceNames() {
        return this.getRunningCluster().getServiceNames();
    }

    public SafeCluster$ShutdownHook getShutdownHook() {
        return this.__m_ShutdownHook;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        return this.ensureDependencies().getSocketProviderFactory();
    }

    public com.tangosol.coherence.component.net.Member getSurrogateMember() {
        com.tangosol.coherence.component.net.Member member = this.__m_SurrogateMember;
        if (member == null) {
            member = new com.tangosol.coherence.component.net.Member();
            member.configure(this.ensureDependencies().getMemberIdentity(), null);
            this.setSurrogateMember(member);
        }
        return member;
    }

    public long getTimeMillis() {
        try {
            return this.getCluster().getTimeMillis();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/SafeCluster".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new SafeCluster();
    }

    private final Component get_Module() {
        return this;
    }

    protected SafeService instantiateSafeService(Service service) {
        return service instanceof CacheService ? (service instanceof DistributedCacheService ? new SafeDistributedCacheService() : new SafeCacheService()) : (service instanceof InvocationService ? new SafeInvocationService() : (service instanceof ProxyService ? new SafeProxyService() : new SafeService()));
    }

    public static boolean isLocalService(String sType) {
        return (sType.equals(CacheService.TYPE_LOCAL) ? true : sType.equals(CacheService.TYPE_REMOTE)) ? true : sType.equals(InvocationService.TYPE_REMOTE);
    }

    public boolean isRestart() {
        return this.__m_Restart;
    }

    public boolean isRunning() {
        Cluster cluster = this.getCluster();
        return !(!(cluster != null) ? false : this.isRestart()) ? false : cluster.isRunning();
    }

    public boolean isSubjectScopingEnabled() {
        Security.getInstance();
        return Security.isSubjectScoped();
    }

    public void registerResource(String sName, Disposable disposable) {
        this.getRunningCluster().registerResource(sName, disposable);
    }

    protected com.tangosol.coherence.component.net.Cluster restartCluster() {
        int cAttempts = 0;
        while (true) {
            com.tangosol.coherence.component.net.Cluster cluster = null;
            try {
                cluster = new com.tangosol.coherence.component.net.Cluster();
                this.startCluster(cluster);
                return cluster;
            }
            catch (Throwable e) {
                if (!(!(e instanceof ClusterJoinException ? true : e.getCause() instanceof ClusterJoinException) ? false : ++cAttempts < 5)) {
                    Component._trace(String.valueOf("Error while starting cluster: ") + Component.getStackTrace(e), 1);
                    try {
                        if (this.isRunning()) {
                            cluster.stop();
                        }
                    }
                    catch (Throwable e2) {
                        Component._trace(String.valueOf("Failed to stop cluster: ") + Component.getStackTrace(e2), 2);
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw (RuntimeException)e;
                }
                Component._trace("Cluster seniority changed during join; rejoining the cluster", 3);
                ++cAttempts;
                continue;
            }
            break;
        }
    }

    public void serviceStarted(ServiceEvent evt) {
    }

    public void serviceStarting(ServiceEvent evt) {
    }

    public void serviceStopped(ServiceEvent evt) {
        Service service = (Service)evt.getService();
        if (SafeCluster.isLocalService(service.getInfo().getServiceType())) {
            this.getLocalServices().remove(service);
        }
    }

    public void serviceStopping(ServiceEvent evt) {
    }

    protected void setCluster(Cluster cluster) {
        this.__m_Cluster = cluster;
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
    }

    public void setDependencies(ClusterDependencies deps) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot configure running cluster");
        }
        this.__m_Dependencies = new DefaultClusterDependencies(deps).validate();
        this.setSurrogateMember(null);
    }

    protected void setLocalServices(Set set) {
        this.__m_LocalServices = set;
    }

    public void setManagement(Registry registry) {
        this.__m_Management = registry;
    }

    public void setRestart(boolean fRestart) {
        this.__m_Restart = fRestart;
    }

    protected void setScopedStore(ScopedReferenceStore store) {
        this.__m_ScopedStore = store;
    }

    protected void setShutdownHook(SafeCluster$ShutdownHook hook) {
        this.__m_ShutdownHook = hook;
    }

    protected void setSurrogateMember(com.tangosol.coherence.component.net.Member member) {
        this.__m_SurrogateMember = member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.setRestart(false);
        Cluster cluster = this.getCluster();
        if (cluster != null) {
            Cluster cluster2 = cluster;
            synchronized (cluster2) {
                if (cluster.isRunning()) {
                    cluster.shutdown();
                }
            }
        }
        this.shutdownLocalServices();
        this.cleanup();
    }

    public void shutdownLocalServices() {
        SafeCluster$ShutdownHook hook = this.getShutdownHook();
        if (hook != null) {
            hook.unregister();
            this.setShutdownHook(null);
        }
        try {
            Iterator iter = this.getLocalServices().iterator();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                iter.remove();
                service.removeServiceListener(this);
                service.shutdown();
            }
        }
        catch (Throwable throwable) {}
    }

    public synchronized void start() {
        this.setRestart(true);
        this.ensureRunningCluster();
    }

    protected void startCluster(com.tangosol.coherence.component.net.Cluster cluster) {
        cluster.setDependencies(this.ensureDependencies());
        cluster.setManagement(this.getManagement());
        cluster.start();
        Component._trace(String.valueOf("Started cluster ") + cluster, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.setRestart(false);
        Cluster cluster = this.getCluster();
        if (cluster != null) {
            Cluster cluster2 = cluster;
            synchronized (cluster2) {
                if (cluster.isRunning()) {
                    cluster.stop();
                }
            }
        }
        this.shutdownLocalServices();
        this.cleanup();
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ": " + this.getCluster();
    }

    public Disposable unregisterResource(String sName) {
        return this.getRunningCluster().unregisterResource(sName);
    }
}

