/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;

public class WindowedArray
extends Util {
    protected static final Object REMOVED;
    private long __m_FirstIndex;
    private transient long __m_FirstStuckIndex;
    private transient long __m_LastSizeWarningMillis;
    private int __m_StatsExpansions;
    private volatile Object[] __m_Store;
    private int __m_WindowIndex;
    private int __m_WindowSize;

    static {
        try {
            REMOVED = new Object();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public WindowedArray() {
        this(null, null, true);
    }

    public WindowedArray(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized long add(Object o) {
        long lVirtual = this.getSize();
        int iActual = this.ensureIndex(lVirtual);
        this.getStore()[iActual] = o;
        return lVirtual;
    }

    protected int checkCapacity(int cCapacity) {
        int cMaxCapacity = this.getMaximumCapacity();
        int cCurrentCapacity = this.getCapacity();
        if (cCurrentCapacity == cMaxCapacity) {
            long lvFirst = this.getFirstIndex();
            Object oFirst = this.get(lvFirst);
            String sFirst = null;
            if (oFirst != null) {
                sFirst = String.valueOf(oFirst.getClass().getName()) + ":" + oFirst;
            }
            throw new IndexOutOfBoundsException(String.valueOf(this.get_Name()) + " has exceeded max capacity of " + cMaxCapacity + " size = " + this.getSize() + "; first element[" + lvFirst + "] = " + sFirst);
        }
        if (cCapacity > this.getMaximumCapacity() >>> 4) {
            long ldtNow;
            long lvFirst = this.getFirstIndex();
            if (lvFirst == this.getFirstStuckIndex() && (ldtNow = Base.getSafeTimeMillis()) - this.getLastSizeWarningMillis() > 30000L) {
                Object oFirst = this.get(lvFirst);
                String sFirst = null;
                if (oFirst != null) {
                    sFirst = String.valueOf(oFirst.getClass().getName()) + ":" + oFirst;
                }
                Component._trace(String.valueOf(this.get_Name()) + " window size has grown to " + cCapacity + " elements; first element[" + lvFirst + "] = " + sFirst, 2);
                this.setLastSizeWarningMillis(ldtNow);
            }
            this.setFirstStuckIndex(lvFirst);
        }
        return Math.min(cCapacity, cMaxCapacity);
    }

    protected int ensureIndex(long lVirtual) {
        long lvFirst = this.getFirstIndex();
        if (lVirtual < lvFirst) {
            throw new IndexOutOfBoundsException(String.valueOf("window cannot grow backwards (index=") + lVirtual + ", window first index=" + lvFirst + ")");
        }
        long iLast = this.getLastIndex();
        if (lVirtual > iLast) {
            int cNewElements = (int)(lVirtual - lvFirst) + 1;
            if (cNewElements > this.getCapacity()) {
                this.grow(lVirtual);
            }
            this.setWindowSize(cNewElements);
        }
        return this.translateIndex(lVirtual);
    }

    public String formatStats() {
        StringBuffer sb = new StringBuffer();
        sb.append("capacity=").append(this.getCapacity()).append(", expanions=").append(this.getStatsExpansions()).append(", size=").append(this.getSize()).append(", window index=").append(this.getWindowIndex()).append(", window size=").append(this.getWindowSize()).append(", first index=").append(this.getFirstIndex()).append(", last index=").append(this.getLastIndex());
        return sb.toString();
    }

    public synchronized Object get(long lVirtual) {
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf("negative index is illegal: ") + lVirtual);
        }
        if (lVirtual < this.getFirstIndex() ? true : lVirtual > this.getLastIndex()) {
            return null;
        }
        Object o = this.getStore()[this.translateIndex(lVirtual)];
        return o == REMOVED ? null : o;
    }

    public synchronized int getAll(long[] alIndex, int cEntries, Object[] aoResult) {
        long lvFirstIndex = this.getFirstIndex();
        long lvLastIndex = this.getLastIndex();
        int cFound = 0;
        int i = 0;
        while (i < cEntries) {
            long lVirtual = alIndex[i];
            if (lVirtual < 0L) {
                throw new IndexOutOfBoundsException(String.valueOf("negative index is illegal: ") + lVirtual);
            }
            if (lVirtual < lvFirstIndex ? true : lVirtual > lvLastIndex) {
                aoResult[i] = null;
            } else {
                Object o = this.getStore()[this.translateIndex(lVirtual)];
                if (o == REMOVED) {
                    aoResult[i] = null;
                } else {
                    aoResult[i] = o;
                    ++cFound;
                }
            }
            ++i;
        }
        return cFound;
    }

    public int getCapacity() {
        return this.getStore().length;
    }

    public long getFirstIndex() {
        return this.__m_FirstIndex;
    }

    public long getFirstStuckIndex() {
        return this.__m_FirstStuckIndex;
    }

    public int getInitialCapacity() {
        return 64;
    }

    public long getLastIndex() {
        return this.getSize() - (long)1;
    }

    public long getLastSizeWarningMillis() {
        return this.__m_LastSizeWarningMillis;
    }

    public int getMaximumCapacity() {
        return 0x1000000;
    }

    public long getSize() {
        return this.getFirstIndex() + (long)this.getWindowSize();
    }

    public int getStatsExpansions() {
        return this.__m_StatsExpansions;
    }

    protected Object[] getStore() {
        return this.__m_Store;
    }

    protected int getWindowIndex() {
        return this.__m_WindowIndex;
    }

    public int getWindowSize() {
        return this.__m_WindowSize;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/WindowedArray".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new WindowedArray();
    }

    private final Component get_Module() {
        return this;
    }

    protected void grow(long lVirtual) {
        int cElements;
        int cOldCapacity = this.getCapacity();
        int cNewCapacity = this.checkCapacity(Math.max(cOldCapacity * 2, (int)(lVirtual - this.getFirstIndex()) + 3));
        Object[] aoOld = this.getStore();
        Object[] aoNew = new Object[cNewCapacity];
        int iaStart = this.getWindowIndex();
        int iaEnd = iaStart + (cElements = this.getWindowSize()) - 1;
        if (iaEnd >= cOldCapacity) {
            int cPrewrapElements = cOldCapacity - iaStart;
            int cPostwrapElements = iaEnd - cOldCapacity + 1;
            System.arraycopy(aoOld, iaStart, aoNew, 0, cPrewrapElements);
            System.arraycopy(aoOld, 0, aoNew, cPrewrapElements, cPostwrapElements);
        } else {
            System.arraycopy(aoOld, iaStart, aoNew, 0, cElements);
        }
        this.setStatsExpansions(this.getStatsExpansions() + 1);
        this.setStore(aoNew);
        this.setWindowIndex(0);
    }

    public synchronized boolean isRemoved(long lVirtual) {
        return !(lVirtual <= this.getLastIndex()) ? false : (lVirtual < this.getFirstIndex() ? true : this.getStore()[this.translateIndex(lVirtual)] == REMOVED);
    }

    public void onInit() {
        this.setStore(new Object[this.getInitialCapacity()]);
        super.onInit();
    }

    public synchronized Object remove(long lVirtual) {
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf("negative index is illegal: ") + lVirtual);
        }
        long lvFirst = this.getFirstIndex();
        if (lVirtual < lvFirst) {
            return null;
        }
        long lvLast = this.getLastIndex();
        if (lVirtual > lvLast) {
            throw new IndexOutOfBoundsException(String.valueOf("remove beyond window (index=") + lVirtual + ", window last index=" + lvLast + ")");
        }
        Object[] aoElement = this.getStore();
        int iActual = this.translateIndex(lVirtual);
        Object oOrig = aoElement[iActual];
        aoElement[iActual] = REMOVED;
        if (lVirtual == lvFirst) {
            int iaIndex = iActual;
            int cWindowElements = this.getWindowSize();
            while (cWindowElements > 0) {
                iActual = iaIndex;
                if (aoElement[iActual] != REMOVED) break;
                aoElement[iActual] = null;
                iaIndex = this.translateIndex(++lvFirst);
                --cWindowElements;
            }
            this.setFirstIndex(lvFirst);
            this.setWindowIndex(iaIndex);
            this.setWindowSize(cWindowElements);
        }
        return oOrig == REMOVED ? null : oOrig;
    }

    public synchronized Object set(long lVirtual, Object o) {
        if (lVirtual < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf("negative index is illegal: ") + lVirtual);
        }
        int iActual = this.ensureIndex(lVirtual);
        Object[] ao = this.getStore();
        Object oOrig = ao[iActual];
        ao[iActual] = o;
        return oOrig == REMOVED ? null : oOrig;
    }

    protected void setFirstIndex(long lVirtual) {
        this.__m_FirstIndex = lVirtual;
    }

    protected void setFirstStuckIndex(long lIndex) {
        this.__m_FirstStuckIndex = lIndex;
    }

    protected void setLastSizeWarningMillis(long ldtMillis) {
        this.__m_LastSizeWarningMillis = ldtMillis;
    }

    public void setStatsExpansions(int pStatsExpansions) {
        this.__m_StatsExpansions = pStatsExpansions;
    }

    protected void setStore(Object[] ao) {
        this.__m_Store = ao;
    }

    protected void setWindowIndex(int i) {
        this.__m_WindowIndex = i;
    }

    protected void setWindowSize(int c) {
        this.__m_WindowSize = c;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append('[').append(this.formatStats()).append(']');
        long lVirtual = this.getFirstIndex();
        long lvLast = this.getLastIndex();
        while (lVirtual <= lvLast) {
            Object o = this.get(lVirtual);
            if (o != null) {
                sb.append("\n[").append(lVirtual).append("]=\"").append(o).append('\"');
            }
            ++lVirtual;
        }
        return sb.toString();
    }

    protected int translateIndex(long lVirtual) {
        return (this.getWindowIndex() + (int)(lVirtual - this.getFirstIndex())) % this.getCapacity();
    }
}

