/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.daemon.IpMonitor$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IpMonitor
extends Daemon {
    private volatile transient InetAddress[] __m_AddressScanArray;
    private long __m_AddressTimeout;
    private long __m_CurrentTimeoutMillis;
    private int __m_PingTimeout;
    private transient int __m_Position;
    private ClusterService __m_Service;
    private long __m_StatsTimeouts;
    private InetAddress __m_Suspect;

    public IpMonitor() {
        this(null, null, true);
    }

    public IpMonitor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new IpMonitor$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void advanceIpMonitor() {
        this.setSuspect(null);
        this.setCurrentTimeoutMillis(0L);
        InetAddress[] aAddr = this.getAddressScanArray();
        if (aAddr.length == 0) {
            this.setPosition(0);
        } else {
            this.setPosition((this.getPosition() + 1) % aAddr.length);
        }
    }

    protected InetAddress[] calculateAddressScanArray(Set setAddress) {
        setAddress.remove(this.getThisMember().getAddress());
        int cAddr = setAddress.size();
        return (InetAddress[])Base.randomize(setAddress.toArray(new InetAddress[cAddr]));
    }

    public void configure(ClusterDependencies config, ClusterService service) {
        this.setService(service);
        this.setWaitMillis(config.getClusterHeartbeatDelayMillis());
        int cPingTimeout = (int)config.getIpMonitorTimeoutMillis();
        int cAttempts = Math.max(config.getIpMonitorAttempts(), 1);
        int cIpMonitorDefault = 5000;
        this.setPingTimeout(cPingTimeout);
        this.setAddressTimeout(cAttempts * cPingTimeout);
        if (cPingTimeout < cIpMonitorDefault) {
            Component._trace(String.valueOf("The timeout value configured for IpMonitor pings is shorter than the") + " value of 5 seconds. Short ping timeouts may cause an IP address to be" + " wrongly reported as unreachable on some platforms.", 2);
        }
    }

    protected Map countMembersByAddress(MemberSet setMembers) {
        HashMap<InetAddress, Integer> mapByAddress = new HashMap<InetAddress, Integer>();
        Iterator iter = setMembers.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            InetAddress addr = member.getAddress();
            Integer IMembers = (Integer)mapByAddress.get(addr);
            int cMembers = IMembers == null ? 0 : IMembers;
            mapByAddress.put(addr, Base.makeInteger(cMembers + 1));
        }
        return mapByAddress;
    }

    public String formatStats() {
        return String.valueOf("Timeouts=") + this.getStatsTimeouts();
    }

    private InetAddress[] getAddressScanArray() {
        return this.__m_AddressScanArray;
    }

    public long getAddressTimeout() {
        return this.__m_AddressTimeout;
    }

    public InetAddress getCurrentAddress() {
        InetAddress[] aAddr;
        int cAddr;
        InetAddress addr = this.getSuspect();
        if (addr == null && (cAddr = (aAddr = this.getAddressScanArray()).length) > 0) {
            addr = aAddr[this.getPosition() % cAddr];
            if (this.getCurrentTimeoutMillis() == 0L) {
                this.setCurrentTimeoutMillis(Base.getSafeTimeMillis() + this.getAddressTimeout());
            }
        }
        return addr;
    }

    public long getCurrentTimeoutMillis() {
        return this.__m_CurrentTimeoutMillis;
    }

    public int getPingTimeout() {
        return this.__m_PingTimeout;
    }

    private int getPosition() {
        return this.__m_Position;
    }

    public ClusterService getService() {
        return this.__m_Service;
    }

    public ServiceMemberSet getServiceMemberSet() {
        return this.getService().getServiceMemberSet();
    }

    public long getStatsTimeouts() {
        return this.__m_StatsTimeouts;
    }

    private InetAddress getSuspect() {
        return this.__m_Suspect;
    }

    public Member getThisMember() {
        return this.getService().getThisMember();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/IpMonitor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new IpMonitor();
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        guardable = this.getService().instantiateWrapperGuardable(guardable);
        return super.guard(guardable, cMillis, flPctRecover);
    }

    protected void onEnter() {
        this.resetStats();
        Map mapByAddress = this.countMembersByAddress(this.getServiceMemberSet());
        this.setAddressScanArray(this.calculateAddressScanArray(mapByAddress.keySet()));
    }

    public void onMemberJoined(Member member) {
        Map mapByAddress = this.countMembersByAddress(this.getServiceMemberSet());
        Integer IColocated = (Integer)mapByAddress.get(member.getAddress());
        int cColocated = IColocated == null ? 0 : IColocated;
        if (cColocated == 1) {
            this.setAddressScanArray(this.calculateAddressScanArray(mapByAddress.keySet()));
        }
    }

    public void onMemberLeft(Member member) {
        Map mapByAddress = this.countMembersByAddress(this.getServiceMemberSet());
        Integer IColocated = (Integer)mapByAddress.get(member.getAddress());
        int cColocated = IColocated == null ? 0 : IColocated;
        if (cColocated == 0) {
            this.setAddressScanArray(this.calculateAddressScanArray(mapByAddress.keySet()));
        }
    }

    protected void onNotify() {
        InetAddress addr;
        int cPingTimeout = this.getPingTimeout();
        int cIter = (int)Math.ceil(this.getAddressTimeout() / (long)cPingTimeout);
        while (!((addr = this.getCurrentAddress()) != null) ? false : --cIter > 0) {
            try {
                if (addr.isReachable(cPingTimeout)) {
                    this.advanceIpMonitor();
                    return;
                }
                if (Base.getSafeTimeMillis() > this.getCurrentTimeoutMillis()) {
                    this.getService().doNotifyIpTimeout(addr);
                    this.setStatsTimeouts(this.getStatsTimeouts() + (long)1);
                    this.advanceIpMonitor();
                } else {
                    this.setSuspect(addr);
                }
                this.heartbeat();
            }
            catch (IOException e) {
                Component._trace(String.valueOf("Network failure encountered during InetAddress.isReachable(): ") + Component.getStackTrace(e), 5);
            }
        }
    }

    protected void onWait() throws InterruptedException {
        this.heartbeat();
        super.onWait();
    }

    public void resetStats() {
        this.setStatsTimeouts(0L);
    }

    private void setAddressScanArray(InetAddress[] pAddressScanArray) {
        this.__m_AddressScanArray = pAddressScanArray;
    }

    public void setAddressTimeout(long pAddressTimeout) {
        this.__m_AddressTimeout = pAddressTimeout;
    }

    public void setCurrentTimeoutMillis(long pCurrentTimeoutMillis) {
        this.__m_CurrentTimeoutMillis = pCurrentTimeoutMillis;
    }

    public void setPingTimeout(int pPingTimeout) {
        this.__m_PingTimeout = pPingTimeout;
    }

    private void setPosition(int pPosition) {
        this.__m_Position = pPosition;
    }

    public void setService(ClusterService pService) {
        this.__m_Service = pService;
    }

    public void setStatsTimeouts(long pStatsTimeouts) {
        this.__m_StatsTimeouts = pStatsTimeouts;
    }

    private void setSuspect(InetAddress pSuspect) {
        this.__m_Suspect = pSuspect;
    }

    public String toString() {
        if (this.isStarted()) {
            return String.valueOf("IpMonitor{AddressListSize=") + this.getAddressScanArray().length + '}';
        }
        return "IpMonitor is disabled";
    }

    public boolean verifyReachable(Member member) {
        try {
            return member.getAddress().isReachable(this.getPingTimeout());
        }
        catch (IOException e) {
            Component._trace(String.valueOf("Network failure encountered during InetAddress.isReachable(): ") + Component.getStackTrace(e), 5);
            return false;
        }
    }
}

