/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.LogOutput;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger$ShutdownHook;
import com.tangosol.coherence.component.util.logOutput.Jdk;
import com.tangosol.coherence.component.util.logOutput.Log4j;
import com.tangosol.coherence.component.util.logOutput.Standard;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.sql.Timestamp;
import java.util.Map;

public class Logger
extends QueueProcessor {
    public static final int LEVEL_ALL = 10;
    public static final int LEVEL_D4 = 4;
    public static final int LEVEL_D5 = 5;
    public static final int LEVEL_D6 = 6;
    public static final int LEVEL_D7 = 7;
    public static final int LEVEL_D8 = 8;
    public static final int LEVEL_D9 = 9;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_INTERNAL = 0;
    public static final int LEVEL_NONE = -1;
    public static final String[] LEVEL_TEXT;
    public static final int LEVEL_WARNING = 2;
    public static final char THREAD_NAME_DELIM = '|';
    private String __m_Destination;
    private String __m_Format;
    private int __m_Level;
    private int __m_Limit;
    private LogOutput __m_LogOutput;
    private String[] __m_Parameters;
    private static ListMap __mapChildren;
    private static Integer[] __s_Integer;

    static {
        try {
            LEVEL_TEXT = new String[]{"Internal", "Error", "Warning", "Info", "D4", "D5", "D6", "D7", "D8", "D9"};
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        Logger._initStatic();
    }

    public Logger() {
        this(null, null, true);
    }

    public Logger(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setLevel(10);
            this.setLimit(65536);
            this.setParameters(new String[]{"{date}", "{uptime}", "{level}", "{thread}", "{e}", "{text}"});
            this.setPriority(3);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Logger$ShutdownHook("ShutdownHook", this, true), "ShutdownHook");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static void _initStatic$Default() {
        Logger.__initStatic();
    }

    protected static void _initStatic() {
        Logger._initStatic$Default();
        Integer[] ai = new Integer[]{Base.makeInteger(LEVEL_NONE), Base.makeInteger(LEVEL_INTERNAL), Base.makeInteger(LEVEL_ERROR), Base.makeInteger(LEVEL_WARNING), Base.makeInteger(LEVEL_INFO), Base.makeInteger(LEVEL_D4), Base.makeInteger(LEVEL_D5), Base.makeInteger(LEVEL_D6), Base.makeInteger(LEVEL_D7), Base.makeInteger(LEVEL_D8), Base.makeInteger(LEVEL_D9), Base.makeInteger(LEVEL_ALL)};
        Logger.setInteger(ai);
    }

    public void configure(XmlElement xmlConfig) {
        String sDest = xmlConfig.getSafeElement("destination").getString(this.getDefaultDestination());
        String sFormat = xmlConfig.getSafeElement("message-format").getString(this.getDefaultFormat());
        int nLevel = xmlConfig.getSafeElement("severity-level").getInt(this.getDefaultLevel());
        int nLimit = xmlConfig.getSafeElement("character-limit").getInt(this.getDefaultLimit());
        if (sFormat.length() == 0) {
            sFormat = this.getDefaultFormat();
        }
        if (nLevel < LEVEL_NONE) {
            nLevel = LEVEL_NONE;
        }
        if (nLevel > LEVEL_ALL) {
            nLevel = LEVEL_ALL;
        }
        if (nLimit <= 0) {
            nLimit = Integer.MAX_VALUE;
        }
        LogOutput output = null;
        try {
            output = "jdk".equalsIgnoreCase(sDest) ? new Jdk() : ("log4j".equalsIgnoreCase(sDest) ? new Log4j() : new Standard());
            output.configure(xmlConfig);
        }
        catch (Throwable e) {
            xmlConfig.getSafeElement("destination").setString(this.getDefaultDestination());
            output = new Standard();
            output.configure(xmlConfig);
            output.log(Logger.getInteger(LEVEL_ERROR), e, "Error configuring logger; using default settings.");
        }
        this.setDestination(sDest);
        this.setFormat(sFormat);
        this.setLevel(nLevel);
        this.setLimit(nLimit);
        this.setLogOutput(output);
    }

    protected Object[] createMessage(int nLevel, Throwable throwable, String sMessage, Object[] aoParam) {
        int cParams = aoParam == null ? 0 : aoParam.length;
        Object[] aoMessage = new Object[6 + cParams];
        aoMessage[0] = new Timestamp(System.currentTimeMillis());
        aoMessage[1] = new Long(Base.getUpTimeMillis());
        aoMessage[2] = Logger.getInteger(nLevel);
        aoMessage[3] = Thread.currentThread();
        aoMessage[4] = throwable;
        aoMessage[5] = sMessage;
        if (cParams > 0) {
            System.arraycopy(aoParam, 0, aoMessage, 6, cParams);
        }
        return aoMessage;
    }

    public String formatMessage(Object[] aoParam) {
        String sMessage = (String)aoParam[5];
        Integer ILevel = (Integer)aoParam[2];
        if (ILevel != LEVEL_INTERNAL) {
            String sFormat = this.getFormat();
            String[] aoParamName = this.getParameters();
            int cParamNames = aoParamName == null ? 0 : aoParamName.length;
            int cParams = aoParam.length;
            if (sFormat != null) {
                sMessage = sFormat;
                int i = 0;
                while (i < cParamNames) {
                    String sParamName = aoParamName[i];
                    Object oParamValue = i < cParams ? aoParam[i] : null;
                    sMessage = Base.replace(sMessage, sParamName, this.formatParameter(sParamName, oParamValue));
                    ++i;
                }
            }
        }
        return sMessage;
    }

    protected String formatParameter(String sParamName, Object oParamValue) {
        String sParam = null;
        if (!(sParamName != null) ? false : sParamName.length() > 2) {
            switch (sParamName.charAt(1)) {
                case 'd': {
                    if (!(!sParamName.equals("{date}") ? false : oParamValue instanceof Timestamp) || !((sParam = oParamValue.toString()).length() < 23)) break;
                    sParam = (String.valueOf(sParam) + "000").substring(0, 23);
                    break;
                }
                case 'u': {
                    if (!(!sParamName.equals("{uptime}") ? false : oParamValue instanceof Long)) break;
                    long cMillisUp = (Long)oParamValue;
                    long cSec = cMillisUp / (long)1000;
                    long cMillis = cMillisUp % (long)1000;
                    if (cMillis < (long)10) {
                        sParam = String.valueOf(cSec) + ".00" + cMillis;
                        break;
                    }
                    if (cMillis < (long)100) {
                        sParam = String.valueOf(cSec) + ".0" + cMillis;
                        break;
                    }
                    sParam = String.valueOf(cSec) + "." + cMillis;
                    break;
                }
                case 'l': {
                    if (!(!sParamName.equals("{level}") ? false : oParamValue instanceof Integer)) break;
                    sParam = LEVEL_TEXT[(Integer)oParamValue];
                    break;
                }
                case 't': {
                    if (!sParamName.equals("{thread}") ? false : oParamValue instanceof Thread) {
                        sParam = ((Thread)oParamValue).getName();
                        int ofDecor = sParam.indexOf(THREAD_NAME_DELIM);
                        if (!(ofDecor > 0)) break;
                        sParam = sParam.substring(0, ofDecor);
                        break;
                    }
                    if (!sParamName.equals("{text}")) break;
                    sParam = oParamValue instanceof String ? (String)oParamValue : "";
                    break;
                }
            }
        }
        if (sParam == null) {
            return oParamValue == null ? "n/a" : oParamValue.toString();
        }
        return sParam;
    }

    public String getDefaultDestination() {
        return "stderr";
    }

    public String getDefaultFormat() {
        return "{date} &lt;{level}&gt; (thread={thread}): {text}";
    }

    public int getDefaultLevel() {
        return 10;
    }

    public int getDefaultLimit() {
        return 4096;
    }

    public String getDestination() {
        return this.__m_Destination;
    }

    public String getFormat() {
        return this.__m_Format;
    }

    protected static Integer[] getInteger() {
        return __s_Integer;
    }

    protected static Integer getInteger(int nIndex) {
        nIndex = nIndex < LEVEL_INTERNAL ? LEVEL_INTERNAL : nIndex;
        nIndex = nIndex > LEVEL_D9 ? LEVEL_D9 : nIndex;
        return __s_Integer[nIndex + 1];
    }

    public int getLevel() {
        return this.__m_Level;
    }

    public int getLimit() {
        return this.__m_Limit;
    }

    protected LogOutput getLogOutput() {
        return this.__m_LogOutput;
    }

    public String[] getParameters() {
        return this.__m_Parameters;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Logger".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Logger();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isEnabled(int nLevel) {
        return Logger.getInteger(nLevel) <= this.getLevel();
    }

    public void log(int nLevel, String sMessage, Object[] aoParam) {
        this.log(nLevel, null, sMessage, aoParam);
    }

    public void log(int nLevel, Throwable throwable, String sMessage, Object[] aoParam) {
        nLevel = nLevel < LEVEL_NONE ? LEVEL_NONE : nLevel;
        if ((nLevel = nLevel > LEVEL_ALL ? LEVEL_ALL : nLevel) <= this.getLevel()) {
            Object[] aoMessage = this.createMessage(nLevel, throwable, sMessage, aoParam);
            this.getQueue().add(aoMessage);
        }
    }

    public void log(int nLevel, Throwable throwable, Object[] aoParam) {
        this.log(nLevel, throwable, null, aoParam);
    }

    protected void onException(Throwable e) {
        System.err.println(String.valueOf("Logger: ") + e);
        e.printStackTrace(System.err);
    }

    public void onInit() {
        try {
            Logger$ShutdownHook hook = (Logger$ShutdownHook)this._findName("ShutdownHook");
            hook.register();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onInit();
    }

    protected void onLog() {
    }

    protected void onNotify() {
        int MAX_TOTAL = this.getLimit();
        int cchTotal = 0;
        boolean fTruncate = false;
        int cTruncate = 0;
        int cTruncateLines = 0;
        int cchTruncate = 0;
        boolean fDone = false;
        do {
            Object[] aoMessage;
            if ((aoMessage = (Object[])this.getQueue().removeNoWait()) == null) {
                if (!(!fTruncate ? false : cTruncate > 0)) break;
                aoMessage = new Object[]{new Timestamp(System.currentTimeMillis()), new Long(Base.getUpTimeMillis()), Logger.getInteger(LEVEL_WARNING), Thread.currentThread(), null, String.valueOf("Asynchronous logging character limit exceeded; discarding ") + cTruncate + " log messages " + "(lines=" + cTruncateLines + ", chars=" + cchTruncate + ")"};
                fDone = true;
            }
            if (aoMessage.length == 0) {
                this.setExiting(true);
                return;
            }
            Integer ILevel = (Integer)aoMessage[2];
            if (ILevel > this.getLevel()) continue;
            String sText = this.formatMessage(aoMessage);
            String sTextSafe = sText == null ? "" : sText;
            Throwable throwable = (Throwable)aoMessage[4];
            String sThrowable = throwable == null ? "" : Component.getStackTrace(throwable);
            if (sTextSafe == null) {
                sTextSafe = "";
            }
            cchTotal += sTextSafe.length() + sThrowable.length();
            if (!fTruncate ? false : fDone ^ true) {
                ++cTruncate;
                cTruncateLines += Base.parseDelimitedString(sTextSafe, '\n').length;
                cTruncateLines += Base.parseDelimitedString(sThrowable, '\n').length;
                cchTruncate += sTextSafe.length();
                cchTruncate += sThrowable.length();
                continue;
            }
            if (cchTotal > MAX_TOTAL) {
                fTruncate = true;
            }
            this.onLog();
            LogOutput out = this.getLogOutput();
            if (out == null) {
                try {
                    System.err.println(sTextSafe);
                    if (!(throwable != null)) continue;
                    throwable.printStackTrace();
                }
                catch (Throwable e) {}
                continue;
            }
            if (throwable == null) {
                out.log(ILevel, sTextSafe);
                continue;
            }
            if (sText == null) {
                out.log(ILevel, throwable);
                continue;
            }
            out.log(ILevel, throwable, sTextSafe);
        } while (fDone ^ true);
    }

    protected void setDestination(String sDestination) {
        this.__m_Destination = sDestination;
    }

    public void setFormat(String sFormat) {
        this.__m_Format = sFormat;
    }

    protected static void setInteger(int nIndex, Integer integer) {
        Logger.getInteger()[nIndex] = integer;
    }

    protected static void setInteger(Integer[] aInteger) {
        __s_Integer = aInteger;
    }

    public void setLevel(int nLevel) {
        this.__m_Level = nLevel;
    }

    public void setLimit(int nLimit) {
        this.__m_Limit = nLimit;
    }

    protected void setLogOutput(LogOutput output) {
        this.__m_LogOutput = output;
    }

    protected void setParameters(String[] asParams) {
        this.__m_Parameters = asParams;
    }

    public synchronized void shutdown() {
        Logger$ShutdownHook hook = (Logger$ShutdownHook)this._findName("ShutdownHook");
        hook.unregister();
        if (this.isStarted()) {
            this.getQueue().add(new Object[0]);
            try {
                try {
                    this.wait(1000);
                }
                catch (InterruptedException e) {
                    this.stop();
                }
                Object var3_4 = null;
                this.getLogOutput().close();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.getLogOutput().close();
                throw throwable;
            }
        }
        this.onNotify();
    }
}

