/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Logger;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.ConfigurableSerializerFactory;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicensedObject;
import com.tangosol.net.OperationalContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.HashHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.ServiceEvent;
import com.tangosol.util.ServiceListener;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Service
extends QueueProcessor
implements com.tangosol.util.Service {
    public static final int SERVICE_INITIAL = 0;
    public static final int SERVICE_STARTED = 2;
    public static final int SERVICE_STARTING = 1;
    public static final int SERVICE_STOPPED = 4;
    public static final int SERVICE_STOPPING = 3;
    private boolean __m_AcceptingClients;
    private transient ClassLoader __m_ContextClassLoader;
    private transient DaemonPool __m_DaemonPool;
    private transient Service$EventDispatcher __m_EventDispatcher;
    private Listeners __m_EventListeners;
    private OperationalContext __m_OperationalContext;
    private transient Serializer __m_Serializer;
    private SerializerFactory __m_SerializerFactory;
    private Map __m_SerializerMap;
    private XmlElement __m_ServiceConfig;
    private String __m_ServiceName;
    private int __m_ServiceState;
    private transient long __m_StatsCpu;
    private transient long __m_StatsReceived;
    private transient long __m_StatsReset;
    private static ListMap __mapChildren;

    static {
        Service.__initStatic();
    }

    public Service(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_EventListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Service$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    protected void addEventListener(EventListener l) {
        this.ensureEventDispatcher();
        this.getEventListeners().add(l);
    }

    public void addServiceListener(ServiceListener l) {
        this.addEventListener(l);
    }

    public static long adjustTimeout(long lDefaultTimeout, long lContextTimeout) {
        long TIMEOUT_DEFAULT = 0L;
        long TIMEOUT_NONE = -1L;
        return lContextTimeout == TIMEOUT_DEFAULT ? lDefaultTimeout : (lContextTimeout == TIMEOUT_NONE ? 0L : lContextTimeout);
    }

    public synchronized void configure(XmlElement xml) {
        if (this.getServiceState() > SERVICE_INITIAL) {
            throw new IllegalStateException();
        }
        OperationalContext ctx = this.getOperationalContext();
        if (ctx == null) {
            throw new IllegalStateException("missing required OperationalContext");
        }
        this.setServiceConfig(xml);
        if (xml != null) {
            XmlElement xmlSerializer;
            int cThreads = xml.getSafeElement("thread-count").getInt();
            if (cThreads > 0) {
                long cTimeoutMillis;
                DaemonPool pool = this.getDaemonPool();
                pool.setDaemonCount(cThreads);
                long cHungMillis = Service.parseTime(xml, "task-hung-threshold", 0L);
                if (cHungMillis > 0L) {
                    pool.setHungThreshold(cHungMillis);
                }
                if ((cTimeoutMillis = Service.parseTime(xml, "task-timeout", 0L)) > 0L) {
                    pool.setTaskTimeout(cTimeoutMillis);
                }
            }
            if (!((xmlSerializer = xml.getElement("serializer")) != null) ? false : XmlHelper.isEmpty(xmlSerializer) ^ true) {
                SerializerFactory factory;
                if (xmlSerializer.isEmpty()) {
                    ConfigurableSerializerFactory factoryImpl = new ConfigurableSerializerFactory();
                    factoryImpl.setConfig(xmlSerializer);
                    factory = factoryImpl;
                } else {
                    String sName = xmlSerializer.getString();
                    Map<String, SerializerFactory> mapSerializer = ctx.getSerializerMap();
                    factory = mapSerializer.get(sName);
                    if (factory == null) {
                        throw new IllegalArgumentException(String.valueOf("Serializer name \"") + sName + "\" is undefined:\n" + xmlSerializer);
                    }
                }
                this.setSerializerFactory(factory);
            }
        }
    }

    protected void dispatchEvent(EventObject evt, Listeners listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        EventListener[] aSyncListeners = listeners.getSynchronousListeners();
        EventListener[] aAsyncListeners = listeners.getAsynchronousListeners();
        Service$DispatchEvent task = this.instantiateDispatchEvent();
        task.setEvent(evt);
        if (aSyncListeners.length > 0) {
            try {
                task.setListeners(aSyncListeners);
                task.run();
            }
            catch (Throwable t) {
                Component._trace(String.valueOf("An exception occurred while dispatching the following event:\n") + String.valueOf(task), 1);
                Component._trace(t);
                Component._trace("The service thread has logged the exception and is continuing.", 1);
            }
        }
        if (aAsyncListeners.length > 0) {
            task.setListeners(aAsyncListeners);
            this.ensureEventDispatcher().getQueue().add(task);
        }
    }

    public void dispatchServiceEvent(int nEvent) {
        Listeners listeners = this.getEventListeners();
        if (listeners.isEmpty() ^ true) {
            this.dispatchEvent(new ServiceEvent(this, nEvent), listeners);
        }
    }

    public void drainEvents() {
        Service$EventDispatcher daemon = this.getEventDispatcher();
        if (daemon != null) {
            daemon.drainQueue();
        }
    }

    public Service$EventDispatcher ensureEventDispatcher() {
        Service$EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher == null) {
            dispatcher = (Service$EventDispatcher)this._findChild("EventDispatcher");
            if (this.isExiting() ^ true) {
                long cTimeout = this.getDefaultGuardTimeout();
                String sTimeout = System.getProperty("tangosol.coherence.events.timeout");
                if (sTimeout != null) {
                    try {
                        cTimeout = Long.parseLong(sTimeout);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (cTimeout > (long)0) {
                    this.guard(dispatcher.getGuardable(), cTimeout, this.getDefaultGuardRecovery());
                }
                dispatcher.setThreadGroup(this.getThreadGroup());
                dispatcher.start();
            }
            this.setEventDispatcher(dispatcher);
        }
        return dispatcher;
    }

    public Serializer ensureSerializer() {
        Serializer serializer = this.getSerializer();
        return serializer == null ? this.ensureSerializer(null) : serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer ensureSerializer(ClassLoader loader) {
        Serializer serializer;
        ClassLoader loaderCtx = this.getContextClassLoader();
        if (loader == null) {
            loader = loaderCtx;
        }
        if (!((serializer = this.getSerializer()) != null) ? false : (loader == loaderCtx ? true : serializer instanceof ClassLoaderAware ^ true)) {
            return serializer;
        }
        SerializerFactory factory = this.getSerializerFactory();
        if (factory == null) {
            serializer = ExternalizableHelper.ensureSerializer(loader);
        } else if (loader == loaderCtx) {
            serializer = this.instantiateSerializer(loader);
        } else {
            Map map;
            Map map2 = map = this.getSerializerMap();
            synchronized (map2) {
                serializer = (Serializer)map.get(loader);
                if (serializer == null) {
                    serializer = this.instantiateSerializer(loader);
                    map.put(loader, serializer);
                }
            }
        }
        if (loader == loaderCtx ? true : serializer instanceof ClassLoaderAware ^ true) {
            this.setSerializer(serializer);
        }
        return serializer;
    }

    public static String ensureStringValue(XmlElement xmlConfig, String sName, String sDefault) {
        String sValue = xmlConfig.getSafeElement(sName).getString(sDefault);
        if (sValue == null ? true : sValue.length() == 0) {
            throw new IllegalArgumentException(String.valueOf("the required \"") + sName + "\" configuration element is missing or empty");
        }
        return sValue;
    }

    public static String formatServiceStateName(int nState) {
        switch (nState) {
            case 0: {
                return "SERVICE_INITIAL";
            }
            case 1: {
                return "SERVICE_STARTING";
            }
            case 2: {
                return "SERVICE_STARTED";
            }
            case 3: {
                return "SERVICE_STOPPING";
            }
            case 4: {
                return "SERVICE_STOPPED";
            }
        }
        return "<unknown>";
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cTotal = Base.getSafeTimeMillis() - this.getStatsReset();
        long cMsgs = this.getStatsReceived();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        double dThru = cCpu == 0L ? 0.0 : (double)cMsgs * (double)1000 / (double)cCpu;
        dCpu = (double)((int)(dCpu * (double)1000)) / 10.0;
        StringBuffer sb = new StringBuffer();
        sb.append("Cpu=").append(cCpu).append("ms (").append(dCpu).append("%), Messages=").append(cMsgs).append(", Throughput=").append((float)dThru).append("msg/sec");
        DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            long cPoolTotal = pool.getStatsActiveMillis();
            long cTasks = pool.getStatsTaskCount();
            long cHung = pool.getStatsHungCount();
            float flAvgThread = cTotal == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTotal);
            float flAvgTask = cTasks == 0L ? 0.0f : (float)((double)cPoolTotal / (double)cTasks);
            sb.append(", AverageActiveThreadCount=").append(flAvgThread).append(", Tasks=").append(cTasks).append(", AverageTaskDuration=").append(flAvgTask).append("ms, MaximumBacklog=").append(pool.getStatsMaxBacklog());
            if (cHung > (long)0) {
                sb.append(", HungTaskCount=").append(cHung).append(", HungMaxDuration=").append(pool.getStatsHungDuration()).append(", HungMaxId=").append(pool.getStatsHungTaskId());
            }
        }
        return sb.toString();
    }

    public ClassLoader getContextClassLoader() {
        return this.__m_ContextClassLoader;
    }

    public DaemonPool getDaemonPool() {
        DaemonPool pool = this.__m_DaemonPool;
        if (pool == null) {
            pool = (DaemonPool)this._findChild("DaemonPool");
            this.setDaemonPool(pool);
        }
        return pool;
    }

    public String getDecoratedThreadName() {
        int nState = this.getServiceState();
        String sState = nState == SERVICE_STARTED ? "" : String.valueOf(Logger.THREAD_NAME_DELIM) + Service.formatServiceStateName(nState);
        return String.valueOf(this.getThreadName()) + sState;
    }

    public String getDescription() {
        return null;
    }

    public Service$EventDispatcher getEventDispatcher() {
        return this.__m_EventDispatcher;
    }

    public Listeners getEventListeners() {
        return this.__m_EventListeners;
    }

    public OperationalContext getOperationalContext() {
        return this.__m_OperationalContext;
    }

    public Serializer getSerializer() {
        return this.__m_Serializer;
    }

    public SerializerFactory getSerializerFactory() {
        return this.__m_SerializerFactory;
    }

    public Map getSerializerMap() {
        return this.__m_SerializerMap;
    }

    public XmlElement getServiceConfig() {
        return this.__m_ServiceConfig;
    }

    public String getServiceName() {
        String sName = this.__m_ServiceName;
        return sName == null ? this.get_Name() : sName;
    }

    public int getServiceState() {
        return this.__m_ServiceState;
    }

    public String getServiceStateName() {
        return Service.formatServiceStateName(this.getServiceState());
    }

    public long getStartupTimeout() {
        return 0L;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public String getThreadName() {
        return this.getServiceName();
    }

    public long getWaitMillis() {
        long cHungThreshold;
        long cWait = super.getWaitMillis();
        DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted() && (cHungThreshold = pool.getHungThreshold()) > 0L) {
            long cWaitHungCheck = Math.max(1L, Math.min(cHungThreshold >> 2, 1000L));
            cWait = cWait == 0L ? cWaitHungCheck : Math.min(cWait, cWaitHungCheck);
        }
        return cWait;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/Service".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public final Object get_Feed() {
        try {
            LicensedObject.LicenseData[] aLic = LicensedObject.getLicenseData();
            ArrayList<LicensedObject.LicenseData> list = new ArrayList<LicensedObject.LicenseData>();
            int nMaxType = -1;
            int i = 0;
            int c = aLic.length;
            while (i < c) {
                int nType;
                LicensedObject.LicenseData lic = aLic[i];
                if (LicensedObject.getLicenseFailure(lic) == null && (nType = lic.nLicenseType) >= nMaxType) {
                    nMaxType = nType;
                    list.add(lic);
                }
                ++i;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                LicensedObject.LicenseData lic = (LicensedObject.LicenseData)iter.next();
                if (!(lic.nLicenseType < nMaxType)) continue;
                iter.remove();
            }
            return list.toArray(new LicensedObject.LicenseData[list.size()]);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    private final Component get_Module() {
        return this;
    }

    protected void halt() {
        super.halt();
        ((Service$DaemonPool)this.getDaemonPool()).halt();
    }

    protected void heartbeat(long cMillis) {
        Service$DaemonPool pool = (Service$DaemonPool)this.getDaemonPool();
        if (pool.isStuck()) {
            this.checkGuardables();
            return;
        }
        super.heartbeat(cMillis);
    }

    protected Service$DispatchEvent instantiateDispatchEvent() {
        return (Service$DispatchEvent)this._newChild("DispatchEvent");
    }

    protected Serializer instantiateSerializer(ClassLoader loader) {
        return this.getSerializerFactory().createSerializer(loader);
    }

    public boolean isAcceptingClients() {
        return this.__m_AcceptingClients;
    }

    public boolean isRunning() {
        return !(this.getServiceState() == SERVICE_STARTED) ? false : this.isExiting() ^ true;
    }

    public boolean isServiceThread(boolean fStrict) {
        Thread thread = Thread.currentThread();
        Service$EventDispatcher dispatcher = this.getEventDispatcher();
        if (thread == this.getThread() ? true : (!(dispatcher != null) ? false : thread == dispatcher.getThread())) {
            return true;
        }
        if (fStrict ^ true) {
            DaemonPool pool = this.getDaemonPool();
            return !(pool != null) ? false : pool.getThreadGroup() == thread.getThreadGroup();
        }
        return false;
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
        this.setServiceState(SERVICE_STARTED);
    }

    public void onException(Throwable e) {
        if (this.getServiceState() < SERVICE_STARTED ? true : (!(this.getServiceState() == SERVICE_STARTED) ? false : this.isAcceptingClients() ^ true)) {
            this.setStartException(e);
        }
        super.onException(e);
    }

    protected void onExit() {
        Security security;
        DaemonPool pool;
        try {
            this.setServiceState(SERVICE_STOPPED);
        }
        catch (Throwable e) {
            Component._trace(String.valueOf("Exception occured during exiting:\n ") + Component.getStackTrace(e), 4);
        }
        super.onExit();
        Service$EventDispatcher daemon = this.getEventDispatcher();
        if (daemon != null) {
            daemon.stop();
            if (daemon.join(1000L) ^ true) {
                Component._trace(String.valueOf("failed to stop ") + daemon + "; abandoning", 2);
            }
        }
        if ((pool = this.getDaemonPool()).isStarted()) {
            List colDaemons;
            int cDaemons;
            pool.stop();
            if (pool.join(1000L) ^ true && (cDaemons = (colDaemons = pool.getDaemons()) == null ? 0 : colDaemons.size()) > 0) {
                Component._trace(String.valueOf("failed to stop ") + cDaemons + " worker threads; abandoning", 2);
            }
        }
        if ((security = Security.getInstance()) != null) {
            security.releaseSecureContext(this.getServiceName());
        }
    }

    protected void onNotify() {
        super.onNotify();
        DaemonPool pool = this.getDaemonPool();
        if (!pool.isStarted() ? false : pool.getHungThreshold() > 0L) {
            pool.checkHungTasks();
        }
    }

    public void onServiceStarted() {
        this.setAcceptingClients(true);
    }

    protected void onServiceStarting() {
    }

    protected void onServiceState(int nState) {
        switch (nState) {
            case 1: {
                this.onServiceStarting();
                break;
            }
            case 2: {
                this.onServiceStarted();
                break;
            }
            case 3: {
                this.onServiceStopping();
                break;
            }
            case 4: {
                this.onServiceStopped();
                break;
            }
            default: {
                Component._assert(false);
            }
        }
    }

    protected void onServiceStopped() {
        this.setAcceptingClients(false);
    }

    protected void onServiceStopping() {
        this.setAcceptingClients(false);
    }

    protected void onStartupTimeout() {
    }

    protected void onWait() throws InterruptedException {
        this.heartbeat();
        super.onWait();
    }

    protected static long parseTime(XmlElement xml, String sName, long cDefault) {
        return XmlHelper.parseTime(xml, sName, cDefault);
    }

    public Object readObject(ReadBuffer.BufferInput in) throws IOException {
        return this.ensureSerializer().deserialize(in);
    }

    public Object readObject(DataInput in) throws IOException {
        return this.ensureSerializer().deserialize(in instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)in : new WrapperBufferInput(in));
    }

    protected void removeEventListener(EventListener l) {
        this.getEventListeners().remove(l);
    }

    public void removeServiceListener(ServiceListener l) {
        this.removeEventListener(l);
    }

    public void resetStats() {
        this.getDaemonPool().resetStats();
        this.setStatsCpu(0L);
        this.setStatsReceived(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        this.__m_AcceptingClients = fAccepting;
        this.notifyAll();
    }

    public void setContextClassLoader(ClassLoader loader) {
        this.__m_ContextClassLoader = loader;
        if (this.getSerializer() != null) {
            this.setSerializer(null);
            this.ensureSerializer();
        }
    }

    protected void setDaemonPool(DaemonPool pool) {
        this.__m_DaemonPool = pool;
    }

    private void setEventDispatcher(Service$EventDispatcher daemon) {
        this.__m_EventDispatcher = daemon;
    }

    private void setEventListeners(Listeners listeners) {
        this.__m_EventListeners = listeners;
    }

    public void setOperationalContext(OperationalContext ctx) {
        Component._assert(this.getOperationalContext() == null);
        this.__m_OperationalContext = ctx;
    }

    protected void setSerializer(Serializer serializer) {
        this.__m_Serializer = serializer;
    }

    protected void setSerializerFactory(SerializerFactory factory) {
        this.__m_SerializerFactory = factory;
    }

    protected void setSerializerMap(Map map) {
        this.__m_SerializerMap = map;
    }

    public void setServiceConfig(XmlElement xml) {
        if (this.getServiceState() != SERVICE_INITIAL) {
            throw new IllegalStateException(String.valueOf("Configuration cannot be specified once the service has been started: ") + this);
        }
        this.__m_ServiceConfig = xml;
    }

    public void setServiceName(String sName) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ServiceName = sName;
    }

    public synchronized void setServiceState(int nState) {
        int nPrevState = this.getServiceState();
        if (nState > nPrevState) {
            this.__m_ServiceState = nState;
            this.onServiceState(nState);
            switch (nState) {
                case 1: {
                    this.dispatchServiceEvent(ServiceEvent.SERVICE_STARTING);
                    break;
                }
                case 2: {
                    this.dispatchServiceEvent(ServiceEvent.SERVICE_STARTED);
                    break;
                }
                case 3: {
                    this.dispatchServiceEvent(ServiceEvent.SERVICE_STOPPING);
                    break;
                }
                case 4: {
                    this.dispatchServiceEvent(ServiceEvent.SERVICE_STOPPED);
                    break;
                }
                default: {
                    Component._assert(false);
                }
            }
            this.updateServiceThreadName();
        } else {
            Component._assert(nState == nPrevState);
        }
        this.notifyAll();
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsReceived(long cMsgs) {
        this.__m_StatsReceived = cMsgs;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    public synchronized void shutdown() {
        this.stop();
        if (this.getThread() != Thread.currentThread()) {
            while (this.getDaemonState() != Daemon.DAEMON_EXITED) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread();
                    Thread.interrupted();
                    throw Base.ensureRuntimeException(e);
                }
            }
        }
    }

    public synchronized void start() {
        Component._assert(this.getServiceState() <= SERVICE_STARTED, String.valueOf("Service restart is illegal (ServiceName=") + this.getServiceName() + ')');
        super.start();
        long cTimeout = this.getStartupTimeout();
        long ldtCutoff = cTimeout > (long)0 ? Base.getSafeTimeMillis() + cTimeout : Long.MAX_VALUE;
        while (!(!this.isStarted() ? false : this.getServiceState() <= SERVICE_STARTED) ? false : this.isAcceptingClients() ^ true) {
            this.heartbeat();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException(e);
            }
            if (!(Base.getSafeTimeMillis() > ldtCutoff)) continue;
            this.onStartupTimeout();
            break;
        }
        if (this.getServiceState() != SERVICE_STARTED) {
            Throwable e = this.getStartException();
            String s = String.valueOf("Failed to start Service \"") + this.getServiceName() + "\" (ServiceState=" + this.getServiceStateName() + ')';
            throw e == null ? new RuntimeException(s) : new WrapperException(e, s);
        }
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            super.stop();
            if (this.getThread() == Thread.currentThread()) {
                this.setServiceState(SERVICE_STOPPED);
            }
        } else {
            this.setServiceState(SERVICE_STOPPED);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getServiceName()).append(", State=").append("(").append(this.getServiceStateName()).append(')');
        String sDesc = this.getDescription();
        if (!(sDesc != null) ? false : sDesc.length() > 0) {
            sb.append(", ").append(sDesc);
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString(String s) {
        return HashHelper.hash(s);
    }

    protected void updateServiceThreadName() {
        block2: {
            Thread thread = this.getThread();
            if (!(thread != null)) break block2;
            try {
                thread.setName(this.getDecoratedThreadName());
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAcceptingClients() {
        while (this.isAcceptingClients() ^ true) {
            Service service = this;
            synchronized (service) {
                if (this.getServiceState() != SERVICE_STARTED) {
                    Throwable e = this.getStartException();
                    String s = String.valueOf("Failed to start Service \"") + this.getServiceName() + "\" (ServiceState=" + this.getServiceStateName() + ')';
                    throw e == null ? new RuntimeException(s) : new WrapperException(e, s);
                }
                if (this.isAcceptingClients() ^ true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException(e);
                    }
                }
            }
        }
    }

    public void writeObject(WriteBuffer.BufferOutput out, Object o) throws IOException {
        this.ensureSerializer().serialize(out, o);
    }

    public void writeObject(DataOutput out, Object o) throws IOException {
        this.ensureSerializer().serialize(out instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)out : new WrapperBufferOutput(out), o);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new UnsupportedOperationException(String.valueOf("Service is not serializable: ") + this);
    }
}

