/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Member$FlowControl;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.util.Daemon;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$MemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher$ResendQueue$Iterator;
import com.tangosol.coherence.component.util.queue.OptimisticQueue;
import com.tangosol.util.Base;
import com.tangosol.util.CircularArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PacketPublisher$ResendQueue
extends OptimisticQueue {
    public static final long IMMEDIATE = -1L;
    private byte __m_DiagnosticTimeToLive;
    private long __m_DiagnosticWindowMillis;
    private volatile transient int __m_MultipointPacketCount;
    private int __m_ResendMillis;
    private int __m_TimeoutMillis;
    private static ListMap __mapChildren;

    static {
        PacketPublisher$ResendQueue.__initStatic();
    }

    public PacketPublisher$ResendQueue() {
        this(null, null, true);
    }

    public PacketPublisher$ResendQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setElementList(new CircularArrayList());
            this.setResendMillis(400);
            this.setTimeoutMillis(20000);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", PacketPublisher$ResendQueue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        MessagePacket packet = (MessagePacket)oElement;
        if (packet.isNackInProgress()) {
            return this.addHead(packet);
        }
        packet.setResendScheduled(packet.getSentMillis() + (long)this.getResendMillis());
        this.onPacketAdd(packet);
        return super.add(packet);
    }

    public boolean addAllHead(List listPackets, boolean fNack) {
        long ldtScheduled = Base.getSafeTimeMillis();
        List list = this.getElementList();
        int iInsert = 0;
        int cPackets = list.size();
        while (!(iInsert < cPackets) ? false : ((MessagePacket)list.get(iInsert)).getResendScheduled() <= ldtScheduled) {
            ++iInsert;
        }
        int iStart = 0;
        int iCurr = 0;
        Iterator iter = listPackets.iterator();
        while (iter.hasNext()) {
            MessagePacket packet = (MessagePacket)iter.next();
            packet.setResendScheduled(ldtScheduled);
            if (fNack) {
                if (packet.isNackInProgress()) {
                    if (iCurr != iStart) {
                        list.addAll(iInsert, listPackets.subList(iStart, iCurr));
                    }
                    iStart = ++iCurr;
                    continue;
                }
                packet.setNackInProgress(true);
            }
            this.onPacketAdd(packet);
            ++iCurr;
        }
        if (iStart == 0) {
            list.addAll(iInsert, listPackets);
        } else {
            list.addAll(iInsert, listPackets.subList(iStart, iCurr));
        }
        return true;
    }

    public boolean addHead(Object oElement) {
        MessagePacket packet = (MessagePacket)oElement;
        packet.setResendScheduled(IMMEDIATE);
        this.onPacketAdd(packet);
        List listPackets = this.getElementList();
        int iInsert = 0;
        int cPackets = listPackets.size();
        while (!(iInsert < cPackets) ? false : ((MessagePacket)listPackets.get(iInsert)).getResendScheduled() <= IMMEDIATE) {
            ++iInsert;
        }
        listPackets.add(iInsert, packet);
        return true;
    }

    public byte getDiagnosticTimeToLive() {
        return this.__m_DiagnosticTimeToLive;
    }

    public long getDiagnosticWindowMillis() {
        return this.__m_DiagnosticWindowMillis;
    }

    public WindowedArray getMessageOutgoing() {
        return ((PacketPublisher)this.get_Module()).getMessageOutgoing();
    }

    public int getMultipointPacketCount() {
        return this.__m_MultipointPacketCount;
    }

    public int getResendMillis() {
        return this.__m_ResendMillis;
    }

    public int getTimeoutMillis() {
        return this.__m_TimeoutMillis;
    }

    public long getWaitMillis() {
        MessagePacket packet = (MessagePacket)this.peekNoWait();
        if (packet == null) {
            return 0L;
        }
        long ldtScheduled = packet.getResendScheduled();
        if (ldtScheduled < 0L) {
            return -1L;
        }
        long cMillisWait = ldtScheduled - Base.getSafeTimeMillis();
        return cMillisWait <= 0L ? -1L : cMillisWait;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketPublisher$ResendQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketPublisher$ResendQueue();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void onInit() {
        this.setDiagnosticTimeToLive(Byte.parseByte(System.getProperty("tangosol.coherence.tcmp.diag.ttl", "2")));
        this.setDiagnosticWindowMillis(Long.parseLong(System.getProperty("tangosol.coherence.tcmp.diag.window", "2000")));
        super.onInit();
    }

    protected void onPacketAdd(MessagePacket packet) {
        if (packet.getResendTimeout() == 0L) {
            packet.setResendTimeout(packet.getSentMillis() + (long)this.getTimeoutMillis());
            if (packet.isOutgoingMultipoint()) {
                this.setMultipointPacketCount(this.getMultipointPacketCount() + 1);
            }
        }
    }

    protected void onPacketDone(MessagePacket packet) {
        long lMsgId;
        WindowedArray waMsg;
        Message msg;
        if (packet.isOutgoingMultipoint()) {
            this.setMultipointPacketCount(this.getMultipointPacketCount() - 1);
        }
        if ((msg = (Message)(waMsg = this.getMessageOutgoing()).get(lMsgId = packet.getFromMessageId())) == null) {
            Component._trace(String.valueOf("Encountered orphan packet:\n") + packet + "\nOutgoing Message Array:\n" + waMsg, 1);
            throw new IllegalStateException("Encountered orphan packet");
        }
        msg.setPacket(packet.getMessagePartIndex(), null);
        if (msg.getNullPacketCount() == msg.getMessagePartCount()) {
            msg.releaseOutgoing();
            if (lMsgId == waMsg.getFirstIndex()) {
                long lLastId = waMsg.getLastIndex();
                do {
                    waMsg.remove(lMsgId);
                    msg.checkNotifySent();
                    msg = null;
                    while (!(msg == null) ? false : lMsgId < lLastId) {
                        msg = (Message)waMsg.get(++lMsgId);
                    }
                } while (!(msg != null) ? false : msg.getNullPacketCount() == msg.getMessagePartCount());
            } else if (msg.isNotifySent() ^ true) {
                waMsg.remove(lMsgId);
            }
        }
    }

    protected void onPacketLost(Member member, MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        boolean fTimedout = packet.getPendingResendSkips() == 0;
        Member$FlowControl flowControl = member.getFlowControl();
        long ldtNow = Base.getLastSafeTimeMillis();
        if (!(flowControl != null) ? false : packet.isDeferrable()) {
            int iLostPacketThreshold;
            int cSeqLost = flowControl.getSequentialLostCount();
            flowControl.setSequentialLostCount(++cSeqLost);
            if (fTimedout && (!(!(!((iLostPacketThreshold = Member$FlowControl.getLostPacketThreshold()) > 0) ? false : cSeqLost > iLostPacketThreshold) ? false : flowControl.isPaused() ^ true) ? false : ldtNow - packet.getResendScheduled() < Daemon.getClockResolutionMillis())) {
                flowControl.setPaused(true);
            }
            packet.setDeliveryState(MessagePacket.DELIVERY_LOST, member);
            publisher.drainDeferredPackets(member);
        }
        if (!publisher.isNackEnabled() ? false : fTimedout) {
            member.getRecentPacketQueue().remove(packet);
        }
        if (!(member.isDeaf() ^ true) ? false : packet.getResendTimeout() - ldtNow < this.getDiagnosticWindowMillis()) {
            DiagnosticPacket packetDiag = new DiagnosticPacket();
            packetDiag.setToId(member.getId());
            packetDiag.setTimeToLive(this.getDiagnosticTimeToLive());
            publisher.sendDiagnosticPacket(packetDiag);
        }
    }

    protected void onPacketLost(MessagePacket packet) {
        PacketPublisher publisher = (PacketPublisher)this.get_Module();
        if (packet.isOutgoingMultipoint()) {
            PacketPublisher$MemberSet setTo = publisher.getMemberSetTemp();
            setTo.addAll((Collection)packet.getToMemberSet());
            int[] anToId = setTo.toIdArray();
            int i = 0;
            int c = anToId.length;
            while (i < c) {
                Member member = publisher.getMember(anToId[i]);
                if (member != null) {
                    this.onPacketLost(member, packet);
                }
                ++i;
            }
        } else {
            Member member = publisher.getMember(packet.getToId());
            if (member != null) {
                this.onPacketLost(member, packet);
            }
        }
        if (packet.isNackInProgress()) {
            packet.setNackInProgress(false);
        }
    }

    public Object peekNoWait() {
        List list = this.getElementList();
        while (list.isEmpty() ^ true) {
            MessagePacket packet = (MessagePacket)list.get(0);
            if (packet == null) {
                return null;
            }
            if (packet.isNackInProgress()) {
                packet.setNackInProgress(false);
                packet.setPendingResendSkips(packet.getPendingResendSkips() + 1);
            } else if (packet.getPendingResendSkips() > 0) {
                if (packet == list.remove(0)) {
                    packet.setPendingResendSkips(packet.getPendingResendSkips() - 1);
                    continue;
                }
                throw new IllegalStateException();
            }
            return packet;
        }
        return null;
    }

    public Object remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    public Object removeNoWait() {
        packet = (MessagePacket)this.peekNoWait();
        while (packet != null) {
            block7: {
                block8: {
                    block6: {
                        if (!packet.isResendNecessary()) ** GOTO lbl26
                        ldtScheduled = packet.getResendScheduled();
                        if (ldtScheduled > Base.getSafeTimeMillis()) break;
                        if (packet != super.removeNoWait()) {
                            throw new IllegalStateException();
                        }
                        ldtResendTimeout = packet.getResendTimeout();
                        ldtHeuristicTimeout = ldtResendTimeout - (long)(this.getTimeoutMillis() >> 2);
                        if (!(ldtScheduled > ldtHeuristicTimeout)) ** GOTO lbl-1000
                        publisher = (PacketPublisher)this.get_Module();
                        if (!(publisher.verifyResendNecessary(packet) ^ true)) break block6;
                        this.onPacketDone(packet);
                        break block7;
                    }
                    if (!(ldtScheduled <= ldtResendTimeout)) break block8;
                    publisher.onSlowPacket(packet);
                    ** GOTO lbl-1000
                }
                publisher.onUndeliverablePacket(packet);
                if (packet.isResendNecessary() ^ true) {
                    this.onPacketDone(packet);
                } else lbl-1000:
                // 3 sources

                {
                    this.onPacketLost(packet);
                    return packet;
lbl26:
                    // 1 sources

                    if (packet == super.removeNoWait()) {
                        this.onPacketDone(packet);
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
            packet = (MessagePacket)this.peekNoWait();
        }
        return null;
    }

    protected void setDiagnosticTimeToLive(byte cTrips) {
        this.__m_DiagnosticTimeToLive = cTrips;
    }

    protected void setDiagnosticWindowMillis(long cMillis) {
        this.__m_DiagnosticWindowMillis = cMillis;
    }

    protected void setMultipointPacketCount(int cPackets) {
        this.__m_MultipointPacketCount = cPackets;
    }

    public void setResendMillis(int cMillis) {
        this.__m_ResendMillis = Math.max(1, cMillis);
    }

    public void setTimeoutMillis(int cMillis) {
        this.__m_TimeoutMillis = Math.max(10, cMillis);
    }
}

