/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.packet.DiagnosticPacket;
import com.tangosol.coherence.component.net.packet.MessagePacket;
import com.tangosol.coherence.component.net.packet.NotifyPacket;
import com.tangosol.coherence.component.net.packet.messagePacket.Broadcast;
import com.tangosol.coherence.component.net.packet.messagePacket.Directed;
import com.tangosol.coherence.component.net.packet.messagePacket.Sequel;
import com.tangosol.coherence.component.net.packet.notifyPacket.Ack;
import com.tangosol.coherence.component.net.packet.notifyPacket.Request;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.WindowedArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketPublisher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor.PacketReceiver$InQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.net.internal.PacketComparator;
import com.tangosol.net.internal.PacketIdentifier;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.LongArray;
import com.tangosol.util.SimpleLongArray;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class PacketReceiver
extends PacketProcessor {
    private transient Queue __m_AckSendQueue;
    private transient Queue __m_ConfirmationQueue;
    private transient Grid __m_FlushPendingService;
    private transient long __m_GarbagePacketCount;
    private transient long __m_LastGarbageWarningMillis;
    private int __m_MaximumPacketLength;
    private transient boolean __m_NackEnabled;
    private PacketBufferPool __m_PacketAllocator;
    private int __m_PreferredPacketLength;
    private transient PacketPublisher __m_Publisher;
    private Grid[] __m_Service;
    private transient long __m_StatsReceived;
    private transient long __m_StatsRepeated;
    private transient long __m_StatsReset;

    public PacketReceiver() {
        this(null, null, true);
    }

    public PacketReceiver(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new PacketReceiver$InQueue("InQueue", this, true), "InQueue");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void checkReadyMessages(Member member) {
        long lMsgId;
        WindowedArray waMsg = member.getMessageIncoming();
        Message msg = (Message)waMsg.get(lMsgId = waMsg.getFirstIndex());
        if (msg == null) {
            return;
        }
        SparseArray laPile = member.getMessagePile();
        while (msg.getNullPacketCount() == 0) {
            waMsg.remove(lMsgId);
            long lFromMsgId = msg.getFromMessageId();
            if (msg.getMessagePartCount() > 1) {
                laPile.remove(lFromMsgId);
            }
            member.setLastIncomingMessageId(lFromMsgId);
            member.setContiguousFromPacketId(msg.getPacket(msg.getMessagePartCount() - 1));
            this.onMessage(msg);
            msg = (Message)waMsg.get(++lMsgId);
            if (!(msg == null)) continue;
            return;
        }
        int i = 1;
        int c = msg.getMessagePartCount();
        while (i < c) {
            if (msg.getPacket(i) == null) {
                member.setContiguousFromPacketId(msg.getPacket(i - 1));
                break;
            }
            ++i;
        }
    }

    protected void cleanup(Member member) {
        PacketBufferPool pool = this.getPacketAllocator();
        LongArray.Iterator iter = member.getMessagePile().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof LongArray)) continue;
            LongArray.Iterator iterPacket = ((LongArray)o).iterator();
            while (iterPacket.hasNext()) {
                pool.release(((MessagePacket)iterPacket.next()).getWriteBuffer());
            }
        }
        member.setMessagePile(null);
        WindowedArray la = member.getMessageIncoming();
        long li = la.getFirstIndex();
        long le = la.getLastIndex();
        while (li <= le) {
            Message msg = (Message)la.remove(li);
            if (msg == null) break;
            int i = 0;
            int c = msg.getMessagePartCount();
            while (i < c) {
                MessagePacket packet = msg.getPacket(i);
                if (packet != null) {
                    pool.release(packet.getWriteBuffer());
                }
                ++i;
            }
            li = la.getFirstIndex();
        }
        member.setMessageIncoming(null);
    }

    protected void confirm(Member member, MessagePacket packet) {
        boolean fNewAck;
        Packet packetAck;
        PacketIdentifier packetNewestFromId;
        if (this.isNackEnabled() && PacketComparator.compare(packet, packetNewestFromId = member.getNewestFromPacketId()) > 0) {
            member.setNewestFromPacketId(packet);
            packetAck = packet;
        }
        boolean bl = fNewAck = (packetAck = member.getPacketAck()) == null;
        if (fNewAck ^ true) {
            int cbPref = Math.min(this.getPreferredPacketLength(), member.getPreferredPacketLength());
            int cMaxSlots = (cbPref - Ack.LENGTH_FIXED) / Ack.LENGTH_VARIABLE;
            int cSlots = Math.min(cMaxSlots, member.getPreferredAckSize()) - ((NotifyPacket)packetAck).getNotifyCount();
            if (cSlots > 0) {
                ((Ack)packetAck).addPacket(packet);
                boolean bl2 = fNewAck = member.getPacketAck() != packetAck;
                if (!(fNewAck ^ true) ? false : cSlots == 1) {
                    ((Ack)packetAck).flush(member);
                    long ldtNow = Base.getSafeTimeMillis();
                    if (((NotifyPacket)packetAck).getScheduledMillis() > ldtNow) {
                        ((NotifyPacket)packetAck).setScheduledMillis(ldtNow);
                        this.getAckSendQueue().addHead(packetAck);
                    }
                }
            } else {
                fNewAck = true;
            }
        }
        if (fNewAck) {
            Queue queueAck = this.getAckSendQueue();
            packetAck = new Ack();
            packetAck.setFromId(this.getMemberId());
            packetAck.setToId(packet.getFromId());
            ((Ack)packetAck).addPacket(packet);
            queueAck.add(packetAck);
        }
    }

    protected void flushSend() {
        Grid service = this.getFlushPendingService();
        if (service != null) {
            service.getQueue().flush();
            this.setFlushPendingService(null);
        }
    }

    public String formatStats() {
        long cTotal = Base.getSafeTimeMillis() - this.getStartTimestamp();
        long lReceived = this.getStatsReceived();
        long lRepeated = this.getStatsRepeated();
        double dSuccess = lReceived == 0L ? 1.0 : 1.0 - (double)lRepeated / (double)lReceived;
        dSuccess = (double)((int)(dSuccess * (double)10000)) / 10000.0;
        return String.valueOf("PacketsReceived=") + lReceived + ", PacketsRepeated=" + lRepeated + ", SuccessRate=" + dSuccess;
    }

    public Queue getAckSendQueue() {
        return this.__m_AckSendQueue;
    }

    public Queue getConfirmationQueue() {
        return this.__m_ConfirmationQueue;
    }

    public Grid getFlushPendingService() {
        return this.__m_FlushPendingService;
    }

    public long getGarbagePacketCount() {
        return this.__m_GarbagePacketCount;
    }

    public long getLastGarbageWarningMillis() {
        return this.__m_LastGarbageWarningMillis;
    }

    public int getMaximumPacketLength() {
        return this.__m_MaximumPacketLength;
    }

    public Queue getMessageQueue(int i) {
        Grid service = this.getService(i);
        return service == null ? null : service.getQueue();
    }

    public PacketBufferPool getPacketAllocator() {
        return this.__m_PacketAllocator;
    }

    public int getPreferredPacketLength() {
        return this.__m_PreferredPacketLength;
    }

    public PacketPublisher getPublisher() {
        return this.__m_Publisher;
    }

    protected Grid[] getService() {
        return this.__m_Service;
    }

    public Grid getService(int i) {
        Grid[] aService = this.getService();
        return (!(aService != null) ? false : i < aService.length) ? aService[i] : null;
    }

    public long getStatsReceived() {
        return this.__m_StatsReceived;
    }

    public long getStatsRepeated() {
        return this.__m_StatsRepeated;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketReceiver".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PacketReceiver();
    }

    private final Component get_Module() {
        return this;
    }

    protected Message instantiateMessage(Member member, MessagePacket packet) {
        Message msg;
        int nType = packet.getMessageType();
        Grid service = this.getService(packet.getServiceId());
        if (service == null) {
            msg = new Message();
        } else {
            msg = service.instantiateMessage(nType);
            if (msg == null) {
                throw new IllegalStateException(String.valueOf("Failed to instantiate Message Type=") + nType + " for Service=" + service.getServiceName());
            }
        }
        msg.setDeserializationRequired(true);
        msg.setMessageType(nType);
        msg.setFromMember(member);
        msg.setMessagePartCount(packet.getMessagePartCount());
        msg.setPacket(0, packet);
        return msg;
    }

    protected Queue instantiateQueue() {
        return (Queue)this._findChild("InQueue");
    }

    public boolean isNackEnabled() {
        return this.__m_NackEnabled;
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    protected void onMalformedBuffer(WriteBuffer buffer, Exception e) {
        block5: {
            if (!(this.isExiting() ^ true)) break block5;
            try {
                ReadBuffer.BufferInput input = buffer.getReadBuffer().getBufferInput();
                input.reset();
                if (Packet.isForCoherence(input)) {
                    Component._trace(String.valueOf("An exception occurred while processing packet ") + Component.getStackTrace(e) + "\nexception will be ignored.", 2);
                    break block5;
                }
                long ldtNow = Base.getSafeTimeMillis();
                long ldtWarn = this.getLastGarbageWarningMillis();
                long cMillis = ldtNow - ldtWarn;
                long cJunk = this.getGarbagePacketCount() + 1L;
                if (cMillis > 10000L) {
                    this.setLastGarbageWarningMillis(ldtNow);
                    if (ldtWarn != 0L) {
                        long cRate = cJunk / (cMillis / 1000L);
                        Component._trace(String.valueOf("Dropped ") + cJunk + " non-Coherence packets (" + cRate + "/sec); ", cRate < 100L ? 4 : 2);
                        cJunk = 0L;
                    }
                }
                this.setGarbagePacketCount(cJunk);
            }
            catch (Throwable throwable) {}
        }
    }

    public void onMemberLeft(Member member) {
        this.getQueue().add(member);
    }

    public void onMessage(Message msg) {
        Grid service = msg.getService();
        if (service != null) {
            service.getQueue().add(msg);
            Grid servicePending = this.getFlushPendingService();
            if (servicePending != service) {
                if (servicePending != null) {
                    servicePending.getQueue().flush();
                }
                this.setFlushPendingService(service);
            }
        }
    }

    protected void onNotify() {
        WriteBuffer buffer = null;
        PacketBufferPool pool = this.getPacketAllocator();
        Queue queue = this.getQueue();
        Packet[] aPacket = new Packet[1];
        int nMemberId = this.getMemberId();
        try {
            Object oItem;
            while (!((oItem = queue.removeNoWait()) == null)) {
                if (oItem instanceof WriteBuffer) {
                    buffer = (WriteBuffer)oItem;
                    aPacket = Packet.extract(buffer, pool, aPacket, nMemberId);
                    int cPacket = aPacket.length;
                    int i = 0;
                    while (i < cPacket) {
                        Packet packet = aPacket[i];
                        if (packet == null) {
                            cPacket = i;
                            break;
                        }
                        this.onPacket(packet);
                        ++i;
                    }
                    this.setStatsReceived(this.getStatsReceived() + (long)cPacket);
                    continue;
                }
                if (!(oItem instanceof Member)) continue;
                this.cleanup((Member)oItem);
            }
        }
        catch (IOException e) {
            this.onMalformedBuffer(buffer, e);
        }
        catch (RuntimeException e) {
            if (this.isExiting()) {
                return;
            }
            throw e;
        }
    }

    protected void onPacket(Packet packet) {
        int nFromId = packet.getFromId();
        Member member = this.getMember(nFromId);
        if (member == null) {
            if (!(nFromId != 0) ? false : packet.getToId() != 0) {
                if (packet instanceof MessagePacket) {
                    this.getPacketAllocator().release(((MessagePacket)packet).getWriteBuffer());
                }
                return;
            }
        } else if (packet.isConfirmationRequired()) {
            MessagePacket msgPacket = (MessagePacket)packet;
            msgPacket.setFromMessageId(Packet.translateTrint((int)msgPacket.getFromMessageId(), member.getLastIncomingMessageId()));
            this.confirm(member, msgPacket);
        }
        int nType = packet.getPacketType();
        switch (nType) {
            case 232718546: {
                this.onPacketBroadcast(member, (Broadcast)packet);
                break;
            }
            case 232718547: 
            case 232718548: 
            case 232718549: {
                this.onPacketDirected(member, (Directed)packet);
                break;
            }
            case 232718551: 
            case 232718552: 
            case 232718553: {
                this.onPacketSequel(member, (Sequel)packet);
                break;
            }
            case 232718550: {
                this.onPacketRequest(member, (Request)packet);
                break;
            }
            case 232718545: {
                this.onPacketAck(member, (Ack)packet);
                break;
            }
            case 0xDDF00D0: {
                this.onPacketDiagnostic(member, (DiagnosticPacket)packet);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf("unknown packet type: ") + nType);
            }
        }
        if (member != null) {
            member.setStatsReceived(member.getStatsReceived() + (long)1);
        }
    }

    protected void onPacketAck(Member member, Ack packetAck) {
        if (member != null) {
            member.setPreferredAckSize(packetAck.getPreferredAckSize());
            this.getConfirmationQueue().add(packetAck);
        }
    }

    protected void onPacketBroadcast(Member member, Broadcast packet) {
        this.onMessage(this.instantiateMessage(member, packet));
    }

    protected void onPacketDiagnostic(Member member, DiagnosticPacket packetDiag) {
        block3: {
            String sClassPlugin;
            Component._trace(String.valueOf("Received ") + packetDiag + " regarding connection with " + member.toString(Member.SHOW_STATS), 5);
            byte cTTL = packetDiag.getTimeToLive();
            if (cTTL > 0) {
                DiagnosticPacket packetResp = new DiagnosticPacket();
                cTTL = (byte)(cTTL - 1);
                packetResp.setTimeToLive(cTTL);
                packetResp.setToId(packetDiag.getFromId());
                this.getPublisher().sendDiagnosticPacket(packetResp);
            }
            if (!((sClassPlugin = System.getProperty("tangosol.coherence.tcmp.diag.plugin")) != null)) break block3;
            try {
                ((Runnable)ClassHelper.newInstance(Class.forName(sClassPlugin), new Object[]{member})).run();
            }
            catch (Throwable e) {
                Component._trace(String.valueOf("Failed to run diagnostic plugin ") + sClassPlugin, 1);
                Component._trace(e);
            }
        }
    }

    protected void onPacketDirected(Member member, Directed packet) {
        if (member == null) {
            this.getPacketAllocator().release(((MessagePacket)packet).getWriteBuffer());
            return;
        }
        WindowedArray waMsg = member.getMessageIncoming();
        long lMsgFirst = waMsg.getFirstIndex();
        long lToMsgId = Packet.translateTrint(packet.getToMessageId(), lMsgFirst);
        if (!(lToMsgId >= lMsgFirst) ? false : waMsg.get(lToMsgId) == null) {
            Message msg = this.instantiateMessage(member, packet);
            waMsg.set(lToMsgId, msg);
            long lFromMsgId = packet.getFromMessageId();
            msg.setFromMessageId(lFromMsgId);
            if (msg.getMessagePartCount() > 1) {
                LongArray laSequel;
                SparseArray laPile = member.getMessagePile();
                if (laPile.isEmpty() ^ true && (laSequel = (LongArray)laPile.get(lFromMsgId)) != null) {
                    LongArray.Iterator iter = laSequel.iterator();
                    while (iter.hasNext()) {
                        Sequel packetSequel = (Sequel)iter.next();
                        msg.setPacket(packetSequel.getMessagePartIndex(), packetSequel);
                    }
                }
                laPile.set(lFromMsgId, msg);
            }
            if (lToMsgId == lMsgFirst) {
                this.checkReadyMessages(member);
            } else if (this.isNackEnabled()) {
                this.getPublisher().scheduleNack(member);
            }
        } else {
            this.setStatsRepeated(this.getStatsRepeated() + (long)1);
            member.setStatsRepeated(member.getStatsRepeated() + (long)1);
        }
    }

    protected void onPacketRequest(Member member, Request packet) {
        throw new UnsupportedOperationException();
    }

    protected void onPacketSequel(Member member, Sequel packet) {
        if (member == null) {
            this.getPacketAllocator().release(((MessagePacket)packet).getWriteBuffer());
            return;
        }
        SparseArray laPile = member.getMessagePile();
        long lLastMsgId = member.getLastIncomingMessageId();
        long lFromMsgId = packet.getFromMessageId();
        boolean fRepeated = false;
        if (lFromMsgId > lLastMsgId) {
            int iPart = packet.getMessagePartIndex();
            Object oVal = laPile.get(lFromMsgId);
            if (oVal instanceof Message) {
                Message msg = (Message)oVal;
                if (msg.getPacket(iPart) == null) {
                    msg.setPacket(iPart, packet);
                    WindowedArray waMsg = member.getMessageIncoming();
                    if (msg == waMsg.get(waMsg.getFirstIndex())) {
                        this.checkReadyMessages(member);
                    } else if (this.isNackEnabled()) {
                        this.getPublisher().scheduleNack(member);
                    }
                } else {
                    fRepeated = true;
                }
            } else {
                LongArray laSequel = (LongArray)oVal;
                if (laSequel == null) {
                    laSequel = new SimpleLongArray();
                    laPile.set(lFromMsgId, laSequel);
                } else {
                    boolean bl = fRepeated = laSequel.get(iPart) != null;
                }
                if (fRepeated ^ true) {
                    laSequel.set(iPart, packet);
                    if (this.isNackEnabled()) {
                        this.getPublisher().scheduleNack(member);
                    }
                }
            }
        } else {
            fRepeated = true;
        }
        if (fRepeated) {
            this.setStatsRepeated(this.getStatsRepeated() + (long)1);
            member.setStatsRepeated(member.getStatsRepeated() + (long)1);
        }
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public void resetStats() {
        this.setStatsReceived(0L);
        this.setStatsRepeated(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void setAckSendQueue(Queue queue) {
        Component._assert(queue != null);
        Component._assert(this.getAckSendQueue() == null);
        this.__m_AckSendQueue = queue;
    }

    public void setConfirmationQueue(Queue queue) {
        Component._assert(queue != null);
        Component._assert(this.getConfirmationQueue() == null);
        this.__m_ConfirmationQueue = queue;
    }

    protected void setFlushPendingService(Grid service) {
        this.__m_FlushPendingService = service;
    }

    protected void setGarbagePacketCount(long cPackets) {
        this.__m_GarbagePacketCount = cPackets;
    }

    protected void setLastGarbageWarningMillis(long ldtWarning) {
        this.__m_LastGarbageWarningMillis = ldtWarning;
    }

    public void setMaximumPacketLength(int cbMax) {
        Component._assert(this.getMaximumPacketLength() == 0, "MaximumPacketLength is not resettable");
        this.__m_MaximumPacketLength = cbMax;
    }

    public void setNackEnabled(boolean fUseRequestPackets) {
        this.__m_NackEnabled = fUseRequestPackets;
    }

    public void setPacketAllocator(PacketBufferPool allocator) {
        this.__m_PacketAllocator = allocator;
    }

    public void setPreferredPacketLength(int cBytes) {
        Component._assert(this.getPreferredPacketLength() == 0, "PreferredPacketLength is not resettable");
        this.__m_PreferredPacketLength = cBytes;
    }

    public void setPublisher(PacketPublisher publisher) {
        this.__m_Publisher = publisher;
    }

    public void setService(int i, Grid service) {
        Grid[] aService = this.getService();
        if (aService == null ? true : i >= aService.length) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            Grid[] aServiceNew = new Grid[cNew];
            if (aService != null) {
                System.arraycopy(aService, 0, aServiceNew, 0, aService.length);
            }
            aService = aServiceNew;
            this.setService(aServiceNew);
        }
        aService[i] = service;
    }

    protected void setService(Grid[] aService) {
        this.__m_Service = aService;
    }

    protected void setStatsReceived(long cPackets) {
        this.__m_StatsReceived = cPackets;
    }

    protected void setStatsRepeated(long cPackets) {
        this.__m_StatsRepeated = cPackets;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }
}

