/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Channel;
import com.tangosol.coherence.component.net.extend.Codec;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$AcceptChannel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$AcceptChannelResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$CloseChannel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$CloseConnection;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$CreateChannel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$EncodedMessage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$OpenChannel;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$OpenChannelResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$MessageFactory$OpenConnection;
import com.tangosol.io.ByteArrayReadBuffer;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicenseException;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.messaging.Channel;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.messaging.ConnectionManager;
import com.tangosol.net.messaging.Message;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.net.messaging.Request;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class Peer
extends Service
implements Channel.Receiver,
ConnectionManager {
    public static final boolean DEBUG = false;
    private com.tangosol.net.messaging.Codec __m_Codec;
    private Listeners __m_ConnectionListeners;
    private transient Map __m_MessageFactoryMap;
    private transient com.tangosol.net.Service __m_ParentService;
    private long __m_PingInterval;
    private transient long __m_PingLastCheckMillis;
    private transient long __m_PingLastMillis;
    private long __m_PingTimeout;
    private Protocol __m_Protocol;
    private Map __m_ProtocolMap;
    private transient Map __m_ReceiverMap;
    private long __m_RequestTimeout;
    private transient long __m_StatsBytesReceived;
    private transient long __m_StatsBytesSent;
    private transient long __m_StatsSent;
    private volatile transient long __m_StatsTimeoutCount;
    private transient List __m_WrapperStreamFactoryList;
    private transient Channel __m__Channel;
    private transient com.tangosol.coherence.component.net.extend.Connection __m__Connection;
    private static ListMap __mapChildren;
    private static transient String __s_LicenseError;
    private static transient UUID __s_ProcessId;
    private static /* synthetic */ Class __sf0;

    static {
        Peer._initStatic();
    }

    public Peer(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_ConnectionListeners = new Listeners();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Peer$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("com.tangosol.net.messaging.Codec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static void _initStatic$Default() {
        Peer.__initStatic();
    }

    protected static void _initStatic() {
        Peer._initStatic$Default();
        DEBUG = Boolean.getBoolean("tangosol.coherence.messaging.debug");
        Peer.setProcessId(new UUID());
    }

    public com.tangosol.net.messaging.Channel acceptChannel(com.tangosol.coherence.component.net.extend.Connection connection, URI uri, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$AcceptChannel request = (Peer$MessageFactory$AcceptChannel)factory0.createMessage(Peer$MessageFactory$AcceptChannel.TYPE_ID);
        request.setChannelUri(uri);
        request.setClassLoader(loader);
        request.setConnection(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setReceiver(receiver);
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        Peer$MessageFactory$AcceptChannelResponse response = (Peer$MessageFactory$AcceptChannelResponse)status.waitForResponse(this.getRequestTimeout());
        return (com.tangosol.net.messaging.Channel)response.getResult();
    }

    public void addConnectionListener(ConnectionListener l) {
        this.ensureEventDispatcher();
        this.getConnectionListeners().add(l);
    }

    protected WriteBuffer allocateWriteBuffer() {
        return new ByteArrayWriteBuffer(1024);
    }

    public Subject assertIdentityToken(Object oToken) {
        return this.getOperationalContext().getIdentityAsserter().assertIdentity(oToken, this.getParentService());
    }

    protected void checkPingTimeout(com.tangosol.coherence.component.net.extend.Connection connection) {
        long ldtPing;
        long cMillis = this.getPingTimeout();
        if (cMillis > 0L && (ldtPing = connection.getPingLastMillis()) > 0L && Base.getSafeTimeMillis() >= ldtPing + cMillis) {
            connection.close(false, new ConnectionException(String.valueOf("did not receive a response to a ping within ") + cMillis + " millis", (Connection)connection));
        }
    }

    protected void checkPingTimeouts() {
    }

    public void closeChannel(Channel channel, boolean fNotify, Throwable e) {
        this.closeChannel(channel, fNotify, e, true);
    }

    public void closeChannel(Channel channel, boolean fNotify, Throwable e, boolean fWait) {
        Component._assert(channel != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$CloseChannel request = (Peer$MessageFactory$CloseChannel)factory0.createMessage(Peer$MessageFactory$CloseChannel.TYPE_ID);
        request.setCause(e);
        request.setChannelClose(channel);
        request.setNotify(fNotify);
        if (fWait) {
            channel0.request(request);
        } else {
            channel0.send(request);
        }
    }

    public void closeConnection(com.tangosol.coherence.component.net.extend.Connection connection, boolean fNotify, Throwable e) {
        this.closeConnection(connection, fNotify, e, true);
    }

    public void closeConnection(com.tangosol.coherence.component.net.extend.Connection connection, boolean fNotify, Throwable e, boolean fWait) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$CloseConnection request = (Peer$MessageFactory$CloseConnection)factory0.createMessage(Peer$MessageFactory$CloseConnection.TYPE_ID);
        request.setCause(e);
        request.setConnectionClose(connection);
        request.setNotify(fNotify);
        if (fWait) {
            channel0.request(request);
        } else {
            channel0.send(request);
        }
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml == null) {
            return;
        }
        XmlElement xmlCat = xml.getSafeElement("outgoing-message-handler");
        this.setRequestTimeout(Service.parseTime(xmlCat, "request-timeout", this.getRequestTimeout()));
        this.setPingTimeout(Service.parseTime(xmlCat, "heartbeat-timeout", this.getRequestTimeout()));
        this.setPingInterval(Service.parseTime(xmlCat, "heartbeat-interval", this.getPingInterval()));
        if (this.getPingInterval() > 0L) {
            if (this.getPingTimeout() == 0L) {
                this.setPingTimeout(this.getPingInterval());
            } else {
                this.setPingTimeout(Math.min(this.getPingInterval(), this.getPingTimeout()));
            }
        }
        xmlCat = xml.getSafeElement("incoming-message-handler");
        super.configure(xmlCat);
        ClassLoader loader = this.getContextClassLoader();
        xmlCat = xml.getSafeElement("use-filters");
        Map<String, WrapperStreamFactory> mapFilter = this.getOperationalContext().getFilterMap();
        ArrayList<WrapperStreamFactory> list = new ArrayList<WrapperStreamFactory>();
        Iterator iter = xmlCat.getElements("filter-name");
        while (iter.hasNext()) {
            String sName = ((XmlElement)iter.next()).getString().trim();
            WrapperStreamFactory filter = mapFilter.get(sName);
            if (filter == null) {
                throw new IllegalArgumentException(String.valueOf("invalid filter-name ") + sName + " in use-filters:\n" + xmlCat);
            }
            list.add(filter);
        }
        if (list.isEmpty() ^ true) {
            this.setWrapperStreamFactoryList(new ImmutableArrayList(list));
        }
        if ((xmlCat = xml.getElement("message-codec")) != null) {
            this.setCodec((com.tangosol.net.messaging.Codec)XmlHelper.createInstance(xmlCat, loader, null, Peer.__sm0()));
        }
        this.setServiceConfig(xml);
    }

    public URI createChannel(com.tangosol.coherence.component.net.extend.Connection connection, Protocol protocol, ClassLoader loader, Channel.Receiver receiver) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$CreateChannel request = (Peer$MessageFactory$CreateChannel)factory0.createMessage(Peer$MessageFactory$CreateChannel.TYPE_ID);
        request.setClassLoader(loader);
        request.setConnection(connection);
        request.setProtocol(protocol);
        request.setReceiver(receiver);
        return (URI)channel0.request(request);
    }

    protected Message decodeMessage(ReadBuffer.BufferInput in, com.tangosol.coherence.component.net.extend.Connection connection, boolean fFilter) throws IOException {
        Channel channel;
        Component._assert(in != null);
        Component._assert(connection != null);
        com.tangosol.net.messaging.Codec codec = this.getCodec();
        Component._assert(codec != null);
        if (fFilter) {
            in = this.filterBufferInput(in);
        }
        if ((channel = (Channel)connection.getChannel(in.readPackedInt())) == null ? true : channel.isOpen() ^ true) {
            return null;
        }
        Message message = codec.decode(channel, in);
        message.setChannel(channel);
        return message;
    }

    public Object deserializeIdentityToken(byte[] abToken) {
        if (abToken != null) {
            try {
                ByteArrayReadBuffer buf = new ByteArrayReadBuffer(abToken);
                return this.ensureSerializer().deserialize(buf.getBufferInput());
            }
            catch (Exception e) {
                Component._trace(e, "An exception occurred while deserializing an identity token");
                throw new SecurityException("invalid identity token");
            }
        }
        return null;
    }

    protected void dispatchConnectionEvent(Connection connection, int nEvent, Throwable e) {
        Listeners listeners = this.getConnectionListeners();
        if (listeners.isEmpty() ^ true) {
            this.dispatchEvent(new ConnectionEvent(connection, nEvent, e), listeners);
        }
    }

    protected void encodeMessage(Message message, WriteBuffer.BufferOutput out, boolean fFilter) throws IOException {
        Component._assert(message != null);
        Component._assert(out != null);
        com.tangosol.net.messaging.Channel channel = message.getChannel();
        Component._assert(channel != null);
        com.tangosol.net.messaging.Codec codec = this.getCodec();
        Component._assert(codec != null);
        if (fFilter) {
            out = this.filterBufferOutput(out);
        }
        out.writePackedInt(channel.getId());
        codec.encode(channel, message, out);
        out.close();
    }

    protected ReadBuffer.BufferInput filterBufferInput(ReadBuffer.BufferInput in) throws IOException {
        List list = this.getWrapperStreamFactoryList();
        if (list == null ? true : list.isEmpty()) {
            return in;
        }
        InputStream stream = new WrapperDataInputStream(in);
        int i = 0;
        int c = list.size();
        while (i < c) {
            try {
                stream = ((WrapperStreamFactory)list.get(i)).getInputStream(stream);
            }
            catch (RuntimeException e) {
                Throwable t = Base.getOriginalException(e);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
            ++i;
        }
        DataInput din = stream instanceof DataInput ? (DataInput)((Object)stream) : new DataInputStream(stream);
        return new WrapperBufferInput(din);
    }

    protected WriteBuffer.BufferOutput filterBufferOutput(WriteBuffer.BufferOutput out) throws IOException {
        List list = this.getWrapperStreamFactoryList();
        if (list == null ? true : list.isEmpty()) {
            return out;
        }
        OutputStream stream = new WrapperDataOutputStream(out);
        int i = 0;
        int c = list.size();
        while (i < c) {
            try {
                stream = ((WrapperStreamFactory)list.get(i)).getOutputStream(stream);
            }
            catch (RuntimeException e) {
                Throwable t = Base.getOriginalException(e);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
            ++i;
        }
        DataOutput dout = stream instanceof DataOutput ? (DataOutput)((Object)stream) : new DataOutputStream(stream);
        return new WrapperBufferOutput(dout);
    }

    public String formatStats() {
        long cTotal = Math.max(System.currentTimeMillis() - this.getStatsReset(), 0L);
        long cbRcvd = this.getStatsBytesReceived();
        long cbSent = this.getStatsBytesSent();
        long cbpsIn = cTotal == 0L ? 0L : cbRcvd / cTotal * 1000L;
        long cbpsOut = cTotal == 0L ? 0L : cbSent / cTotal * 1000L;
        StringBuffer sb = new StringBuffer(super.formatStats());
        sb.append(", BytesReceived=").append(Base.toMemorySizeString(cbRcvd, false)).append(", BytesSent=").append(Base.toMemorySizeString(cbSent, false)).append(", ThroughputInbound=").append(Base.toBandwidthString(cbpsIn, false)).append(", ThroughputOutbound=").append(Base.toBandwidthString(cbpsOut, false));
        return sb.toString();
    }

    public Object generateIdentityToken(Subject subject) {
        return this.getOperationalContext().getIdentityTransformer().transformIdentity(subject, this.getParentService());
    }

    public com.tangosol.net.messaging.Codec getCodec() {
        return this.__m_Codec;
    }

    public Listeners getConnectionListeners() {
        return this.__m_ConnectionListeners;
    }

    public String getDescription() {
        com.tangosol.net.messaging.Codec codec;
        StringBuffer sb = new StringBuffer();
        DaemonPool pool = this.getDaemonPool();
        if (pool.isStarted()) {
            sb.append("ThreadCount=").append(pool.getDaemonCount()).append(", HungThreshold=").append(pool.getHungThreshold()).append(", TaskTimeout=").append(pool.getTaskTimeout());
        } else {
            sb.append("ThreadCount=0");
        }
        List list = this.getWrapperStreamFactoryList();
        if (!(list != null) ? false : list.isEmpty() ^ true) {
            sb.append(", Filters=[");
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().getClass().getName());
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
            sb.append(']');
        }
        if ((codec = this.getCodec()) != null) {
            sb.append(", Codec=").append(codec);
        }
        sb.append(", Serializer=").append(this.ensureSerializer().getClass().getName()).append(", PingInterval=").append(this.getPingInterval()).append(", PingTimeout=").append(this.getPingTimeout()).append(", RequestTimeout=").append(this.getRequestTimeout());
        return sb.toString();
    }

    public static String getLicenseError() {
        return __s_LicenseError;
    }

    protected Protocol.MessageFactory getMessageFactory() {
        Protocol protocol = this.getProtocol();
        return protocol.getMessageFactory(protocol.getCurrentVersion());
    }

    public Map getMessageFactoryMap() {
        return this.__m_MessageFactoryMap;
    }

    public String getName() {
        return this.getServiceName();
    }

    public com.tangosol.net.Service getParentService() {
        return this.__m_ParentService;
    }

    public long getPingInterval() {
        return this.__m_PingInterval;
    }

    public long getPingLastCheckMillis() {
        return this.__m_PingLastCheckMillis;
    }

    public long getPingLastMillis() {
        return this.__m_PingLastMillis;
    }

    public long getPingNextCheckMillis() {
        long ldtLast = this.getPingLastMillis();
        long cMillis = this.getPingTimeout();
        return ((cMillis == 0L ? true : ldtLast == 0L) ? true : this.getPingLastCheckMillis() > 0L) ? Long.MAX_VALUE : ldtLast + cMillis;
    }

    public long getPingNextMillis() {
        long ldtLast = this.getPingLastMillis();
        long cMillis = this.getPingInterval();
        return cMillis == 0L ? Long.MAX_VALUE : (ldtLast == 0L ? Base.getSafeTimeMillis() : ldtLast + cMillis);
    }

    public long getPingTimeout() {
        return this.__m_PingTimeout;
    }

    public static UUID getProcessId() {
        return __s_ProcessId;
    }

    public Protocol getProtocol() {
        Protocol protocol = this.__m_Protocol;
        if (protocol == null) {
            protocol = (Protocol)((Object)this._findChild("Protocol"));
            this.setProtocol(protocol);
        }
        return protocol;
    }

    public Protocol getProtocol(String sName) {
        return (Protocol)this.getProtocolMap().get(sName);
    }

    public Map getProtocolMap() {
        return this.__m_ProtocolMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getProtocols() {
        Map map;
        Map map2 = map = this.getProtocolMap();
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            return hashMap;
        }
    }

    public Channel.Receiver getReceiver(String sName) {
        return (Channel.Receiver)this.getReceiverMap().get(sName);
    }

    public Map getReceiverMap() {
        return this.__m_ReceiverMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getReceivers() {
        Map map;
        Map map2 = map = this.getReceiverMap();
        synchronized (map2) {
            HashMap hashMap = new HashMap(map);
            return hashMap;
        }
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public long getStatsBytesReceived() {
        return this.__m_StatsBytesReceived;
    }

    public long getStatsBytesSent() {
        return this.__m_StatsBytesSent;
    }

    public long getStatsSent() {
        return this.__m_StatsSent;
    }

    public long getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public long getWaitMillis() {
        long ldtNow;
        long cMillis = super.getWaitMillis();
        if (this.getPingInterval() > 0L) {
            ldtNow = Base.getLastSafeTimeMillis();
            long ldtNext = Math.min(this.getPingNextMillis(), this.getPingNextCheckMillis());
            long cNext = ldtNext > ldtNow ? ldtNext - ldtNow : -1L;
            long l = cMillis = cMillis == 0L ? cNext : Math.min(cNext, cMillis);
        }
        if (this.isGuardian()) {
            ldtNow = Base.getLastSafeTimeMillis();
            long cGuardMillis = Math.max(1L, this.getGuardSupport().getNextCheckTime() - ldtNow);
            cMillis = cMillis == 0L ? cGuardMillis : Math.min(cMillis, cGuardMillis);
        } else if (this.isGuarded()) {
            cMillis = cMillis == 0L ? 1000L : Math.min(cMillis, 1000L);
        }
        return cMillis;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Peer".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public Channel get_Channel() {
        return this.__m__Channel;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public com.tangosol.coherence.component.net.extend.Connection get_Connection() {
        return this.__m__Connection;
    }

    private final Component get_Module() {
        return this;
    }

    protected com.tangosol.coherence.component.net.extend.Connection instantiateConnection() {
        return null;
    }

    public void onChannelClosed(Channel channel) {
        if (!(channel.getId() != 0) ? false : Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Closed: ") + channel, 6);
        }
    }

    public void onChannelOpened(Channel channel) {
        if (!(channel.getId() != 0) ? false : Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Opened: ") + channel, 6);
        }
    }

    public void onConnectionClosed(com.tangosol.coherence.component.net.extend.Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        this.dispatchConnectionEvent(connection, ConnectionEvent.CONNECTION_CLOSED, null);
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Closed: ") + connection, 6);
        }
    }

    public void onConnectionError(com.tangosol.coherence.component.net.extend.Connection connection, Throwable e) {
        if (this.get_Connection() == connection) {
            return;
        }
        this.dispatchConnectionEvent(connection, ConnectionEvent.CONNECTION_ERROR, e);
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Closed: ") + connection + " due to:\n" + Component.getStackTrace(e), 6);
        }
    }

    public void onConnectionOpened(com.tangosol.coherence.component.net.extend.Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        this.dispatchConnectionEvent(connection, ConnectionEvent.CONNECTION_OPENED, null);
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Opened: ") + connection, 6);
        }
    }

    protected void onEnter() {
        this.get_Connection().openInternal();
        this.setStartTimestamp(Base.getSafeTimeMillis());
        this.resetStats();
        this.setServiceState(Service.SERVICE_STARTING);
        Channel channel = this.get_Channel();
        channel.send(channel.createMessage(Peer$MessageFactory$NotifyStartup.TYPE_ID));
    }

    protected void onExit() {
        this.get_Connection().closeInternal(false, null, -1L);
        super.onExit();
    }

    public void onInit() {
        if (Peer.getLicenseError() != null) {
            throw new LicenseException(String.valueOf("cannot instantiate ") + this.get_Name() + ": " + Peer.getLicenseError());
        }
        Protocol protocol = this.getProtocol();
        this.registerProtocol(protocol);
        com.tangosol.coherence.component.net.extend.Connection connection = new com.tangosol.coherence.component.net.extend.Connection();
        connection.setConnectionManager(this);
        connection.setId(Peer.getProcessId());
        connection.setMessageFactoryMap(Collections.singletonMap(protocol.getName(), protocol.getMessageFactory(protocol.getCurrentVersion())));
        Channel channel = (Channel)connection.getChannel(0);
        channel.setReceiver(this);
        this.set_Channel(channel);
        this.set_Connection(connection);
        super.onInit();
    }

    public void onMessage(Message message) {
        message.run();
    }

    protected void onMessageDecodeException(Throwable e, ReadBuffer.BufferInput in, com.tangosol.coherence.component.net.extend.Connection connection, boolean fFilter) {
        Channel channel;
        Component._trace(e, String.valueOf("An exception occurred while decoding a Message for Service=") + this.getServiceName() + " received from: " + connection);
        try {
            if (fFilter) {
                in = this.filterBufferInput(in);
            }
            channel = (Channel)connection.getChannel(in.readPackedInt());
        }
        catch (IOException ee) {
            channel = null;
        }
        if ((channel == null ? true : channel.isOpen() ^ true) ? true : channel.getId() == 0) {
            connection.close(true, e);
        } else {
            channel.close(true, e);
        }
    }

    protected void onMessageEncodeException(Throwable e, Message message) {
        Component._trace(e, String.valueOf("An exception occurred while encoding a ") + ClassHelper.getSimpleName(message.getClass()) + " for Service=" + this.getServiceName());
        Channel channel = (Channel)message.getChannel();
        if (channel.isOpen() ^ true ? true : channel.getId() == 0) {
            com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection();
            connection.setCloseOnExit(true);
            connection.setCloseNotify(true);
            connection.setCloseThrowable(e);
        } else {
            channel.setCloseOnExit(true);
            channel.setCloseNotify(true);
            channel.setCloseThrowable(e);
        }
    }

    protected void onNotify() {
        long ldtStart = Base.getSafeTimeMillis();
        long cMessage = this.getStatsReceived();
        long cbReceive = this.getStatsBytesReceived();
        DaemonPool pool = this.getDaemonPool();
        while (this.isExiting() ^ true) {
            com.tangosol.coherence.component.net.extend.Connection connection;
            Channel channel;
            Message message;
            if ((cMessage & 0x1FFL) == 511L) {
                this.heartbeat();
            }
            if ((message = (Message)this.getQueue().removeNoWait()) == null) break;
            ++cMessage;
            if (message instanceof Peer$MessageFactory$EncodedMessage) {
                Object var14_13;
                Peer$MessageFactory$EncodedMessage messageImpl = (Peer$MessageFactory$EncodedMessage)message;
                ReadBuffer rb = messageImpl.getReadBuffer();
                if (rb == null ? true : rb.length() == 0) continue;
                int cb = rb.length();
                com.tangosol.coherence.component.net.extend.Connection connection2 = messageImpl.getConnection();
                connection2.setStatsBytesReceived(connection2.getStatsBytesReceived() + (long)cb);
                cbReceive += (long)cb;
                try {
                    try {
                        message = this.decodeMessage(rb.getBufferInput(), connection2, true);
                    }
                    catch (Throwable e) {
                        this.onMessageDecodeException(e, rb.getBufferInput(), connection2, true);
                        var14_13 = null;
                        this.releaseReadBuffer(rb);
                        continue;
                    }
                    var14_13 = null;
                    this.releaseReadBuffer(rb);
                }
                catch (Throwable throwable) {
                    var14_13 = null;
                    this.releaseReadBuffer(rb);
                    throw throwable;
                }
                if (message == null) continue;
                if (!DEBUG ? false : Component._isTraceEnabled(6)) {
                    Component._trace(String.valueOf("Received: ") + message, 6);
                }
            }
            if (((channel = (Channel)message.getChannel()) == null ? true : channel.isOpen() ^ true) || ((connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection()) == null ? true : connection.isOpen() ^ true)) continue;
            connection.setStatsReceived(connection.getStatsReceived() + (long)1);
            if ((this == channel.getReceiver() ? true : pool.isStarted() ^ true) ? true : message.isExecuteInOrder()) {
                channel.receive(message);
                continue;
            }
            pool.add(message);
        }
        long ldtNow = Base.getSafeTimeMillis();
        if (ldtNow >= this.getPingNextCheckMillis()) {
            this.checkPingTimeouts();
            this.setPingLastCheckMillis(ldtNow);
        }
        if (ldtNow >= this.getPingNextMillis()) {
            this.ping();
            this.setPingLastCheckMillis(0L);
            this.setPingLastMillis(ldtNow);
        }
        this.setStatsReceived(cMessage);
        this.setStatsBytesReceived(cbReceive);
        this.setStatsCpu(this.getStatsCpu() + (ldtNow - ldtStart));
        super.onNotify();
    }

    public void onServiceStarted() {
        super.onServiceStarted();
        DaemonPool pool = this.getDaemonPool();
        if (pool.getDaemonCount() > 0) {
            pool.setThreadGroup(new ThreadGroup(this.getServiceName()));
            pool.start();
        }
        Component._trace(String.valueOf("Started: ") + this, 5);
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        if (this.getCodec() == null) {
            this.setCodec(new Codec());
        }
        HashMap<String, Protocol.MessageFactory> map = new HashMap<String, Protocol.MessageFactory>();
        Iterator iter = this.getProtocolMap().values().iterator();
        while (iter.hasNext()) {
            Protocol protocol = (Protocol)iter.next();
            int nVersion = protocol.getCurrentVersion();
            String sName = protocol.getName();
            Protocol.MessageFactory factory = protocol.getMessageFactory(nVersion);
            if (sName == null) {
                throw new IllegalArgumentException(String.valueOf("protocol has no name: ") + protocol);
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.valueOf("unsupported protocol version: ") + nVersion);
            }
            map.put(sName, factory);
        }
        this.setMessageFactoryMap(Collections.unmodifiableMap(map));
    }

    protected void onServiceStopped() {
        super.onServiceStopped();
        Component._trace(String.valueOf("Stopped: ") + this, 5);
    }

    public com.tangosol.net.messaging.Channel openChannel(com.tangosol.coherence.component.net.extend.Connection connection, Protocol protocol, String sName, ClassLoader loader, Channel.Receiver receiver, Subject subject) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$OpenChannel request = (Peer$MessageFactory$OpenChannel)factory0.createMessage(Peer$MessageFactory$OpenChannel.TYPE_ID);
        request.setClassLoader(loader);
        request.setConnection(connection);
        request.setIdentityToken(this.serializeIdentityToken(this.generateIdentityToken(subject)));
        request.setProtocol(protocol);
        request.setReceiver(receiver);
        request.setReceiverName(sName);
        request.setSubject(subject);
        Request.Status status = (Request.Status)channel0.request(request);
        Peer$MessageFactory$OpenChannelResponse response = (Peer$MessageFactory$OpenChannelResponse)status.waitForResponse(this.getRequestTimeout());
        return (com.tangosol.net.messaging.Channel)response.getResult();
    }

    public void openConnection(com.tangosol.coherence.component.net.extend.Connection connection) {
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        Peer$MessageFactory$OpenConnection request = (Peer$MessageFactory$OpenConnection)factory0.createMessage(Peer$MessageFactory$OpenConnection.TYPE_ID);
        request.setConnectionOpen(connection);
        Request.Status status = (Request.Status)channel0.request(request);
        if (status != null) {
            try {
                status.waitForResponse(this.getRequestTimeout());
            }
            catch (RequestTimeoutException e) {
                connection.close(false, e);
                throw e;
            }
        }
    }

    protected static long parseMemorySize(XmlElement xml, String sName, long cbDefault) {
        if (xml == null) {
            return cbDefault;
        }
        String sBytes = xml.getSafeElement(sName).getString();
        if (sBytes.length() == 0) {
            return cbDefault;
        }
        try {
            return Base.parseMemorySize(sBytes);
        }
        catch (RuntimeException e) {
            throw Base.ensureRuntimeException(e, String.valueOf("illegal \"") + sName + "\" value: " + sBytes);
        }
    }

    protected void ping() {
    }

    public void post(Message message) {
        com.tangosol.net.messaging.Channel channel;
        Component._assert(message != null);
        Service$EventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.drainOverflow();
        }
        Component._assert((channel = message.getChannel()) != null);
        if (!(this == channel.getReceiver()) ? false : message.getTypeId() < 0) {
            this.getQueue().add(message);
        } else {
            this.send(message);
        }
    }

    public void receive(ReadBuffer rb, com.tangosol.coherence.component.net.extend.Connection connection) {
        Component._assert(rb != null);
        Component._assert(connection != null);
        Channel channel0 = this.get_Channel();
        if (channel0 == null) {
            return;
        }
        Protocol.MessageFactory factory0 = channel0.getMessageFactory();
        if (factory0 == null) {
            return;
        }
        Peer$MessageFactory$EncodedMessage message = (Peer$MessageFactory$EncodedMessage)factory0.createMessage(Peer$MessageFactory$EncodedMessage.TYPE_ID);
        message.setChannel(channel0);
        message.setConnection(connection);
        message.setReadBuffer(rb);
        this.post(message);
    }

    public void registerChannel(com.tangosol.net.messaging.Channel channel) {
    }

    public void registerProtocol(Protocol protocol) {
        if (this.getServiceState() > Service.SERVICE_INITIAL) {
            throw new IllegalStateException();
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol cannot be null");
        }
        String sName = protocol.getName();
        if (sName == null) {
            throw new IllegalArgumentException(String.valueOf("missing protocol name: ") + protocol);
        }
        this.getProtocolMap().put(sName, protocol);
    }

    public void registerReceiver(Channel.Receiver receiver) {
        if (this.getServiceState() > Service.SERVICE_INITIAL) {
            throw new IllegalStateException();
        }
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        String sName = receiver.getName();
        if (sName == null) {
            throw new IllegalArgumentException(String.valueOf("missing receiver name: ") + receiver);
        }
        this.getReceiverMap().put(sName, receiver);
    }

    protected void releaseReadBuffer(ReadBuffer rb) {
    }

    protected void releaseWriteBuffer(WriteBuffer wb, Throwable e) {
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.getConnectionListeners().remove(l);
    }

    public void resetStats() {
        this.setStatsBytesReceived(0L);
        this.setStatsBytesSent(0L);
        this.setStatsSent(0L);
        this.setStatsTimeoutCount(0L);
        super.resetStats();
    }

    protected void send(Message message) {
        Channel channel = (Channel)message.getChannel();
        Component._assert(channel != null);
        Component._assert(channel.isActiveThread());
        WriteBuffer wb = this.allocateWriteBuffer();
        try {
            this.encodeMessage(message, wb.getBufferOutput(), true);
        }
        catch (Throwable e) {
            this.releaseWriteBuffer(wb, e);
            this.onMessageEncodeException(e, message);
            throw Base.ensureRuntimeException(e);
        }
        com.tangosol.coherence.component.net.extend.Connection connection = (com.tangosol.coherence.component.net.extend.Connection)channel.getConnection();
        try {
            connection.send(wb);
            this.releaseWriteBuffer(wb, null);
        }
        catch (Throwable e) {
            this.releaseWriteBuffer(wb, e);
            connection.setCloseOnExit(true);
            connection.setCloseNotify(false);
            connection.setCloseThrowable(e);
            throw Base.ensureRuntimeException(e);
        }
        this.setStatsSent(this.getStatsSent() + (long)1);
        this.setStatsBytesSent(this.getStatsBytesSent() + (long)wb.length());
        if (!DEBUG ? false : Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("Sent: ") + message, 6);
        }
    }

    public byte[] serializeIdentityToken(Object oToken) {
        if (oToken != null) {
            try {
                ByteArrayWriteBuffer buf = new ByteArrayWriteBuffer(1024);
                this.ensureSerializer().serialize(buf.getBufferOutput(), oToken);
                return buf.toByteArray();
            }
            catch (Exception e) {
                Component._trace(e, "An exception occurred while serializing an identity token");
                throw new SecurityException("unable to produce identity token");
            }
        }
        return null;
    }

    public void setCodec(com.tangosol.net.messaging.Codec codec) {
        this.__m_Codec = codec;
    }

    private void setConnectionListeners(Listeners listeners) {
        this.__m_ConnectionListeners = listeners;
    }

    protected static void setLicenseError(String sMsg) {
        __s_LicenseError = sMsg;
    }

    protected void setMessageFactoryMap(Map map) {
        this.__m_MessageFactoryMap = map;
    }

    public void setParentService(com.tangosol.net.Service service) {
        this.__m_ParentService = service;
    }

    protected void setPingInterval(long cMillis) {
        this.__m_PingInterval = cMillis;
    }

    protected void setPingLastCheckMillis(long ldt) {
        this.__m_PingLastCheckMillis = ldt;
    }

    protected void setPingLastMillis(long ldt) {
        this.__m_PingLastMillis = ldt;
    }

    protected void setPingTimeout(long cMillis) {
        this.__m_PingTimeout = cMillis;
    }

    protected static void setProcessId(UUID uuid) {
        Component._assert(uuid != null);
        __s_ProcessId = uuid;
    }

    protected void setProtocol(Protocol protocol) {
        this.__m_Protocol = protocol;
    }

    protected void setProtocolMap(Map map) {
        this.__m_ProtocolMap = map;
    }

    protected void setReceiverMap(Map map) {
        this.__m_ReceiverMap = map;
    }

    protected void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    protected void setStatsBytesReceived(long cb) {
        this.__m_StatsBytesReceived = cb;
    }

    protected void setStatsBytesSent(long cb) {
        this.__m_StatsBytesSent = cb;
    }

    protected void setStatsSent(long pStatsSent) {
        this.__m_StatsSent = pStatsSent;
    }

    protected void setStatsTimeoutCount(long cRequests) {
        this.__m_StatsTimeoutCount = cRequests;
    }

    protected void setWrapperStreamFactoryList(List list) {
        this.__m_WrapperStreamFactoryList = list;
    }

    protected void set_Channel(Channel channel) {
        this.__m__Channel = channel;
    }

    protected void set_Connection(com.tangosol.coherence.component.net.extend.Connection channel) {
        this.__m__Connection = channel;
    }

    public synchronized void shutdown() {
        Thread thread;
        if (this.isStarted() && this.getServiceState() < Service.SERVICE_STOPPING) {
            Channel channel = this.get_Channel();
            channel.send(channel.createMessage(Peer$MessageFactory$NotifyShutdown.TYPE_ID));
        }
        if ((thread = this.getThread()) != Thread.currentThread()) {
            while (!this.isStarted() ? false : this.getServiceState() < Service.SERVICE_STOPPED) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WrapperException(e);
                }
            }
            if (this.getServiceState() != Service.SERVICE_STOPPED) {
                this.stop();
            }
        }
    }

    public void unregisterChannel(com.tangosol.net.messaging.Channel channel) {
    }
}

