/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.DependentMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$QuorumRollCall;
import com.tangosol.net.Cluster;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.DeltaSet;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.NullImplementation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ClusterService$QuorumControl
extends Component
implements Cluster.MemberTimeoutAction {
    private Map __m_AnnouncingMembers;
    private Set __m_ConvictedMembers;
    private long __m_IncidentStartTime;
    private long __m_MoratoriumTimeMillis;
    private ClusterService$QuorumRollCall __m_PendingRollCall;
    private int __m_PresenceProofExpiry;
    private boolean __m_Suicide;

    public ClusterService$QuorumControl() {
        this(null, null, true);
    }

    public ClusterService$QuorumControl(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected boolean attemptDisconnect() {
        ClusterService service = this.getService();
        Set setConvicts = this.getConvictedMembers();
        if (Base.getSafeTimeMillis() < this.getMoratoriumTimeMillis()) {
            return false;
        }
        if (service.getActionPolicy().isAllowed(service, this)) {
            if (this.isSuicide()) {
                Component._trace("Stopping ClusterService", 2);
                service.onStopRunning();
            } else {
                Component._trace(String.valueOf("Timed-out members ") + setConvicts + " will be removed.", 2);
                Iterator iter = setConvicts.iterator();
                while (iter.hasNext()) {
                    service.doMemberLeft((Member)iter.next());
                }
            }
            this.onIncidentClosed();
            return true;
        }
        return false;
    }

    protected void doRollCall() {
        ClusterService service = this.getService();
        long ldtExpiry = Base.getSafeTimeMillis() + (long)this.getPresenceProofExpiry();
        ClusterService$QuorumRollCall msgRollCall = (ClusterService$QuorumRollCall)service.instantiateMessage("QuorumRollCall");
        msgRollCall.getRequestPoll().setExpiryTimeMillis(ldtExpiry);
        msgRollCall.setToMemberSet(service.getOthersMemberSet());
        this.setPendingRollCall(msgRollCall);
        service.send(msgRollCall);
    }

    protected long ensureIncidentStartTime(long ldtNow) {
        long ldtStart = this.getIncidentStartTime();
        if (ldtStart == 0L) {
            ldtStart = ldtNow;
            this.setIncidentStartTime(ldtStart);
        }
        return ldtStart;
    }

    protected long ensureMemberTimeoutStamp(Member member, long ldtNow) {
        long ldtTimeout = member.getLastTimeoutMillis();
        if (ldtTimeout == 0L) {
            ldtTimeout = ldtNow;
            member.setLastTimeoutMillis(ldtTimeout);
        }
        return ldtTimeout;
    }

    public String formatStatus() {
        Set setConvicts = this.getConvictedMembers();
        if (setConvicts.isEmpty()) {
            return "";
        }
        HashSet<String> setMachines = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("timed-out-members: {");
        Iterator iter = setConvicts.iterator();
        while (iter.hasNext()) {
            Member member = (Member)iter.next();
            sb.append(member.getId());
            setMachines.add(member.getMachineName());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}; machine-names: {");
        iter = setMachines.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public Set getAnnouncingMemberSet() {
        return new ImmutableArrayList(this.getAnnouncingMembers().values()).getSet();
    }

    public Map getAnnouncingMembers() {
        Map map = this.__m_AnnouncingMembers;
        if (map == null) {
            map = new LocalCache(Integer.MAX_VALUE, 2000);
            this.setAnnouncingMembers(map);
        }
        return map;
    }

    public Set getConvictedMembers() {
        return this.__m_ConvictedMembers;
    }

    public long getIncidentStartTime() {
        return this.__m_IncidentStartTime;
    }

    public long getMoratoriumTimeMillis() {
        return this.__m_MoratoriumTimeMillis;
    }

    public ClusterService$QuorumRollCall getPendingRollCall() {
        return this.__m_PendingRollCall;
    }

    public int getPresenceProofExpiry() {
        int cExpiryMillis = this.__m_PresenceProofExpiry;
        if (cExpiryMillis == 0) {
            cExpiryMillis = Integer.getInteger("tangosol.coherence.quorum.expirymillis", this.getService().getDeliveryTimeoutMillis() >> 2);
            this.setPresenceProofExpiry(cExpiryMillis);
        }
        return cExpiryMillis;
    }

    public Set getResponsiveMemberSet() {
        Member memberThis = this.getService().getThisMember();
        ClusterService$QuorumRollCall msgRollCall = this.getPendingRollCall();
        if (msgRollCall == null ? true : this.getConvictedMembers().contains(memberThis)) {
            return NullImplementation.getSet();
        }
        MemberSet setReplies = msgRollCall.getRequestPoll().getRespondedMemberSet();
        DeltaSet setHealthy = new DeltaSet(setReplies);
        setHealthy.add(memberThis);
        return Collections.unmodifiableSet(setHealthy);
    }

    public ClusterService getService() {
        return (ClusterService)this.get_Module();
    }

    public Set getTimedOutMemberSet() {
        return this.isSuicide() ? Collections.singleton(this.getService().getThisMember()) : Collections.unmodifiableSet(this.getConvictedMembers());
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$QuorumControl".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$QuorumControl();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isClusterSuspended() {
        return this.getPendingRollCall() != null;
    }

    public boolean isSuicide() {
        return this.__m_Suicide;
    }

    protected void onIncidentClosed() {
        ClusterService$QuorumRollCall msgRollCall = this.getPendingRollCall();
        if (msgRollCall != null) {
            msgRollCall.getRequestPoll().close();
            this.setPendingRollCall(null);
        }
        this.setIncidentStartTime(0L);
        this.setSuicide(false);
    }

    public void onInit() {
        DependentMemberSet setConvicts = new DependentMemberSet();
        setConvicts.setBaseSet(this.getService().getClusterMemberSet());
        this.setConvictedMembers(setConvicts);
        super.onInit();
    }

    public void onMemberAnnounceWaiting(Member member) {
        this.getAnnouncingMembers().put(member.getSocketAddress(), member);
    }

    public void onMemberJoined(Member member) {
        this.getAnnouncingMembers().remove(member.getSocketAddress());
    }

    public void onMemberLeft(Member member) {
        Set setConvicts = this.getConvictedMembers();
        if (!setConvicts.remove(member) ? false : setConvicts.isEmpty()) {
            this.onIncidentClosed();
        }
    }

    public void onMembersTimedOut(Set setTimedOut) {
        block4: {
            ClusterService$QuorumRollCall msgRollCall;
            ClusterService service = this.getService();
            Set setConvicts = this.getConvictedMembers();
            Member memberThis = service.getThisMember();
            long ldtNow = Base.getSafeTimeMillis();
            this.ensureIncidentStartTime(ldtNow);
            if (!this.isSuicide()) {
                if (setTimedOut.contains(memberThis)) {
                    this.setSuicide(true);
                    this.ensureMemberTimeoutStamp(memberThis, ldtNow);
                    setConvicts.clear();
                    setConvicts.add(memberThis);
                } else {
                    setConvicts.addAll(setTimedOut);
                    Iterator iter = setTimedOut.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        member.setDeaf(true);
                        this.ensureMemberTimeoutStamp(member, ldtNow);
                    }
                }
            }
            if (this.attemptDisconnect() || !((msgRollCall = this.getPendingRollCall()) == null)) break block4;
            String sAction = this.isSuicide() ? "Stopping the local ClusterService" : String.valueOf("Disconnect of suspect members ") + setConvicts;
            Component._trace(String.valueOf(sAction) + " is disallowed by the cluster quorum policy.", 3);
            this.doRollCall();
        }
    }

    public void onRollCallCompleted() {
        if ((!(this.getService().getServiceState() < Service.SERVICE_STOPPING) ? false : this.getConvictedMembers().isEmpty() ^ true) && !this.attemptDisconnect()) {
            this.doRollCall();
        }
    }

    public void onRollCallResponse(Member member) {
        ClusterService service = this.getService();
        Set setConvicts = this.getConvictedMembers();
        if (setConvicts.remove(member)) {
            long ldtNow = Base.getSafeTimeMillis();
            Component._trace(String.valueOf("Member ") + member.getId() + " (which had timed-out " + (ldtNow - member.getLastTimeoutMillis()) + "ms ago) has become available again.", 3);
            member.setLastTimeoutMillis(0L);
            member.setDeaf(false);
            if (setConvicts.isEmpty()) {
                this.onIncidentClosed();
            } else {
                this.setMoratoriumTimeMillis(ldtNow + (long)this.getPresenceProofExpiry());
            }
        } else if (!this.isSuicide() ? false : this.getPendingRollCall().getRequestPoll().isClosed()) {
            Member memberThis = service.getThisMember();
            long ldtNow = Base.getSafeTimeMillis();
            Component._trace(String.valueOf("Re-established connectivity with the rest of the cluster ") + "(which has been timed-out for " + (ldtNow - memberThis.getLastTimeoutMillis()) + "ms)", 3);
            memberThis.setLastTimeoutMillis(0L);
            setConvicts.clear();
            this.onIncidentClosed();
        } else {
            this.attemptDisconnect();
        }
    }

    protected void setAnnouncingMembers(Map setAnnounce) {
        this.__m_AnnouncingMembers = setAnnounce;
    }

    protected void setConvictedMembers(Set setConvicts) {
        this.__m_ConvictedMembers = setConvicts;
    }

    protected void setIncidentStartTime(long ldtStart) {
        this.__m_IncidentStartTime = ldtStart;
    }

    protected void setMoratoriumTimeMillis(long cMoratoriumMillis) {
        this.__m_MoratoriumTimeMillis = cMoratoriumMillis;
    }

    protected void setPendingRollCall(ClusterService$QuorumRollCall msgRollCall) {
        this.__m_PendingRollCall = msgRollCall;
    }

    protected void setPresenceProofExpiry(int cExpiryMillis) {
        this.__m_PresenceProofExpiry = cExpiryMillis;
    }

    protected void setSuicide(boolean fSuicide) {
        this.__m_Suicide = fSuicide;
    }
}

