/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.DualQueue;
import com.tangosol.util.Base;
import com.tangosol.util.Gate;
import com.tangosol.util.ThreadGateLite;

public class PartitionedService$PartitionControl
extends Component {
    public static final int LOCK_BACKUP_XFER_OUT = 1;
    public static final int LOCK_NONE = 0;
    public static final int LOCK_PENDING = 4;
    public static final int LOCK_PRIMARY_XFER_IN = 2;
    public static final int LOCK_PRIMARY_XFER_OUT = 3;
    public static final int STATE_MASK_LOCK = 7;
    public static final int STATE_MASK_PIN = 32;
    public static final int STATE_MASK_XFER = 24;
    public static final int STATE_SHIFT_LOCK = 0;
    public static final int STATE_SHIFT_PIN = 5;
    public static final int STATE_SHIFT_XFER = 3;
    public static final int XFER_NONE = 0;
    public static final int XFER_SENT = 2;
    public static final int XFER_STARTED = 1;
    private volatile int __m_PartitionState;

    public PartitionedService$PartitionControl() {
        this(null, null, true);
    }

    public PartitionedService$PartitionControl(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public synchronized void addUnlockAction(Runnable runnable) {
        this.getUnlockActions().add(runnable);
    }

    public void enableTransfer() {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread()) {
            gate.exit();
            this.setPartitionState(this.getPartitionState() & ~STATE_MASK_PIN | 0 << STATE_SHIFT_PIN);
        }
    }

    public boolean enter(long cWait) {
        return this.getGate().enter(cWait);
    }

    public void exit() {
        this.getGate().exit();
    }

    public Gate getGate() {
        return (Gate)this.get_Feed();
    }

    public int getLockType() {
        return (this.getPartitionState() & STATE_MASK_LOCK) >> STATE_SHIFT_LOCK & ~LOCK_PENDING;
    }

    public int getPartitionState() {
        return this.__m_PartitionState;
    }

    public int getTransferState() {
        return (this.getPartitionState() & STATE_MASK_XFER) >> STATE_SHIFT_XFER;
    }

    public DualQueue getUnlockActions() {
        return (DualQueue)this.get_Sink();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$PartitionControl".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$PartitionControl();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isLocked() {
        int nState = (this.getPartitionState() & STATE_MASK_LOCK) >> STATE_SHIFT_LOCK;
        return !(nState != 0) ? false : (nState & LOCK_PENDING) == 0;
    }

    public boolean isTransferPrevented() {
        return (this.getPartitionState() & STATE_MASK_PIN) >> STATE_SHIFT_PIN == 1;
    }

    public synchronized boolean lock(long cWait, int nLockType) {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread()) {
            return false;
        }
        int nLockTypeOld = this.getLockType();
        boolean fLocked = false;
        this.setLockType(nLockType | LOCK_PENDING);
        try {
            fLocked = this.getGate().close(cWait);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.setLockType(fLocked ? nLockType : nLockTypeOld);
            throw throwable;
        }
        Object var8_6 = null;
        this.setLockType(fLocked ? nLockType : nLockTypeOld);
        return fLocked;
    }

    public void onInit() {
        this.set_Feed(new ThreadGateLite());
        this.set_Sink(new DualQueue());
    }

    public void preventTransfer() {
        Gate gate = this.getGate();
        if (gate.isEnteredByCurrentThread() ^ true) {
            this.setPartitionState(this.getPartitionState() & ~STATE_MASK_PIN | 1 << STATE_SHIFT_PIN);
            gate.enter(0L);
        }
    }

    protected void setLockType(int nLockType) {
        this.setPartitionState(this.getPartitionState() & ~STATE_MASK_LOCK | nLockType << STATE_SHIFT_LOCK);
    }

    protected void setPartitionState(int nLockType) {
        this.__m_PartitionState = nLockType;
    }

    public synchronized void setTransferState(int nState) {
        this.setPartitionState(this.getPartitionState() & ~STATE_MASK_XFER | nState << STATE_SHIFT_XFER);
    }

    public String toString() {
        int nLockType = this.getLockType();
        String sLockType = "";
        switch (nLockType) {
            case 0: {
                sLockType = "NONE";
                break;
            }
            case 3: {
                sLockType = "[Outgoing Partition Transfer]";
                break;
            }
            case 2: {
                sLockType = "[Incoming Partition Transfer]";
                break;
            }
            case 1: {
                sLockType = "[Backup Transfer Snapshot]";
                break;
            }
            default: {
                sLockType = "[unknown]";
                break;
            }
        }
        int nXferState = this.getTransferState();
        String sXferState = "";
        switch (nXferState) {
            case 0: {
                sXferState = "NONE";
                break;
            }
            case 1: {
                sXferState = "[Transfer Started]";
                break;
            }
            case 2: {
                sXferState = "[Transfer Sent]";
                break;
            }
            default: {
                sXferState = "[unknown]";
                break;
            }
        }
        String sXferPrevented = this.isTransferPrevented() ? "true" : "false";
        return String.valueOf("PartitionControl{Lock=") + sLockType + ", TransferState=" + sXferState + ", TransferClosed=" + sXferPrevented + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock() {
        DualQueue queueActions = this.getUnlockActions();
        while (true) {
            Runnable runnable;
            if ((runnable = (Runnable)((Queue)queueActions).removeNoWait()) != null) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    Component._trace(String.valueOf("Caught ") + t + " while running deferred action:\n" + Base.getStackTrace(t), 1);
                }
                continue;
            }
            PartitionedService$PartitionControl partitionedService$PartitionControl = this;
            synchronized (partitionedService$PartitionControl) {
                if (((Queue)queueActions).isEmpty()) {
                    this.getGate().open();
                    this.setLockType(LOCK_NONE);
                    return;
                }
            }
        }
    }
}

