/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.ByteBufferManager;
import com.tangosol.io.nio.DirectBufferManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PartitionedCache$Storage$BackingManager
extends Util
implements BackingMapManager {
    public static final int BACKUP_CUSTOM = 3;
    public static final int BACKUP_FILE = 2;
    public static final int BACKUP_FLASHJOURNAL = 7;
    public static final int BACKUP_OFFHEAP = 1;
    public static final int BACKUP_ONHEAP = 0;
    public static final int BACKUP_RAMJOURNAL = 8;
    public static final int BACKUP_SCHEME = 4;
    public static final int FACTORY_ADAPTER = 5;
    public static final int KEY_INDEX = 6;
    private Class __m_BackupClass;
    private File __m_BackupDir;
    private int __m_BackupInitSize;
    private int __m_BackupMaxSize;
    private String __m_BackupScheme;
    private String __m_CacheName;
    private boolean __m_Partitioned;
    private int __m_Type;
    private static /* synthetic */ Class __sf0;

    public PartitionedCache$Storage$BackingManager() {
        this(null, null, true);
    }

    public PartitionedCache$Storage$BackingManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBackupInitSize(0x100000);
            this.setBackupMaxSize(0x40000000);
            this.setType(-1);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Class getBackupClass() {
        return this.__m_BackupClass;
    }

    protected File getBackupDir() {
        return this.__m_BackupDir;
    }

    protected int getBackupInitSize() {
        return this.__m_BackupInitSize;
    }

    protected int getBackupMaxSize() {
        return this.__m_BackupMaxSize;
    }

    protected String getBackupScheme() {
        return this.__m_BackupScheme;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public BackingMapManagerContext getContext() {
        return this.getService().getBackingMapContext();
    }

    public DefaultConfigurableCacheFactory getDefaultFactory() {
        DefaultConfigurableCacheFactory.Manager mgr = (DefaultConfigurableCacheFactory.Manager)this.getService().getBackingMapManager();
        return mgr.getCacheFactory();
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public PartitionedCache$Storage getStorage() {
        return (PartitionedCache$Storage)this.get_Parent();
    }

    public int getType() {
        return this.__m_Type;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$Storage$BackingManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedCache$Storage$BackingManager();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public void init(BackingMapManagerContext context) {
    }

    public Map instantiateBackingMap(String sName) {
        PartitionedCache service = this.getService();
        Map map = null;
        switch (this.getType()) {
            case 3: {
                try {
                    map = (Map)this.getBackupClass().newInstance();
                    if (!(map instanceof XmlConfigurable)) break;
                    XmlElement xmlBackup = service.getServiceConfig().getSafeElement("backup-storage");
                    ((XmlConfigurable)((Object)map)).setConfig(xmlBackup);
                }
                catch (Exception e) {
                    Component._trace(String.valueOf("Failed to create a 'custom' backup map: ") + e + "\nusing the 'on-heap' type instead", 1);
                }
                break;
            }
            case 2: {
                map = new BinaryMap(new MappedBufferManager(this.getBackupInitSize(), this.getBackupMaxSize(), this.getBackupDir()));
                break;
            }
            case 1: {
                map = new BinaryMap(new DirectBufferManager(this.getBackupInitSize(), this.getBackupMaxSize()));
                break;
            }
            case 4: {
                try {
                    DefaultConfigurableCacheFactory factory = this.getDefaultFactory();
                    DefaultConfigurableCacheFactory.CacheInfo info = factory.findSchemeMapping(this.getCacheName());
                    XmlElement xmlScheme = factory.resolveScheme(new DefaultConfigurableCacheFactory.CacheInfo(sName, this.getBackupScheme(), info.getAttributes()));
                    xmlScheme.addAttribute("target").setString("backup");
                    xmlScheme.addAttribute("partitioned").setString("false");
                    map = factory.configureBackingMap(info, xmlScheme, service.getBackingMapContext(), null, this.getStorage().getConfiguredBackupListeners());
                }
                catch (ClassCastException e) {
                    Component._trace(String.valueOf("\"Scheme\" backup is only supported by the ") + "com.tangosol.net.DefaultConfigurableCacheFactory" + "\nusing the 'on-heap' type instead", 1);
                }
                break;
            }
            case 7: 
            case 8: {
                String sScheme = this.getType() == BACKUP_FLASHJOURNAL ? "flashjournal-scheme" : "ramjournal-scheme";
                try {
                    DefaultConfigurableCacheFactory factory = this.getDefaultFactory();
                    SimpleElement xmlScheme = new SimpleElement(sScheme);
                    DefaultConfigurableCacheFactory.CacheInfo info = new DefaultConfigurableCacheFactory.CacheInfo(sName, sScheme, null);
                    xmlScheme.addAttribute("target").setString("backup");
                    xmlScheme.addAttribute("partitioned").setString("false");
                    map = factory.configureBackingMap(info, xmlScheme, service.getBackingMapContext(), null, this.getStorage().getConfiguredBackupListeners());
                }
                catch (Exception e) {
                    Component._trace(String.valueOf("Failed to create backup map of type ") + sScheme + " due to exception " + e, 1);
                }
                break;
            }
            case 6: {
                map = new ConcurrentHashMap();
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf("Unknown type: ") + this.getType());
            }
        }
        return map == null ? new SafeHashMap() : map;
    }

    public boolean isPartitioned() {
        return this.__m_Partitioned;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseConfiguration() {
        XmlElement xmlCache;
        DefaultConfigurableCacheFactory.CacheInfo info;
        DefaultConfigurableCacheFactory factory = this.getDefaultFactory();
        XmlElement xmlBackingMap = factory.resolveBackingMapScheme(info = factory.findSchemeMapping(this.getCacheName()), xmlCache = factory.resolveScheme(info));
        String sPartitioned = xmlBackingMap.getSafeAttribute("partitioned").getString();
        if ((sPartitioned.length() == 0 ? true : sPartitioned.equals("true")) ? true : sPartitioned.equals("observable")) {
            this.setPartitioned(true);
        } else {
            if (!sPartitioned.equals("false")) throw new IllegalStateException(String.valueOf("The partitioned element has an illegal value:") + sPartitioned);
            this.setPartitioned(false);
        }
        XmlElement xmlBackup = xmlCache.getElement("backup-storage");
        if (xmlBackup != null) {
            String sType = xmlBackup.getSafeElement("type").getString("on-heap");
            if (sType.equals("on-heap")) {
                this.setType(BACKUP_ONHEAP);
                return;
            }
            if (sType.equals("off-heap") ? true : sType.equals("file-mapped")) {
                long cbInit = Base.parseMemorySize(xmlBackup.getSafeElement("initial-size").getString("1"), Base.POWER_M);
                long cbMax = Base.parseMemorySize(xmlBackup.getSafeElement("maximum-size").getString("1024"), Base.POWER_M);
                int cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), (long)Integer.MAX_VALUE - (long)1023);
                int cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
                this.setBackupInitSize(cbInitSize);
                this.setBackupMaxSize(cbMaxSize);
                if (sType.equals("off-heap")) {
                    this.setType(BACKUP_OFFHEAP);
                    return;
                } else {
                    File dir;
                    String sPath = xmlBackup.getSafeElement("directory").getString();
                    if (sPath.length() > 0 && (dir = new File(sPath)).isDirectory()) {
                        this.setBackupDir(dir);
                    }
                    this.setType(BACKUP_FILE);
                }
                return;
            }
            if (sType.equals("custom")) {
                String sBackupClass = xmlBackup.getSafeElement("class-name").getString();
                try {
                    Class<?> clzBackup = this.getService().getContextClassLoader().loadClass(sBackupClass);
                    Component._assert(PartitionedCache$Storage$BackingManager.__sm0().isAssignableFrom(clzBackup));
                    this.setBackupClass(clzBackup);
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, String.valueOf("Invalid backup class: ") + sBackupClass);
                }
                this.setType(BACKUP_CUSTOM);
                return;
            }
            if (!sType.equals("scheme")) throw new IllegalArgumentException(String.valueOf("Unknown backup type: ") + sType);
            String sSchemeName = xmlBackup.getSafeElement("scheme-name").getString();
            this.setBackupScheme(sSchemeName);
            this.setType(BACKUP_SCHEME);
            return;
        }
        this.setType(BACKUP_ONHEAP);
        if (xmlBackingMap == null) return;
        boolean bl = false;
        if (bl) return;
        String sName = xmlBackingMap.getName();
        if (sName.equals("ramjournal-scheme")) {
            this.setType(Boolean.getBoolean("tangosol.coherence.journal.backuptoflash") ? BACKUP_FLASHJOURNAL : BACKUP_RAMJOURNAL);
            return;
        } else {
            if (!sName.equals("flashjournal-scheme")) return;
            this.setType(BACKUP_FLASHJOURNAL);
        }
    }

    public void releaseBackingMap(String sName, Map map) {
        block13: {
            if (!(map instanceof SafeHashMap ^ true)) break block13;
            try {
                switch (this.getType()) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        map.clear();
                        try {
                            ByteBufferManager bufferMgr = ((BinaryMap)map).getBufferManager();
                            ((MappedBufferManager)bufferMgr).close();
                        }
                        catch (ClassCastException e) {}
                        break;
                    }
                    case 1: {
                        map.clear();
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        try {
                            this.getDefaultFactory().release(map, this.getStorage().getConfiguredBackupListeners());
                        }
                        catch (ClassCastException e) {}
                        break;
                    }
                    case 0: 
                    case 6: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException(String.valueOf("Unknown type: ") + this.getType());
                    }
                }
            }
            catch (Exception e) {
                Component._trace(String.valueOf("Failed to invalidate backing map: ") + e, 2);
            }
        }
    }

    protected void setBackupClass(Class clzBackupClass) {
        this.__m_BackupClass = clzBackupClass;
    }

    protected void setBackupDir(File dir) {
        this.__m_BackupDir = dir;
    }

    protected void setBackupInitSize(int cInitSize) {
        this.__m_BackupInitSize = cInitSize;
    }

    protected void setBackupMaxSize(int cMaxSize) {
        this.__m_BackupMaxSize = cMaxSize;
    }

    protected void setBackupScheme(String sBackupScheme) {
        this.__m_BackupScheme = sBackupScheme;
    }

    public void setCacheName(String sCacheName) {
        this.__m_CacheName = sCacheName;
    }

    public void setPartitioned(boolean fPartitioned) {
        this.__m_Partitioned = fPartitioned;
    }

    public void setType(int iType) {
        this.__m_Type = iType;
    }
}

