/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$InvocationContext$StorageContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.io.Serializer;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.SafeComparator;
import java.util.Map;

public class PartitionedCache$Storage$BinaryEntry
extends Util
implements BinaryEntry,
MapTrigger.Entry {
    protected static final int KEY_BINARY = 1;
    protected static final int KEY_CONVERTED = 2;
    protected static final int ORIG_MASK = 196608;
    protected static final int ORIG_NONE = 65536;
    protected static final int ORIG_PRESENT = 131072;
    protected static final int VALUE_BINARY = 4;
    protected static final int VALUE_CONVERTED = 8;
    protected static final int VALUE_LOADED = 16;
    protected static final int VALUE_NONE = 32;
    protected static final int VALUE_READONLY = 64;
    protected static final int VALUE_REMOVED = 128;
    protected static final int VALUE_SYNTHETIC = 256;
    protected static final int VALUE_UPDATED = 512;
    private transient BackingMapContext __m_BackingMapContext;
    private Binary __m_BinaryKey;
    private Binary __m_BinaryValue;
    private transient Object __m_ConvertedKey;
    private transient Object __m_ConvertedValue;
    private transient int __m_State;

    public PartitionedCache$Storage$BinaryEntry() {
        this(null, null, true);
    }

    public PartitionedCache$Storage$BinaryEntry(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.set_Order(0.0f);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void checkMutable() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Read-only entry does not allow Map modifications");
        }
    }

    public int compareTo(Object o) {
        return SafeComparator.compareSafe(null, this.getBinaryKey(), ((PartitionedCache$Storage$BinaryEntry)o).getBinaryKey());
    }

    public void disableConversion() {
        this.setState(this.getState() | (KEY_BINARY | VALUE_BINARY));
    }

    public void ensureReadOnly() {
        this.setState(this.getState() | VALUE_READONLY);
    }

    public void ensureWriteable() {
        this.setState(this.getState() & ~VALUE_READONLY);
    }

    public boolean equals(Object obj) {
        return !(!(obj instanceof PartitionedCache$Storage$BinaryEntry) ? false : Base.equals(this.getBinaryKey(), ((PartitionedCache$Storage$BinaryEntry)obj).getBinaryKey())) ? false : Base.equals(this.getStorage(), ((PartitionedCache$Storage$BinaryEntry)obj).getStorage());
    }

    public void expire(long cMillis) {
        this.checkMutable();
        this.set_Order(cMillis);
        if (this.isPresent()) {
            this.updateBinaryValue(this.getBinaryValue());
        }
    }

    public Object extract(ValueExtractor extractor) {
        boolean fBinKey;
        Object oValue;
        MapIndex index;
        int nState = this.getState();
        if ((nState & (VALUE_UPDATED | VALUE_REMOVED | VALUE_LOADED)) == 0 && (index = this.getBackingMapContext().getIndexMap().get(extractor)) != null && MapIndex.NO_VALUE != (oValue = index.get(this.getBinaryKey()))) {
            return oValue;
        }
        boolean bl = fBinKey = (nState & KEY_BINARY) != 0;
        if (fBinKey) {
            this.setState(nState & ~KEY_BINARY);
        }
        try {
            Object object = InvocableMapHelper.extractFromEntry(extractor, this);
            Object var5_7 = null;
            if (fBinKey) {
                this.setState(this.getState() | KEY_BINARY);
            }
            return object;
        }
        catch (Throwable throwable) {
            block5: {
                Object var5_8 = null;
                if (!fBinKey) break block5;
                this.setState(this.getState() | KEY_BINARY);
            }
            throw throwable;
        }
    }

    public static String formatState(int nState) {
        StringBuffer sb = new StringBuffer();
        if ((nState & KEY_BINARY) != 0) {
            sb.append(" | KEY_BINARY");
        }
        if ((nState & KEY_CONVERTED) != 0) {
            sb.append(" | KEY_CONVERTED");
        }
        if ((nState & VALUE_BINARY) != 0) {
            sb.append(" | VALUE_BINARY");
        }
        if ((nState & VALUE_CONVERTED) != 0) {
            sb.append(" | VALUE_CONVERTED");
        }
        if ((nState & VALUE_NONE) != 0) {
            sb.append(" | VALUE_NONE");
        }
        if ((nState & VALUE_READONLY) != 0) {
            sb.append(" | VALUE_READONLY");
        }
        if ((nState & VALUE_REMOVED) != 0) {
            sb.append(" | VALUE_REMOVED");
        }
        if ((nState & VALUE_SYNTHETIC) != 0) {
            sb.append(" | VALUE_SYNTHETIC");
        }
        if ((nState & VALUE_UPDATED) != 0) {
            sb.append(" | VALUE_UPDATED");
        }
        if ((nState & VALUE_LOADED) != 0) {
            sb.append(" | VALUE_LOADED");
        }
        if ((nState & ORIG_PRESENT) != 0) {
            sb.append(" | ORIG_PRESENT");
        }
        if ((nState & ORIG_NONE) != 0) {
            sb.append(" | ORIG_NONE");
        }
        return sb.length() > 0 ? sb.substring(3) : "";
    }

    public ObservableMap getBackingMap() {
        return this.getBackingMapContext().getBackingMap();
    }

    public BackingMapContext getBackingMapContext() {
        BackingMapContext ctx = this.__m_BackingMapContext;
        return ctx == null ? (PartitionedCache$Storage)this.get_Parent() : ctx;
    }

    public Binary getBinaryKey() {
        return this.__m_BinaryKey;
    }

    public Binary getBinaryValue() {
        int nState;
        Binary binValue = this.__m_BinaryValue;
        if (binValue == null && ((nState = this.getState()) & VALUE_NONE) == 0) {
            if ((nState & VALUE_CONVERTED) != 0) {
                binValue = (Binary)this.getStorage().getConverterValueDown().convert(this.getConvertedValue());
            } else if (this.isOriginalPresent()) {
                binValue = this.getOriginalBinaryValue();
            } else {
                binValue = (Binary)this.getMap().get(this.getBinaryKey());
                if (binValue != null) {
                    this.setState(this.getState() | VALUE_LOADED);
                }
            }
            if (binValue == null) {
                this.setState(this.getState() | VALUE_NONE);
            } else {
                this.setBinaryValue(binValue);
            }
        }
        return binValue;
    }

    public BackingMapManagerContext getContext() {
        return this.getBackingMapContext().getManagerContext();
    }

    protected Object getConvertedKey() {
        return this.__m_ConvertedKey;
    }

    protected Object getConvertedValue() {
        return this.__m_ConvertedValue;
    }

    public Object getKey() {
        int nState = this.getState();
        if ((nState & KEY_BINARY) != 0) {
            return this.getBinaryKey();
        }
        if ((nState & KEY_CONVERTED) != 0) {
            return this.getConvertedKey();
        }
        Object oKey = this.getStorage().getConverterUp().convert(this.getBinaryKey());
        this.setConvertedKey(oKey);
        this.setState(nState | KEY_CONVERTED);
        return oKey;
    }

    public Map getMap() {
        return this.getBackingMap();
    }

    public Binary getOriginalBinaryValue() {
        Object binValue = this.get_Sink();
        if ((!(binValue == null) ? false : this.isOriginalPresent()) && !((binValue = this.getMap().get(this.getBinaryKey())) == null)) {
            this.set_Sink(binValue);
        }
        return (Binary)binValue;
    }

    public Object getOriginalValue() {
        Object oValue = this.get_Feed();
        if (oValue == null) {
            oValue = this.getStorage().getConverterUp().convert(this.getOriginalBinaryValue());
            this.set_Feed(oValue);
        }
        return oValue;
    }

    public Serializer getSerializer() {
        return this.getStorage().getService().getSerializer();
    }

    protected int getState() {
        return this.__m_State;
    }

    public PartitionedCache$Storage getStorage() {
        BackingMapContext ctx = this.getBackingMapContext();
        return ctx instanceof PartitionedCache$Storage ? (PartitionedCache$Storage)ctx : ((PartitionedCache$InvocationContext$StorageContext)ctx).getStorage();
    }

    public Object getValue() {
        int nState = this.getState();
        if ((nState & VALUE_BINARY) != 0) {
            return this.getBinaryValue();
        }
        if ((nState & VALUE_CONVERTED) != 0) {
            return this.getConvertedValue();
        }
        Object oValue = this.getStorage().getConverterUp().convert(this.getBinaryValue());
        this.setConvertedValue(oValue);
        this.setState(this.getState() | VALUE_CONVERTED);
        return oValue;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$Storage$BinaryEntry".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedCache$Storage$BinaryEntry();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public int hashCode() {
        Binary binKey = this.getBinaryKey();
        return binKey == null ? 0 : binKey.hashCode();
    }

    public boolean isOriginalPresent() {
        int nState = this.getState();
        if ((nState & ORIG_MASK) != 0) {
            return (nState & ORIG_PRESENT) != 0;
        }
        if (this.getMap().containsKey(this.getBinaryKey())) {
            this.setState(nState | ORIG_PRESENT);
            return true;
        }
        this.setState(nState | ORIG_NONE);
        return false;
    }

    public boolean isPresent() {
        int nState = this.getState();
        if ((nState & (VALUE_REMOVED | VALUE_NONE)) != 0) {
            return false;
        }
        return (nState & (VALUE_UPDATED | VALUE_LOADED)) != 0 ? true : this.isOriginalPresent();
    }

    public boolean isReadOnly() {
        return (this.getState() & VALUE_READONLY) != 0;
    }

    public boolean isSynthetic() {
        return (this.getState() & VALUE_SYNTHETIC) != 0;
    }

    public boolean isValueChanged() {
        return (this.getState() & (VALUE_UPDATED | VALUE_REMOVED)) != 0;
    }

    public boolean isValueConverted() {
        return (this.getState() & VALUE_CONVERTED) != 0;
    }

    public boolean isValueLoaded() {
        return (this.getState() & VALUE_LOADED) != 0;
    }

    public boolean isValueRemoved() {
        return (this.getState() & VALUE_REMOVED) != 0;
    }

    public boolean isValueUpdated() {
        return (this.getState() & VALUE_UPDATED) != 0;
    }

    public void remove(boolean fSynthetic) {
        this.checkMutable();
        this.setConvertedValue(null);
        this.setBinaryValue(null);
        int nState = (this.getState() | VALUE_CONVERTED | VALUE_REMOVED | VALUE_NONE) & ~VALUE_UPDATED;
        nState = fSynthetic ? (nState |= VALUE_SYNTHETIC) : (nState &= ~VALUE_SYNTHETIC);
        this.setState(nState);
    }

    public void reset(Binary binKey) {
        Component._assert(binKey != null);
        this.setState(this.getState() & (VALUE_READONLY | KEY_BINARY | VALUE_BINARY));
        this.setBinaryKey(binKey);
        this.setBinaryValue(null);
        this.set_Feed(null);
        this.set_Sink(null);
    }

    public void reset(Binary binKey, Binary binValue, Binary binOrigValue) {
        Component._assert(binKey != null);
        this.setState(this.getState() & (VALUE_READONLY | KEY_BINARY | VALUE_BINARY | ORIG_PRESENT));
        this.setBinaryKey(binKey);
        this.setBinaryValue(binValue);
        this.set_Feed(null);
        this.set_Sink(binOrigValue);
    }

    public void setBackingMapContext(BackingMapContext ctxBM) {
        this.__m_BackingMapContext = ctxBM;
    }

    public void setBinaryKey(Binary binKey) {
        this.__m_BinaryKey = binKey;
    }

    public void setBinaryValue(Binary binValue) {
        this.__m_BinaryValue = binValue;
    }

    protected void setConvertedKey(Object oKey) {
        this.__m_ConvertedKey = oKey;
    }

    protected void setConvertedValue(Object oValue) {
        this.__m_ConvertedValue = oValue;
    }

    protected void setState(int nState) {
        this.__m_State = nState;
    }

    public Object setValue(Object oValue) {
        this.checkMutable();
        Object oValueOld = this.getValue();
        this.setValue(oValue, false);
        return oValueOld;
    }

    public void setValue(Object oValue, boolean fSynthetic) {
        this.checkMutable();
        this.setConvertedValue(oValue);
        this.setBinaryValue(null);
        int nState = (this.getState() | VALUE_CONVERTED | VALUE_UPDATED) & ~(VALUE_REMOVED | VALUE_NONE);
        nState = fSynthetic ? (nState |= VALUE_SYNTHETIC) : (nState &= ~VALUE_SYNTHETIC);
        this.setState(nState);
    }

    public String toString() {
        int nState = this.getState();
        return String.valueOf(this.get_Name()) + "{Key=" + ((nState & KEY_CONVERTED) != 0 ? String.valueOf(this.getKey()) : this.toString(this.getBinaryKey())) + ", Value=" + ((nState & VALUE_CONVERTED) != 0 ? String.valueOf(this.getValue()) : this.toString(this.getBinaryValue())) + ", State=" + PartitionedCache$Storage$BinaryEntry.formatState(nState) + '}';
    }

    protected String toString(Binary binValue) {
        int MAX_BYTES = 512;
        int cb = binValue == null ? 0 : binValue.length();
        return cb <= MAX_BYTES ? String.valueOf(binValue) : String.valueOf("Binary(length=") + binValue.length() + ", value=" + Base.toHexEscape(binValue.toByteArray(0, MAX_BYTES)) + "...)";
    }

    public void update(ValueUpdater updater, Object oValue) {
        InvocableMapHelper.updateEntry(updater, this, oValue);
    }

    public void updateBinaryValue(Binary binValue) {
        this.checkMutable();
        if (binValue == null) {
            this.remove(true);
        } else {
            this.setState((this.getState() | VALUE_UPDATED) & ~(VALUE_REMOVED | VALUE_CONVERTED | VALUE_NONE));
            this.setBinaryValue(this.getStorage().encodeExpiry(binValue, (long)this.get_Order()));
        }
    }

    public void updateOriginalBinaryValue(Binary binValue) {
        this.set_Sink(binValue);
        if (binValue == null) {
            this.setState(this.getState() & ~ORIG_MASK | ORIG_NONE);
        } else {
            this.setState(this.getState() & ~ORIG_MASK | ORIG_PRESENT);
        }
    }
}

