/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.connection.JmsConnection;
import com.tangosol.coherence.component.net.extend.util.JmsUtil;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.JmsInitiator;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.util.Base;
import com.tangosol.util.SparseArray;
import com.tangosol.util.WrapperException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;

public class JmsInitiator$JmsConnection
extends JmsConnection {
    public JmsInitiator$JmsConnection() {
        this(null, null, true);
    }

    public JmsInitiator$JmsConnection(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setChannelArray(new SparseArray());
            this.setChannelPendingArray(new SparseArray());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/initiator/JmsInitiator$JmsConnection".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new JmsInitiator$JmsConnection();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public void open() {
        JmsInitiator initiator = (JmsInitiator)this.getConnectionManager();
        Component._assert(initiator != null);
        QueueReceiver receiver = null;
        QueueSession session = null;
        TemporaryQueue queueIn = null;
        try {
            Queue queueOut;
            Message reply;
            queueIn = initiator.getQueueSession().createTemporaryQueue();
            receiver = initiator.getQueueSession().createReceiver((Queue)queueIn);
            Message message = initiator.getQueueSession().createMessage();
            message.setJMSDeliveryMode(initiator.getMessageDeliveryMode());
            message.setJMSExpiration(initiator.getMessageExpiration());
            message.setJMSPriority(initiator.getMessagePriority());
            message.setJMSReplyTo((Destination)queueIn);
            initiator.getQueueSender().send(message);
            do {
                if ((reply = receiver.receive(initiator.getConnectTimeout())) == null) {
                    throw new JMSException(String.valueOf("did not receive a reply within ") + initiator.getConnectTimeout() + " millis");
                }
                Destination oQueue = reply.getJMSReplyTo();
                if (!(oQueue instanceof Queue)) {
                    throw new JMSException(String.valueOf("received an unexpected reply-to JMS") + " Destination: " + oQueue);
                }
                queueOut = (Queue)oQueue;
            } while (Base.equals(message.getJMSMessageID(), reply.getJMSCorrelationID()) ^ true);
            JmsUtil.close((MessageConsumer)receiver);
            session = initiator.getQueueConnection().createQueueSession(false, Session.DUPS_OK_ACKNOWLEDGE);
            this.setQueueIn((Queue)queueIn);
            this.setQueueOut(queueOut);
            this.setQueueSession(session);
            this.setMessageDeliveryMode(initiator.getMessageDeliveryMode());
            this.setMessageExpiration(initiator.getMessageExpiration());
            this.setMessagePriority(initiator.getMessagePriority());
            Component._trace(String.valueOf("Connected to ") + queueOut, 3);
        }
        catch (JMSException e) {
            JmsUtil.close(receiver);
            JmsUtil.close(session);
            JmsUtil.delete((Destination)queueIn);
            throw new ConnectionException("error opening JMS connection", e);
        }
        super.open();
    }
}

