/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dslquery.AbstractCoherenceQueryWalker;
import com.tangosol.coherence.dslquery.PropertyBuilder;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.BetweenFilter;
import com.tangosol.util.filter.ContainsAllFilter;
import com.tangosol.util.filter.ContainsAnyFilter;
import com.tangosol.util.filter.ContainsFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.GreaterEqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import com.tangosol.util.filter.LessFilter;
import com.tangosol.util.filter.LikeFilter;
import com.tangosol.util.filter.NeverFilter;
import com.tangosol.util.filter.NotEqualsFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.filter.OrFilter;
import com.tangosol.util.filter.XorFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FilterBuilder
extends AbstractCoherenceQueryWalker {
    private static HashMap ComparisonTable = new HashMap();
    protected Term m_target;
    protected Object m_out;
    protected AtomicTerm m_atom;
    protected Object[] m_bindings;
    protected Map m_bindingEnv;
    protected PropertyBuilder m_propertyBuilder;

    public FilterBuilder() {
        this(new Object[0], new HashMap());
    }

    public FilterBuilder(Object[] binds) {
        this(binds, new HashMap());
    }

    public FilterBuilder(Object[] binds, Map env) {
        this.m_bindings = binds;
        this.m_bindingEnv = env;
        this.m_propertyBuilder = new PropertyBuilder();
    }

    public FilterBuilder(Term term) {
        this();
        this.m_target = term;
    }

    public Filter makeFilter() {
        return this.makeFilter(this.m_target, this.m_bindings, this.m_bindingEnv);
    }

    public Filter makeFilter(Term term) {
        return this.makeFilter(term, this.m_bindings, this.m_bindingEnv);
    }

    public Filter makeFilter(Term term, Object[] binds) {
        return this.makeFilter(term, binds, this.m_bindingEnv);
    }

    public Filter makeFilter(Term term, Object[] binds, Map bindEnv) {
        this.m_target = term;
        this.m_out = null;
        this.m_bindings = binds;
        this.m_bindingEnv = bindEnv;
        this.m_target.accept(this);
        if (this.m_out instanceof Filter) {
            return (Filter)this.m_out;
        }
        if (this.m_out instanceof Boolean) {
            Boolean b = (Boolean)this.m_out;
            return b != false ? new AlwaysFilter() : new NeverFilter();
        }
        throw new RuntimeException("Filter not specified. " + this.m_out + " Found instead!");
    }

    public ValueExtractor makeExtractor(NodeTerm node) {
        this.m_target = node;
        this.m_out = null;
        this.m_target.accept(this);
        return (ValueExtractor)this.m_out;
    }

    @Override
    public void acceptAtom(String functor, AtomicTerm atom) {
        this.m_out = atom.getObject();
        this.m_atom = atom;
    }

    @Override
    protected void acceptLiteral(AtomicTerm atom) {
        this.m_out = atom.getObject();
        this.m_atom = atom;
    }

    @Override
    protected void acceptList(NodeTerm list) {
        int count = list.length();
        Object[] ll = new Object[count];
        for (int i = 1; i <= count; ++i) {
            list.termAt(i).accept(this);
            ll[i - 1] = this.m_out;
        }
        this.m_out = ll;
    }

    @Override
    protected void acceptIdentifier(String s) {
        this.m_out = s.equalsIgnoreCase("null") ? null : (s.equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : new ReflectionExtractor(this.m_propertyBuilder.extractorStringFor(s))));
    }

    @Override
    protected void acceptBinaryOperator(String op, Term left, Term right) {
        Term match = Terms.newTerm("unaryOperatorNode", AtomicTerm.createString("!"));
        if (op.equals("==") && right.getFunctor().equals(match.getFunctor()) && match.headChildrenTermEqual(right)) {
            op = "!=";
            right = right.termAt(2);
        }
        if (this.isComparison(op) && (right.getFunctor().equals("identifier") && !((AtomicTerm)right.termAt(1)).getValue().equalsIgnoreCase("null") && !((AtomicTerm)right.termAt(1)).getValue().equalsIgnoreCase("true") && !((AtomicTerm)right.termAt(1)).getValue().equalsIgnoreCase("false") || right.getFunctor().equals("derefNode") || right.getFunctor().equals("callNode"))) {
            op = this.transformOp(op);
            Term t = left;
            left = right;
            right = t;
        }
        left.accept(this);
        Object l = this.m_out;
        right.accept(this);
        Object r = this.m_out;
        if (op.equalsIgnoreCase("in") && l instanceof Filter) {
            this.m_out = new InKeySetFilter((Filter)l, this.makeSet(r));
        } else if (this.isLogical(op)) {
            this.m_out = op.equals("&&") ? new AndFilter((Filter)l, (Filter)r) : (op.equals("||") ? new OrFilter((Filter)l, (Filter)r) : (op.equals("^^") ? new XorFilter((Filter)l, (Filter)r) : null));
        } else if (this.isComparison(op)) {
            ValueExtractor re = (ValueExtractor)l;
            this.m_out = op.equals("==") ? new EqualsFilter(re, r) : (op.equals("!=") || op.equals("<>") ? new NotEqualsFilter(re, r) : (op.equals("<=") ? new LessEqualsFilter(re, (Comparable)r) : (op.equals(">=") ? new GreaterEqualsFilter(re, (Comparable)r) : (op.equals(">") ? new GreaterFilter(re, (Comparable)r) : (op.equals("<") ? new LessFilter(re, (Comparable)r) : null)))));
        } else {
            ValueExtractor re = (ValueExtractor)l;
            if (op.equalsIgnoreCase("in")) {
                this.m_out = new InFilter(re, this.makeSet(r));
            } else if (op.equalsIgnoreCase("contains_all")) {
                this.m_out = new ContainsAllFilter(re, this.makeSet(r));
            } else if (op.equalsIgnoreCase("contains_any")) {
                this.m_out = new ContainsAnyFilter(re, this.makeSet(r));
            } else if (op.equalsIgnoreCase("like")) {
                if (r.getClass().isArray()) {
                    Object[] a = (Object[])r;
                    char eschar = ((String)a[1]).charAt(0);
                    this.m_out = new LikeFilter(re, (String)a[0], eschar, false);
                } else {
                    this.m_out = new LikeFilter(re, (String)r, '\u0000', false);
                }
            } else if (op.equalsIgnoreCase("contains")) {
                this.m_out = new ContainsFilter(re, r);
            } else if (op.equalsIgnoreCase("between")) {
                Object[] a = (Object[])r;
                this.m_out = new BetweenFilter(re, (Comparable)a[0], (Comparable)a[1]);
            } else {
                this.m_out = null;
            }
        }
    }

    @Override
    protected void acceptUnaryOperator(String op, Term t) {
        if (op.equals("!")) {
            t.accept(this);
            this.m_out = new NotFilter((Filter)this.m_out);
        } else if (op.equals("-")) {
            t.accept(this);
            if (this.m_atom.isNumber()) {
                this.m_out = this.m_atom.negativeNumber((Number)this.m_out);
            }
        } else if (op.equals("+")) {
            t.accept(this);
        } else {
            this.m_out = null;
        }
    }

    @Override
    protected void acceptNumericBinding(int offset) {
        this.m_out = this.m_bindings[offset - 1];
    }

    @Override
    protected void acceptKeyedBinding(String key) {
        this.m_out = this.m_bindingEnv.get(key);
    }

    @Override
    protected void acceptCall(String function, NodeTerm args) {
        int count = args.length();
        Object[] oList = new Object[count];
        for (int i = 1; i <= count; ++i) {
            args.termAt(i).accept(this);
            oList[i - 1] = this.m_out;
        }
        this.m_out = function.equalsIgnoreCase("key") && count == 1 ? new KeyExtractor((ValueExtractor)oList[0]) : (function.equalsIgnoreCase("key") && count == 0 ? new KeyExtractor(IdentityExtractor.INSTANCE) : (function.equalsIgnoreCase("value") && count == 0 ? IdentityExtractor.INSTANCE : new ReflectionExtractor(function, oList)));
    }

    @Override
    protected void acceptPath(NodeTerm list) {
        int count = list.length();
        ValueExtractor[] veList = new ValueExtractor[count];
        for (int i = 1; i <= count; ++i) {
            list.termAt(i).accept(this);
            veList[i - 1] = (ValueExtractor)this.m_out;
        }
        this.m_out = new ChainedExtractor(veList);
    }

    protected Set makeSet(Object arg) {
        if (arg instanceof Set) {
            return (Set)arg;
        }
        HashSet<Object> s = new HashSet<Object>();
        if (arg instanceof Object[]) {
            Object[] list = (Object[])arg;
            for (int i = 0; i < list.length; ++i) {
                s.add(list[i]);
            }
        } else {
            s.add(arg);
        }
        return s;
    }

    protected String transformOp(String op) {
        return (String)ComparisonTable.get(op);
    }

    protected boolean isComparison(String op) {
        return ComparisonTable.containsKey(op);
    }

    protected boolean isLogical(String op) {
        return op.equals("&&") || op.equals("||") || op.equals("^^");
    }

    static {
        ComparisonTable.put("==", "==");
        ComparisonTable.put("!=", "!=");
        ComparisonTable.put("<>", "<>");
        ComparisonTable.put("<=", ">=");
        ComparisonTable.put(">=", "<=");
        ComparisonTable.put(">", "<");
        ComparisonTable.put("<", ">");
    }
}

