/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.util.Base;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.CompositeUpdater;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.extractor.ReflectionUpdater;
import java.util.ArrayList;

public class PropertyBuilder {
    protected String m_suppressPrefix = null;

    public PropertyBuilder() {
    }

    public PropertyBuilder(String prefix) {
        this.m_suppressPrefix = prefix;
    }

    public ValueExtractor extractorFor(String name) {
        return this.extractorFor(this.splitString(name, '.'));
    }

    public String extractorStringFor(String name) {
        return this.uniformStringFor(this.uniformArrayFor(this.splitString(name, '.'), "get"));
    }

    public String updaterStringFor(String name) {
        return this.uniformStringFor(this.uniformArrayFor(this.splitString(name, '.'), "set"));
    }

    public String propertyStringFor(String name) {
        return this.uniformStringFor(this.uniformArrayFor(this.splitString(name, '.'), ""));
    }

    public ValueUpdater updaterFor(String name) {
        return this.updaterFor(this.splitString(name, '.'));
    }

    public ValueExtractor extractorFor(String[] props) {
        String[] exts = this.uniformArrayFor(props, "get");
        if (exts.length == 1) {
            return new ReflectionExtractor(exts[0]);
        }
        ValueExtractor[] extractors = new ValueExtractor[exts.length];
        for (int i = 0; i < extractors.length; ++i) {
            extractors[i] = new ReflectionExtractor(exts[i]);
        }
        return new ChainedExtractor(extractors);
    }

    public ValueUpdater updaterFor(String[] props) {
        int partCount = props.length;
        String prop = props[partCount - 1];
        int start = 0;
        Base updater = new ReflectionUpdater(this.makeSimpleName("set", prop));
        if (this.m_suppressPrefix != null && props[0].equals(this.m_suppressPrefix)) {
            start = 1;
        }
        if (partCount - start > 1) {
            ValueExtractor[] extractors = new ValueExtractor[partCount - start - 1];
            for (int i = 0; i < extractors.length; ++i) {
                extractors[i] = new ReflectionExtractor(this.makeSimpleName("get", props[i + start]));
            }
            updater = new CompositeUpdater(new ChainedExtractor(extractors), (ValueUpdater)((Object)updater));
        }
        return updater;
    }

    public String makeSimpleName(String prefix, String name) {
        String sn;
        if (name.startsWith(prefix) && (sn = name.substring(prefix.length())).length() >= 1 && Character.isUpperCase(sn.charAt(0))) {
            return name;
        }
        return prefix + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected String[] uniformArrayFor(String[] props, String prefix) {
        int partCount = props.length;
        int start = 0;
        if (this.m_suppressPrefix != null && props[0].equals(this.m_suppressPrefix)) {
            start = 1;
        }
        String[] extractors = new String[partCount - start];
        for (int i = 0; i < extractors.length; ++i) {
            extractors[i] = this.makeSimpleName(prefix, props[i + start]);
        }
        return extractors;
    }

    protected String uniformStringFor(String[] parts) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parts.length; ++i) {
            sb.append('.').append(parts[i]);
        }
        return sb.substring(1);
    }

    public String[] splitString(String name, char delim) {
        if (name == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int prev = -1;
        while (true) {
            int next;
            if ((next = name.indexOf(delim, prev + 1)) < 0) break;
            list.add(name.substring(prev + 1, next));
            prev = next;
        }
        list.add(name.substring(prev + 1));
        return list.toArray(new String[list.size()]);
    }
}

